/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticache.model.CustomerNodeEndpoint;
import com.amazonaws.services.elasticache.model.StartMigrationRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class StartMigrationRequestMarshaller
implements Marshaller<Request<StartMigrationRequest>, StartMigrationRequest> {
    public Request<StartMigrationRequest> marshall(StartMigrationRequest startMigrationRequest) {
        if (startMigrationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)startMigrationRequest, "AmazonElastiCache");
        request.addParameter("Action", "StartMigration");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (startMigrationRequest.getReplicationGroupId() != null) {
            request.addParameter("ReplicationGroupId", StringUtils.fromString((String)startMigrationRequest.getReplicationGroupId()));
        }
        if (!startMigrationRequest.getCustomerNodeEndpointList().isEmpty() || !((SdkInternalList)startMigrationRequest.getCustomerNodeEndpointList()).isAutoConstruct()) {
            SdkInternalList customerNodeEndpointListList = (SdkInternalList)startMigrationRequest.getCustomerNodeEndpointList();
            int customerNodeEndpointListListIndex = 1;
            for (CustomerNodeEndpoint customerNodeEndpointListListValue : customerNodeEndpointListList) {
                if (customerNodeEndpointListListValue.getAddress() != null) {
                    request.addParameter("CustomerNodeEndpointList.member." + customerNodeEndpointListListIndex + ".Address", StringUtils.fromString((String)customerNodeEndpointListListValue.getAddress()));
                }
                if (customerNodeEndpointListListValue.getPort() != null) {
                    request.addParameter("CustomerNodeEndpointList.member." + customerNodeEndpointListListIndex + ".Port", StringUtils.fromInteger((Integer)customerNodeEndpointListListValue.getPort()));
                }
                ++customerNodeEndpointListListIndex;
            }
        }
        return request;
    }
}

