/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticache.model.CacheUsageLimits;
import com.amazonaws.services.elasticache.model.DataStorage;
import com.amazonaws.services.elasticache.model.ECPUPerSecond;
import com.amazonaws.services.elasticache.model.ModifyServerlessCacheRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyServerlessCacheRequestMarshaller
implements Marshaller<Request<ModifyServerlessCacheRequest>, ModifyServerlessCacheRequest> {
    public Request<ModifyServerlessCacheRequest> marshall(ModifyServerlessCacheRequest modifyServerlessCacheRequest) {
        CacheUsageLimits cacheUsageLimits;
        if (modifyServerlessCacheRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyServerlessCacheRequest, "AmazonElastiCache");
        request.addParameter("Action", "ModifyServerlessCache");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyServerlessCacheRequest.getServerlessCacheName() != null) {
            request.addParameter("ServerlessCacheName", StringUtils.fromString((String)modifyServerlessCacheRequest.getServerlessCacheName()));
        }
        if (modifyServerlessCacheRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)modifyServerlessCacheRequest.getDescription()));
        }
        if ((cacheUsageLimits = modifyServerlessCacheRequest.getCacheUsageLimits()) != null) {
            ECPUPerSecond eCPUPerSecond;
            DataStorage dataStorage = cacheUsageLimits.getDataStorage();
            if (dataStorage != null) {
                if (dataStorage.getMaximum() != null) {
                    request.addParameter("CacheUsageLimits.DataStorage.Maximum", StringUtils.fromInteger((Integer)dataStorage.getMaximum()));
                }
                if (dataStorage.getUnit() != null) {
                    request.addParameter("CacheUsageLimits.DataStorage.Unit", StringUtils.fromString((String)dataStorage.getUnit()));
                }
            }
            if ((eCPUPerSecond = cacheUsageLimits.getECPUPerSecond()) != null && eCPUPerSecond.getMaximum() != null) {
                request.addParameter("CacheUsageLimits.ECPUPerSecond.Maximum", StringUtils.fromInteger((Integer)eCPUPerSecond.getMaximum()));
            }
        }
        if (modifyServerlessCacheRequest.getRemoveUserGroup() != null) {
            request.addParameter("RemoveUserGroup", StringUtils.fromBoolean((Boolean)modifyServerlessCacheRequest.getRemoveUserGroup()));
        }
        if (modifyServerlessCacheRequest.getUserGroupId() != null) {
            request.addParameter("UserGroupId", StringUtils.fromString((String)modifyServerlessCacheRequest.getUserGroupId()));
        }
        if (!modifyServerlessCacheRequest.getSecurityGroupIds().isEmpty() || !((SdkInternalList)modifyServerlessCacheRequest.getSecurityGroupIds()).isAutoConstruct()) {
            SdkInternalList securityGroupIdsList = (SdkInternalList)modifyServerlessCacheRequest.getSecurityGroupIds();
            int securityGroupIdsListIndex = 1;
            for (String securityGroupIdsListValue : securityGroupIdsList) {
                if (securityGroupIdsListValue != null) {
                    request.addParameter("SecurityGroupIds.SecurityGroupId." + securityGroupIdsListIndex, StringUtils.fromString((String)securityGroupIdsListValue));
                }
                ++securityGroupIdsListIndex;
            }
        }
        if (modifyServerlessCacheRequest.getSnapshotRetentionLimit() != null) {
            request.addParameter("SnapshotRetentionLimit", StringUtils.fromInteger((Integer)modifyServerlessCacheRequest.getSnapshotRetentionLimit()));
        }
        if (modifyServerlessCacheRequest.getDailySnapshotTime() != null) {
            request.addParameter("DailySnapshotTime", StringUtils.fromString((String)modifyServerlessCacheRequest.getDailySnapshotTime()));
        }
        return request;
    }
}

