/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticache.model.CreateCacheSecurityGroupRequest;
import com.amazonaws.services.elasticache.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateCacheSecurityGroupRequestMarshaller
implements Marshaller<Request<CreateCacheSecurityGroupRequest>, CreateCacheSecurityGroupRequest> {
    public Request<CreateCacheSecurityGroupRequest> marshall(CreateCacheSecurityGroupRequest createCacheSecurityGroupRequest) {
        if (createCacheSecurityGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createCacheSecurityGroupRequest, "AmazonElastiCache");
        request.addParameter("Action", "CreateCacheSecurityGroup");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (createCacheSecurityGroupRequest.getCacheSecurityGroupName() != null) {
            request.addParameter("CacheSecurityGroupName", StringUtils.fromString((String)createCacheSecurityGroupRequest.getCacheSecurityGroupName()));
        }
        if (createCacheSecurityGroupRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createCacheSecurityGroupRequest.getDescription()));
        }
        if (!createCacheSecurityGroupRequest.getTags().isEmpty() || !((SdkInternalList)createCacheSecurityGroupRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)createCacheSecurityGroupRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue != null) {
                    if (tagsListValue.getKey() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.getKey()));
                    }
                    if (tagsListValue.getValue() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.getValue()));
                    }
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

