/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticache.model.CacheUsageLimits;
import com.amazonaws.services.elasticache.model.CreateServerlessCacheRequest;
import com.amazonaws.services.elasticache.model.DataStorage;
import com.amazonaws.services.elasticache.model.ECPUPerSecond;
import com.amazonaws.services.elasticache.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateServerlessCacheRequestMarshaller
implements Marshaller<Request<CreateServerlessCacheRequest>, CreateServerlessCacheRequest> {
    public Request<CreateServerlessCacheRequest> marshall(CreateServerlessCacheRequest createServerlessCacheRequest) {
        CacheUsageLimits cacheUsageLimits;
        if (createServerlessCacheRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createServerlessCacheRequest, "AmazonElastiCache");
        request.addParameter("Action", "CreateServerlessCache");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (createServerlessCacheRequest.getServerlessCacheName() != null) {
            request.addParameter("ServerlessCacheName", StringUtils.fromString((String)createServerlessCacheRequest.getServerlessCacheName()));
        }
        if (createServerlessCacheRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createServerlessCacheRequest.getDescription()));
        }
        if (createServerlessCacheRequest.getEngine() != null) {
            request.addParameter("Engine", StringUtils.fromString((String)createServerlessCacheRequest.getEngine()));
        }
        if (createServerlessCacheRequest.getMajorEngineVersion() != null) {
            request.addParameter("MajorEngineVersion", StringUtils.fromString((String)createServerlessCacheRequest.getMajorEngineVersion()));
        }
        if ((cacheUsageLimits = createServerlessCacheRequest.getCacheUsageLimits()) != null) {
            ECPUPerSecond eCPUPerSecond;
            DataStorage dataStorage = cacheUsageLimits.getDataStorage();
            if (dataStorage != null) {
                if (dataStorage.getMaximum() != null) {
                    request.addParameter("CacheUsageLimits.DataStorage.Maximum", StringUtils.fromInteger((Integer)dataStorage.getMaximum()));
                }
                if (dataStorage.getUnit() != null) {
                    request.addParameter("CacheUsageLimits.DataStorage.Unit", StringUtils.fromString((String)dataStorage.getUnit()));
                }
            }
            if ((eCPUPerSecond = cacheUsageLimits.getECPUPerSecond()) != null && eCPUPerSecond.getMaximum() != null) {
                request.addParameter("CacheUsageLimits.ECPUPerSecond.Maximum", StringUtils.fromInteger((Integer)eCPUPerSecond.getMaximum()));
            }
        }
        if (createServerlessCacheRequest.getKmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringUtils.fromString((String)createServerlessCacheRequest.getKmsKeyId()));
        }
        if (!createServerlessCacheRequest.getSecurityGroupIds().isEmpty() || !((SdkInternalList)createServerlessCacheRequest.getSecurityGroupIds()).isAutoConstruct()) {
            SdkInternalList securityGroupIdsList = (SdkInternalList)createServerlessCacheRequest.getSecurityGroupIds();
            int securityGroupIdsListIndex = 1;
            for (String securityGroupIdsListValue : securityGroupIdsList) {
                if (securityGroupIdsListValue != null) {
                    request.addParameter("SecurityGroupIds.SecurityGroupId." + securityGroupIdsListIndex, StringUtils.fromString((String)securityGroupIdsListValue));
                }
                ++securityGroupIdsListIndex;
            }
        }
        if (!createServerlessCacheRequest.getSnapshotArnsToRestore().isEmpty() || !((SdkInternalList)createServerlessCacheRequest.getSnapshotArnsToRestore()).isAutoConstruct()) {
            SdkInternalList snapshotArnsToRestoreList = (SdkInternalList)createServerlessCacheRequest.getSnapshotArnsToRestore();
            int snapshotArnsToRestoreListIndex = 1;
            for (String snapshotArnsToRestoreListValue : snapshotArnsToRestoreList) {
                if (snapshotArnsToRestoreListValue != null) {
                    request.addParameter("SnapshotArnsToRestore.SnapshotArn." + snapshotArnsToRestoreListIndex, StringUtils.fromString((String)snapshotArnsToRestoreListValue));
                }
                ++snapshotArnsToRestoreListIndex;
            }
        }
        if (!createServerlessCacheRequest.getTags().isEmpty() || !((SdkInternalList)createServerlessCacheRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)createServerlessCacheRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue != null) {
                    if (tagsListValue.getKey() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.getKey()));
                    }
                    if (tagsListValue.getValue() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.getValue()));
                    }
                }
                ++tagsListIndex;
            }
        }
        if (createServerlessCacheRequest.getUserGroupId() != null) {
            request.addParameter("UserGroupId", StringUtils.fromString((String)createServerlessCacheRequest.getUserGroupId()));
        }
        if (!createServerlessCacheRequest.getSubnetIds().isEmpty() || !((SdkInternalList)createServerlessCacheRequest.getSubnetIds()).isAutoConstruct()) {
            SdkInternalList subnetIdsList = (SdkInternalList)createServerlessCacheRequest.getSubnetIds();
            int subnetIdsListIndex = 1;
            for (String subnetIdsListValue : subnetIdsList) {
                if (subnetIdsListValue != null) {
                    request.addParameter("SubnetIds.SubnetId." + subnetIdsListIndex, StringUtils.fromString((String)subnetIdsListValue));
                }
                ++subnetIdsListIndex;
            }
        }
        if (createServerlessCacheRequest.getSnapshotRetentionLimit() != null) {
            request.addParameter("SnapshotRetentionLimit", StringUtils.fromInteger((Integer)createServerlessCacheRequest.getSnapshotRetentionLimit()));
        }
        if (createServerlessCacheRequest.getDailySnapshotTime() != null) {
            request.addParameter("DailySnapshotTime", StringUtils.fromString((String)createServerlessCacheRequest.getDailySnapshotTime()));
        }
        return request;
    }
}

