/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticache.model.CompleteMigrationRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CompleteMigrationRequestMarshaller
implements Marshaller<Request<CompleteMigrationRequest>, CompleteMigrationRequest> {
    public Request<CompleteMigrationRequest> marshall(CompleteMigrationRequest completeMigrationRequest) {
        if (completeMigrationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)completeMigrationRequest, "AmazonElastiCache");
        request.addParameter("Action", "CompleteMigration");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (completeMigrationRequest.getReplicationGroupId() != null) {
            request.addParameter("ReplicationGroupId", StringUtils.fromString((String)completeMigrationRequest.getReplicationGroupId()));
        }
        if (completeMigrationRequest.getForce() != null) {
            request.addParameter("Force", StringUtils.fromBoolean((Boolean)completeMigrationRequest.getForce()));
        }
        return request;
    }
}

