/*
 * Copyright 2010-2016 Amazon.com, Inc. or its affiliates. All Rights
 * Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 *  http://aws.amazon.com/apache2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

package com.amazonaws.services.elasticbeanstalk.model;

import java.io.Serializable;
import com.amazonaws.AmazonWebServiceRequest;

/**
 * <p/>
 */
public class DescribeEnvironmentsRequest extends AmazonWebServiceRequest
        implements Serializable, Cloneable {

    /**
     * <p>
     * If specified, AWS Elastic Beanstalk restricts the returned descriptions
     * to include only those that are associated with this application.
     * </p>
     */
    private String applicationName;
    /**
     * <p>
     * If specified, AWS Elastic Beanstalk restricts the returned descriptions
     * to include only those that are associated with this application version.
     * </p>
     */
    private String versionLabel;
    /**
     * <p>
     * If specified, AWS Elastic Beanstalk restricts the returned descriptions
     * to include only those that have the specified IDs.
     * </p>
     */
    private com.amazonaws.internal.SdkInternalList<String> environmentIds;
    /**
     * <p>
     * If specified, AWS Elastic Beanstalk restricts the returned descriptions
     * to include only those that have the specified names.
     * </p>
     */
    private com.amazonaws.internal.SdkInternalList<String> environmentNames;
    /**
     * <p>
     * Indicates whether to include deleted environments:
     * </p>
     * <p>
     * <code>true</code>: Environments that have been deleted after
     * <code>IncludedDeletedBackTo</code> are displayed.
     * </p>
     * <p>
     * <code>false</code>: Do not include deleted environments.
     * </p>
     */
    private Boolean includeDeleted;
    /**
     * <p>
     * If specified when <code>IncludeDeleted</code> is set to <code>true</code>
     * , then environments deleted after this date are displayed.
     * </p>
     */
    private java.util.Date includedDeletedBackTo;

    /**
     * <p>
     * If specified, AWS Elastic Beanstalk restricts the returned descriptions
     * to include only those that are associated with this application.
     * </p>
     * 
     * @param applicationName
     *        If specified, AWS Elastic Beanstalk restricts the returned
     *        descriptions to include only those that are associated with this
     *        application.
     */
    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    /**
     * <p>
     * If specified, AWS Elastic Beanstalk restricts the returned descriptions
     * to include only those that are associated with this application.
     * </p>
     * 
     * @return If specified, AWS Elastic Beanstalk restricts the returned
     *         descriptions to include only those that are associated with this
     *         application.
     */
    public String getApplicationName() {
        return this.applicationName;
    }

    /**
     * <p>
     * If specified, AWS Elastic Beanstalk restricts the returned descriptions
     * to include only those that are associated with this application.
     * </p>
     * 
     * @param applicationName
     *        If specified, AWS Elastic Beanstalk restricts the returned
     *        descriptions to include only those that are associated with this
     *        application.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     */
    public DescribeEnvironmentsRequest withApplicationName(
            String applicationName) {
        setApplicationName(applicationName);
        return this;
    }

    /**
     * <p>
     * If specified, AWS Elastic Beanstalk restricts the returned descriptions
     * to include only those that are associated with this application version.
     * </p>
     * 
     * @param versionLabel
     *        If specified, AWS Elastic Beanstalk restricts the returned
     *        descriptions to include only those that are associated with this
     *        application version.
     */
    public void setVersionLabel(String versionLabel) {
        this.versionLabel = versionLabel;
    }

    /**
     * <p>
     * If specified, AWS Elastic Beanstalk restricts the returned descriptions
     * to include only those that are associated with this application version.
     * </p>
     * 
     * @return If specified, AWS Elastic Beanstalk restricts the returned
     *         descriptions to include only those that are associated with this
     *         application version.
     */
    public String getVersionLabel() {
        return this.versionLabel;
    }

    /**
     * <p>
     * If specified, AWS Elastic Beanstalk restricts the returned descriptions
     * to include only those that are associated with this application version.
     * </p>
     * 
     * @param versionLabel
     *        If specified, AWS Elastic Beanstalk restricts the returned
     *        descriptions to include only those that are associated with this
     *        application version.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     */
    public DescribeEnvironmentsRequest withVersionLabel(String versionLabel) {
        setVersionLabel(versionLabel);
        return this;
    }

    /**
     * <p>
     * If specified, AWS Elastic Beanstalk restricts the returned descriptions
     * to include only those that have the specified IDs.
     * </p>
     * 
     * @return If specified, AWS Elastic Beanstalk restricts the returned
     *         descriptions to include only those that have the specified IDs.
     */
    public java.util.List<String> getEnvironmentIds() {
        if (environmentIds == null) {
            environmentIds = new com.amazonaws.internal.SdkInternalList<String>();
        }
        return environmentIds;
    }

    /**
     * <p>
     * If specified, AWS Elastic Beanstalk restricts the returned descriptions
     * to include only those that have the specified IDs.
     * </p>
     * 
     * @param environmentIds
     *        If specified, AWS Elastic Beanstalk restricts the returned
     *        descriptions to include only those that have the specified IDs.
     */
    public void setEnvironmentIds(java.util.Collection<String> environmentIds) {
        if (environmentIds == null) {
            this.environmentIds = null;
            return;
        }

        this.environmentIds = new com.amazonaws.internal.SdkInternalList<String>(
                environmentIds);
    }

    /**
     * <p>
     * If specified, AWS Elastic Beanstalk restricts the returned descriptions
     * to include only those that have the specified IDs.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if
     * any). Use {@link #setEnvironmentIds(java.util.Collection)} or
     * {@link #withEnvironmentIds(java.util.Collection)} if you want to override
     * the existing values.
     * </p>
     * 
     * @param environmentIds
     *        If specified, AWS Elastic Beanstalk restricts the returned
     *        descriptions to include only those that have the specified IDs.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     */
    public DescribeEnvironmentsRequest withEnvironmentIds(
            String... environmentIds) {
        if (this.environmentIds == null) {
            setEnvironmentIds(new com.amazonaws.internal.SdkInternalList<String>(
                    environmentIds.length));
        }
        for (String ele : environmentIds) {
            this.environmentIds.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * If specified, AWS Elastic Beanstalk restricts the returned descriptions
     * to include only those that have the specified IDs.
     * </p>
     * 
     * @param environmentIds
     *        If specified, AWS Elastic Beanstalk restricts the returned
     *        descriptions to include only those that have the specified IDs.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     */
    public DescribeEnvironmentsRequest withEnvironmentIds(
            java.util.Collection<String> environmentIds) {
        setEnvironmentIds(environmentIds);
        return this;
    }

    /**
     * <p>
     * If specified, AWS Elastic Beanstalk restricts the returned descriptions
     * to include only those that have the specified names.
     * </p>
     * 
     * @return If specified, AWS Elastic Beanstalk restricts the returned
     *         descriptions to include only those that have the specified names.
     */
    public java.util.List<String> getEnvironmentNames() {
        if (environmentNames == null) {
            environmentNames = new com.amazonaws.internal.SdkInternalList<String>();
        }
        return environmentNames;
    }

    /**
     * <p>
     * If specified, AWS Elastic Beanstalk restricts the returned descriptions
     * to include only those that have the specified names.
     * </p>
     * 
     * @param environmentNames
     *        If specified, AWS Elastic Beanstalk restricts the returned
     *        descriptions to include only those that have the specified names.
     */
    public void setEnvironmentNames(
            java.util.Collection<String> environmentNames) {
        if (environmentNames == null) {
            this.environmentNames = null;
            return;
        }

        this.environmentNames = new com.amazonaws.internal.SdkInternalList<String>(
                environmentNames);
    }

    /**
     * <p>
     * If specified, AWS Elastic Beanstalk restricts the returned descriptions
     * to include only those that have the specified names.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if
     * any). Use {@link #setEnvironmentNames(java.util.Collection)} or
     * {@link #withEnvironmentNames(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param environmentNames
     *        If specified, AWS Elastic Beanstalk restricts the returned
     *        descriptions to include only those that have the specified names.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     */
    public DescribeEnvironmentsRequest withEnvironmentNames(
            String... environmentNames) {
        if (this.environmentNames == null) {
            setEnvironmentNames(new com.amazonaws.internal.SdkInternalList<String>(
                    environmentNames.length));
        }
        for (String ele : environmentNames) {
            this.environmentNames.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * If specified, AWS Elastic Beanstalk restricts the returned descriptions
     * to include only those that have the specified names.
     * </p>
     * 
     * @param environmentNames
     *        If specified, AWS Elastic Beanstalk restricts the returned
     *        descriptions to include only those that have the specified names.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     */
    public DescribeEnvironmentsRequest withEnvironmentNames(
            java.util.Collection<String> environmentNames) {
        setEnvironmentNames(environmentNames);
        return this;
    }

    /**
     * <p>
     * Indicates whether to include deleted environments:
     * </p>
     * <p>
     * <code>true</code>: Environments that have been deleted after
     * <code>IncludedDeletedBackTo</code> are displayed.
     * </p>
     * <p>
     * <code>false</code>: Do not include deleted environments.
     * </p>
     * 
     * @param includeDeleted
     *        Indicates whether to include deleted environments: </p>
     *        <p>
     *        <code>true</code>: Environments that have been deleted after
     *        <code>IncludedDeletedBackTo</code> are displayed.
     *        </p>
     *        <p>
     *        <code>false</code>: Do not include deleted environments.
     */
    public void setIncludeDeleted(Boolean includeDeleted) {
        this.includeDeleted = includeDeleted;
    }

    /**
     * <p>
     * Indicates whether to include deleted environments:
     * </p>
     * <p>
     * <code>true</code>: Environments that have been deleted after
     * <code>IncludedDeletedBackTo</code> are displayed.
     * </p>
     * <p>
     * <code>false</code>: Do not include deleted environments.
     * </p>
     * 
     * @return Indicates whether to include deleted environments: </p>
     *         <p>
     *         <code>true</code>: Environments that have been deleted after
     *         <code>IncludedDeletedBackTo</code> are displayed.
     *         </p>
     *         <p>
     *         <code>false</code>: Do not include deleted environments.
     */
    public Boolean getIncludeDeleted() {
        return this.includeDeleted;
    }

    /**
     * <p>
     * Indicates whether to include deleted environments:
     * </p>
     * <p>
     * <code>true</code>: Environments that have been deleted after
     * <code>IncludedDeletedBackTo</code> are displayed.
     * </p>
     * <p>
     * <code>false</code>: Do not include deleted environments.
     * </p>
     * 
     * @param includeDeleted
     *        Indicates whether to include deleted environments: </p>
     *        <p>
     *        <code>true</code>: Environments that have been deleted after
     *        <code>IncludedDeletedBackTo</code> are displayed.
     *        </p>
     *        <p>
     *        <code>false</code>: Do not include deleted environments.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     */
    public DescribeEnvironmentsRequest withIncludeDeleted(Boolean includeDeleted) {
        setIncludeDeleted(includeDeleted);
        return this;
    }

    /**
     * <p>
     * Indicates whether to include deleted environments:
     * </p>
     * <p>
     * <code>true</code>: Environments that have been deleted after
     * <code>IncludedDeletedBackTo</code> are displayed.
     * </p>
     * <p>
     * <code>false</code>: Do not include deleted environments.
     * </p>
     * 
     * @return Indicates whether to include deleted environments: </p>
     *         <p>
     *         <code>true</code>: Environments that have been deleted after
     *         <code>IncludedDeletedBackTo</code> are displayed.
     *         </p>
     *         <p>
     *         <code>false</code>: Do not include deleted environments.
     */
    public Boolean isIncludeDeleted() {
        return this.includeDeleted;
    }

    /**
     * <p>
     * If specified when <code>IncludeDeleted</code> is set to <code>true</code>
     * , then environments deleted after this date are displayed.
     * </p>
     * 
     * @param includedDeletedBackTo
     *        If specified when <code>IncludeDeleted</code> is set to
     *        <code>true</code>, then environments deleted after this date are
     *        displayed.
     */
    public void setIncludedDeletedBackTo(java.util.Date includedDeletedBackTo) {
        this.includedDeletedBackTo = includedDeletedBackTo;
    }

    /**
     * <p>
     * If specified when <code>IncludeDeleted</code> is set to <code>true</code>
     * , then environments deleted after this date are displayed.
     * </p>
     * 
     * @return If specified when <code>IncludeDeleted</code> is set to
     *         <code>true</code>, then environments deleted after this date are
     *         displayed.
     */
    public java.util.Date getIncludedDeletedBackTo() {
        return this.includedDeletedBackTo;
    }

    /**
     * <p>
     * If specified when <code>IncludeDeleted</code> is set to <code>true</code>
     * , then environments deleted after this date are displayed.
     * </p>
     * 
     * @param includedDeletedBackTo
     *        If specified when <code>IncludeDeleted</code> is set to
     *        <code>true</code>, then environments deleted after this date are
     *        displayed.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     */
    public DescribeEnvironmentsRequest withIncludedDeletedBackTo(
            java.util.Date includedDeletedBackTo) {
        setIncludedDeletedBackTo(includedDeletedBackTo);
        return this;
    }

    /**
     * Returns a string representation of this object; useful for testing and
     * debugging.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getApplicationName() != null)
            sb.append("ApplicationName: " + getApplicationName() + ",");
        if (getVersionLabel() != null)
            sb.append("VersionLabel: " + getVersionLabel() + ",");
        if (getEnvironmentIds() != null)
            sb.append("EnvironmentIds: " + getEnvironmentIds() + ",");
        if (getEnvironmentNames() != null)
            sb.append("EnvironmentNames: " + getEnvironmentNames() + ",");
        if (getIncludeDeleted() != null)
            sb.append("IncludeDeleted: " + getIncludeDeleted() + ",");
        if (getIncludedDeletedBackTo() != null)
            sb.append("IncludedDeletedBackTo: " + getIncludedDeletedBackTo());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DescribeEnvironmentsRequest == false)
            return false;
        DescribeEnvironmentsRequest other = (DescribeEnvironmentsRequest) obj;
        if (other.getApplicationName() == null
                ^ this.getApplicationName() == null)
            return false;
        if (other.getApplicationName() != null
                && other.getApplicationName().equals(this.getApplicationName()) == false)
            return false;
        if (other.getVersionLabel() == null ^ this.getVersionLabel() == null)
            return false;
        if (other.getVersionLabel() != null
                && other.getVersionLabel().equals(this.getVersionLabel()) == false)
            return false;
        if (other.getEnvironmentIds() == null
                ^ this.getEnvironmentIds() == null)
            return false;
        if (other.getEnvironmentIds() != null
                && other.getEnvironmentIds().equals(this.getEnvironmentIds()) == false)
            return false;
        if (other.getEnvironmentNames() == null
                ^ this.getEnvironmentNames() == null)
            return false;
        if (other.getEnvironmentNames() != null
                && other.getEnvironmentNames().equals(
                        this.getEnvironmentNames()) == false)
            return false;
        if (other.getIncludeDeleted() == null
                ^ this.getIncludeDeleted() == null)
            return false;
        if (other.getIncludeDeleted() != null
                && other.getIncludeDeleted().equals(this.getIncludeDeleted()) == false)
            return false;
        if (other.getIncludedDeletedBackTo() == null
                ^ this.getIncludedDeletedBackTo() == null)
            return false;
        if (other.getIncludedDeletedBackTo() != null
                && other.getIncludedDeletedBackTo().equals(
                        this.getIncludedDeletedBackTo()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime
                * hashCode
                + ((getApplicationName() == null) ? 0 : getApplicationName()
                        .hashCode());
        hashCode = prime
                * hashCode
                + ((getVersionLabel() == null) ? 0 : getVersionLabel()
                        .hashCode());
        hashCode = prime
                * hashCode
                + ((getEnvironmentIds() == null) ? 0 : getEnvironmentIds()
                        .hashCode());
        hashCode = prime
                * hashCode
                + ((getEnvironmentNames() == null) ? 0 : getEnvironmentNames()
                        .hashCode());
        hashCode = prime
                * hashCode
                + ((getIncludeDeleted() == null) ? 0 : getIncludeDeleted()
                        .hashCode());
        hashCode = prime
                * hashCode
                + ((getIncludedDeletedBackTo() == null) ? 0
                        : getIncludedDeletedBackTo().hashCode());
        return hashCode;
    }

    @Override
    public DescribeEnvironmentsRequest clone() {
        return (DescribeEnvironmentsRequest) super.clone();
    }
}