/*
 * Copyright 2011-2016 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.elasticloadbalancing.model;

import java.io.Serializable;

/**
 * <p>
 * Contains the output of DescribeLoadBalancerPolicyTypes.
 * </p>
 * 
 * @see <a
 *      href="http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/DescribeLoadBalancerPolicyTypes"/>AWS
 *      API Documentation</a>
 */
public class DescribeLoadBalancerPolicyTypesResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable,
        Cloneable {

    /**
     * <p>
     * Information about the policy types.
     * </p>
     */
    private com.amazonaws.internal.SdkInternalList<PolicyTypeDescription> policyTypeDescriptions;

    /**
     * <p>
     * Information about the policy types.
     * </p>
     * 
     * @return Information about the policy types.
     */

    public java.util.List<PolicyTypeDescription> getPolicyTypeDescriptions() {
        if (policyTypeDescriptions == null) {
            policyTypeDescriptions = new com.amazonaws.internal.SdkInternalList<PolicyTypeDescription>();
        }
        return policyTypeDescriptions;
    }

    /**
     * <p>
     * Information about the policy types.
     * </p>
     * 
     * @param policyTypeDescriptions
     *        Information about the policy types.
     */

    public void setPolicyTypeDescriptions(java.util.Collection<PolicyTypeDescription> policyTypeDescriptions) {
        if (policyTypeDescriptions == null) {
            this.policyTypeDescriptions = null;
            return;
        }

        this.policyTypeDescriptions = new com.amazonaws.internal.SdkInternalList<PolicyTypeDescription>(policyTypeDescriptions);
    }

    /**
     * <p>
     * Information about the policy types.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setPolicyTypeDescriptions(java.util.Collection)} or
     * {@link #withPolicyTypeDescriptions(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param policyTypeDescriptions
     *        Information about the policy types.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeLoadBalancerPolicyTypesResult withPolicyTypeDescriptions(PolicyTypeDescription... policyTypeDescriptions) {
        if (this.policyTypeDescriptions == null) {
            setPolicyTypeDescriptions(new com.amazonaws.internal.SdkInternalList<PolicyTypeDescription>(policyTypeDescriptions.length));
        }
        for (PolicyTypeDescription ele : policyTypeDescriptions) {
            this.policyTypeDescriptions.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * Information about the policy types.
     * </p>
     * 
     * @param policyTypeDescriptions
     *        Information about the policy types.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeLoadBalancerPolicyTypesResult withPolicyTypeDescriptions(java.util.Collection<PolicyTypeDescription> policyTypeDescriptions) {
        setPolicyTypeDescriptions(policyTypeDescriptions);
        return this;
    }

    /**
     * Returns a string representation of this object; useful for testing and debugging.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getPolicyTypeDescriptions() != null)
            sb.append("PolicyTypeDescriptions: ").append(getPolicyTypeDescriptions());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DescribeLoadBalancerPolicyTypesResult == false)
            return false;
        DescribeLoadBalancerPolicyTypesResult other = (DescribeLoadBalancerPolicyTypesResult) obj;
        if (other.getPolicyTypeDescriptions() == null ^ this.getPolicyTypeDescriptions() == null)
            return false;
        if (other.getPolicyTypeDescriptions() != null && other.getPolicyTypeDescriptions().equals(this.getPolicyTypeDescriptions()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getPolicyTypeDescriptions() == null) ? 0 : getPolicyTypeDescriptions().hashCode());
        return hashCode;
    }

    @Override
    public DescribeLoadBalancerPolicyTypesResult clone() {
        try {
            return (DescribeLoadBalancerPolicyTypesResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }
}
