/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticloadbalancing.model.AccessLog;
import com.amazonaws.services.elasticloadbalancing.model.AdditionalAttribute;
import com.amazonaws.services.elasticloadbalancing.model.ConnectionDraining;
import com.amazonaws.services.elasticloadbalancing.model.ConnectionSettings;
import com.amazonaws.services.elasticloadbalancing.model.CrossZoneLoadBalancing;
import com.amazonaws.services.elasticloadbalancing.model.LoadBalancerAttributes;
import com.amazonaws.services.elasticloadbalancing.model.ModifyLoadBalancerAttributesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyLoadBalancerAttributesRequestMarshaller
implements Marshaller<Request<ModifyLoadBalancerAttributesRequest>, ModifyLoadBalancerAttributesRequest> {
    public Request<ModifyLoadBalancerAttributesRequest> marshall(ModifyLoadBalancerAttributesRequest modifyLoadBalancerAttributesRequest) {
        LoadBalancerAttributes loadBalancerAttributes;
        if (modifyLoadBalancerAttributesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyLoadBalancerAttributesRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "ModifyLoadBalancerAttributes");
        request.addParameter("Version", "2012-06-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyLoadBalancerAttributesRequest.getLoadBalancerName() != null) {
            request.addParameter("LoadBalancerName", StringUtils.fromString((String)modifyLoadBalancerAttributesRequest.getLoadBalancerName()));
        }
        if ((loadBalancerAttributes = modifyLoadBalancerAttributesRequest.getLoadBalancerAttributes()) != null) {
            ConnectionSettings connectionSettings;
            ConnectionDraining connectionDraining;
            AccessLog accessLog;
            CrossZoneLoadBalancing crossZoneLoadBalancing = loadBalancerAttributes.getCrossZoneLoadBalancing();
            if (crossZoneLoadBalancing != null && crossZoneLoadBalancing.getEnabled() != null) {
                request.addParameter("LoadBalancerAttributes.CrossZoneLoadBalancing.Enabled", StringUtils.fromBoolean((Boolean)crossZoneLoadBalancing.getEnabled()));
            }
            if ((accessLog = loadBalancerAttributes.getAccessLog()) != null) {
                if (accessLog.getEnabled() != null) {
                    request.addParameter("LoadBalancerAttributes.AccessLog.Enabled", StringUtils.fromBoolean((Boolean)accessLog.getEnabled()));
                }
                if (accessLog.getS3BucketName() != null) {
                    request.addParameter("LoadBalancerAttributes.AccessLog.S3BucketName", StringUtils.fromString((String)accessLog.getS3BucketName()));
                }
                if (accessLog.getEmitInterval() != null) {
                    request.addParameter("LoadBalancerAttributes.AccessLog.EmitInterval", StringUtils.fromInteger((Integer)accessLog.getEmitInterval()));
                }
                if (accessLog.getS3BucketPrefix() != null) {
                    request.addParameter("LoadBalancerAttributes.AccessLog.S3BucketPrefix", StringUtils.fromString((String)accessLog.getS3BucketPrefix()));
                }
            }
            if ((connectionDraining = loadBalancerAttributes.getConnectionDraining()) != null) {
                if (connectionDraining.getEnabled() != null) {
                    request.addParameter("LoadBalancerAttributes.ConnectionDraining.Enabled", StringUtils.fromBoolean((Boolean)connectionDraining.getEnabled()));
                }
                if (connectionDraining.getTimeout() != null) {
                    request.addParameter("LoadBalancerAttributes.ConnectionDraining.Timeout", StringUtils.fromInteger((Integer)connectionDraining.getTimeout()));
                }
            }
            if ((connectionSettings = loadBalancerAttributes.getConnectionSettings()) != null && connectionSettings.getIdleTimeout() != null) {
                request.addParameter("LoadBalancerAttributes.ConnectionSettings.IdleTimeout", StringUtils.fromInteger((Integer)connectionSettings.getIdleTimeout()));
            }
            if (!loadBalancerAttributes.getAdditionalAttributes().isEmpty() || !((SdkInternalList)loadBalancerAttributes.getAdditionalAttributes()).isAutoConstruct()) {
                SdkInternalList additionalAttributesList = (SdkInternalList)loadBalancerAttributes.getAdditionalAttributes();
                int additionalAttributesListIndex = 1;
                for (AdditionalAttribute additionalAttributesListValue : additionalAttributesList) {
                    if (additionalAttributesListValue != null) {
                        if (additionalAttributesListValue.getKey() != null) {
                            request.addParameter("LoadBalancerAttributes.AdditionalAttributes.member." + additionalAttributesListIndex + ".Key", StringUtils.fromString((String)additionalAttributesListValue.getKey()));
                        }
                        if (additionalAttributesListValue.getValue() != null) {
                            request.addParameter("LoadBalancerAttributes.AdditionalAttributes.member." + additionalAttributesListIndex + ".Value", StringUtils.fromString((String)additionalAttributesListValue.getValue()));
                        }
                    }
                    ++additionalAttributesListIndex;
                }
            }
        }
        return request;
    }
}

