/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancingv2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticloadbalancingv2.model.Action;
import com.amazonaws.services.elasticloadbalancingv2.model.Certificate;
import com.amazonaws.services.elasticloadbalancingv2.model.ModifyListenerRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class ModifyListenerRequestMarshaller
implements Marshaller<Request<ModifyListenerRequest>, ModifyListenerRequest> {
    public Request<ModifyListenerRequest> marshall(ModifyListenerRequest modifyListenerRequest) {
        if (modifyListenerRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyListenerRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "ModifyListener");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyListenerRequest.getListenerArn() != null) {
            request.addParameter("ListenerArn", StringUtils.fromString((String)modifyListenerRequest.getListenerArn()));
        }
        if (modifyListenerRequest.getPort() != null) {
            request.addParameter("Port", StringUtils.fromInteger((Integer)modifyListenerRequest.getPort()));
        }
        if (modifyListenerRequest.getProtocol() != null) {
            request.addParameter("Protocol", StringUtils.fromString((String)modifyListenerRequest.getProtocol()));
        }
        if (modifyListenerRequest.getSslPolicy() != null) {
            request.addParameter("SslPolicy", StringUtils.fromString((String)modifyListenerRequest.getSslPolicy()));
        }
        if (modifyListenerRequest.getCertificates() != null) {
            List<Certificate> certificatesList = modifyListenerRequest.getCertificates();
            if (certificatesList.isEmpty()) {
                request.addParameter("Certificates", "");
            } else {
                int certificatesListIndex = 1;
                for (Certificate certificatesListValue : certificatesList) {
                    if (certificatesListValue.getCertificateArn() != null) {
                        request.addParameter("Certificates.member." + certificatesListIndex + ".CertificateArn", StringUtils.fromString((String)certificatesListValue.getCertificateArn()));
                    }
                    if (certificatesListValue.getIsDefault() != null) {
                        request.addParameter("Certificates.member." + certificatesListIndex + ".IsDefault", StringUtils.fromBoolean((Boolean)certificatesListValue.getIsDefault()));
                    }
                    ++certificatesListIndex;
                }
            }
        }
        if (modifyListenerRequest.getDefaultActions() != null) {
            List<Action> defaultActionsList = modifyListenerRequest.getDefaultActions();
            if (defaultActionsList.isEmpty()) {
                request.addParameter("DefaultActions", "");
            } else {
                int defaultActionsListIndex = 1;
                for (Action defaultActionsListValue : defaultActionsList) {
                    if (defaultActionsListValue.getType() != null) {
                        request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".Type", StringUtils.fromString((String)defaultActionsListValue.getType()));
                    }
                    if (defaultActionsListValue.getTargetGroupArn() != null) {
                        request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".TargetGroupArn", StringUtils.fromString((String)defaultActionsListValue.getTargetGroupArn()));
                    }
                    ++defaultActionsListIndex;
                }
            }
        }
        return request;
    }
}

