/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancingv2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticloadbalancingv2.model.LoadBalancerAttribute;
import com.amazonaws.services.elasticloadbalancingv2.model.ModifyLoadBalancerAttributesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class ModifyLoadBalancerAttributesRequestMarshaller
implements Marshaller<Request<ModifyLoadBalancerAttributesRequest>, ModifyLoadBalancerAttributesRequest> {
    public Request<ModifyLoadBalancerAttributesRequest> marshall(ModifyLoadBalancerAttributesRequest modifyLoadBalancerAttributesRequest) {
        if (modifyLoadBalancerAttributesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyLoadBalancerAttributesRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "ModifyLoadBalancerAttributes");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyLoadBalancerAttributesRequest.getLoadBalancerArn() != null) {
            request.addParameter("LoadBalancerArn", StringUtils.fromString((String)modifyLoadBalancerAttributesRequest.getLoadBalancerArn()));
        }
        if (modifyLoadBalancerAttributesRequest.getAttributes() != null) {
            List<LoadBalancerAttribute> attributesList = modifyLoadBalancerAttributesRequest.getAttributes();
            if (attributesList.isEmpty()) {
                request.addParameter("Attributes", "");
            } else {
                int attributesListIndex = 1;
                for (LoadBalancerAttribute attributesListValue : attributesList) {
                    if (attributesListValue != null) {
                        if (attributesListValue.getKey() != null) {
                            request.addParameter("Attributes.member." + attributesListIndex + ".Key", StringUtils.fromString((String)attributesListValue.getKey()));
                        }
                        if (attributesListValue.getValue() != null) {
                            request.addParameter("Attributes.member." + attributesListIndex + ".Value", StringUtils.fromString((String)attributesListValue.getValue()));
                        }
                    }
                    ++attributesListIndex;
                }
            }
        }
        return request;
    }
}

