/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * <p>
 * Information about a target group attribute.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/TargetGroupAttribute"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class TargetGroupAttribute implements Serializable, Cloneable {

    /**
     * <p>
     * The name of the attribute.
     * </p>
     * <p>
     * The following attributes are supported by all load balancers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>deregistration_delay.timeout_seconds</code> - The amount of time, in seconds, for Elastic Load Balancing to
     * wait before changing the state of a deregistering target from <code>draining</code> to <code>unused</code>. The
     * range is 0-3600 seconds. The default value is 300 seconds. If the target is a Lambda function, this attribute is
     * not supported.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>stickiness.enabled</code> - Indicates whether target stickiness is enabled. The value is <code>true</code>
     * or <code>false</code>. The default is <code>false</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>stickiness.type</code> - Indicates the type of stickiness. The possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>lb_cookie</code> and <code>app_cookie</code> for Application Load Balancers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>source_ip</code> for Network Load Balancers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>source_ip_dest_ip</code> and <code>source_ip_dest_ip_proto</code> for Gateway Load Balancers.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * The following attributes are supported by Application Load Balancers and Network Load Balancers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>load_balancing.cross_zone.enabled</code> - Indicates whether cross zone load balancing is enabled. The
     * value is <code>true</code>, <code>false</code> or <code>use_load_balancer_configuration</code>. The default is
     * <code>use_load_balancer_configuration</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>target_group_health.dns_failover.minimum_healthy_targets.count</code> - The minimum number of targets that
     * must be healthy. If the number of healthy targets is below this value, mark the zone as unhealthy in DNS, so that
     * traffic is routed only to healthy zones. The possible values are <code>off</code> or an integer from 1 to the
     * maximum number of targets. The default is <code>off</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>target_group_health.dns_failover.minimum_healthy_targets.percentage</code> - The minimum percentage of
     * targets that must be healthy. If the percentage of healthy targets is below this value, mark the zone as
     * unhealthy in DNS, so that traffic is routed only to healthy zones. The possible values are <code>off</code> or an
     * integer from 1 to 100. The default is <code>off</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>target_group_health.unhealthy_state_routing.minimum_healthy_targets.count</code> - The minimum number of
     * targets that must be healthy. If the number of healthy targets is below this value, send traffic to all targets,
     * including unhealthy targets. The possible values are 1 to the maximum number of targets. The default is 1.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>target_group_health.unhealthy_state_routing.minimum_healthy_targets.percentage</code> - The minimum
     * percentage of targets that must be healthy. If the percentage of healthy targets is below this value, send
     * traffic to all targets, including unhealthy targets. The possible values are <code>off</code> or an integer from
     * 1 to 100. The default is <code>off</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following attributes are supported only if the load balancer is an Application Load Balancer and the target
     * is an instance or an IP address:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>load_balancing.algorithm.type</code> - The load balancing algorithm determines how the load balancer
     * selects targets when routing requests. The value is <code>round_robin</code> or
     * <code>least_outstanding_requests</code>. The default is <code>round_robin</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>slow_start.duration_seconds</code> - The time period, in seconds, during which a newly registered target
     * receives an increasing share of the traffic to the target group. After this time period ends, the target receives
     * its full share of traffic. The range is 30-900 seconds (15 minutes). The default is 0 seconds (disabled).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>stickiness.app_cookie.cookie_name</code> - Indicates the name of the application-based cookie. Names that
     * start with the following prefixes are not allowed: <code>AWSALB</code>, <code>AWSALBAPP</code>, and
     * <code>AWSALBTG</code>; they're reserved for use by the load balancer.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>stickiness.app_cookie.duration_seconds</code> - The time period, in seconds, during which requests from a
     * client should be routed to the same target. After this time period expires, the application-based cookie is
     * considered stale. The range is 1 second to 1 week (604800 seconds). The default value is 1 day (86400 seconds).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>stickiness.lb_cookie.duration_seconds</code> - The time period, in seconds, during which requests from a
     * client should be routed to the same target. After this time period expires, the load balancer-generated cookie is
     * considered stale. The range is 1 second to 1 week (604800 seconds). The default value is 1 day (86400 seconds).
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following attribute is supported only if the load balancer is an Application Load Balancer and the target is
     * a Lambda function:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>lambda.multi_value_headers.enabled</code> - Indicates whether the request and response headers that are
     * exchanged between the load balancer and the Lambda function include arrays of values or strings. The value is
     * <code>true</code> or <code>false</code>. The default is <code>false</code>. If the value is <code>false</code>
     * and the request contains a duplicate header field name or query parameter key, the load balancer uses the last
     * value sent by the client.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following attributes are supported only by Network Load Balancers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>deregistration_delay.connection_termination.enabled</code> - Indicates whether the load balancer terminates
     * connections at the end of the deregistration timeout. The value is <code>true</code> or <code>false</code>. The
     * default is <code>false</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>preserve_client_ip.enabled</code> - Indicates whether client IP preservation is enabled. The value is
     * <code>true</code> or <code>false</code>. The default is disabled if the target group type is IP address and the
     * target group protocol is TCP or TLS. Otherwise, the default is enabled. Client IP preservation cannot be disabled
     * for UDP and TCP_UDP target groups.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>proxy_protocol_v2.enabled</code> - Indicates whether Proxy Protocol version 2 is enabled. The value is
     * <code>true</code> or <code>false</code>. The default is <code>false</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following attributes are supported only by Gateway Load Balancers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>target_failover.on_deregistration</code> - Indicates how the Gateway Load Balancer handles existing flows
     * when a target is deregistered. The possible values are <code>rebalance</code> and <code>no_rebalance</code>. The
     * default is <code>no_rebalance</code>. The two attributes (<code>target_failover.on_deregistration</code> and
     * <code>target_failover.on_unhealthy</code>) can't be set independently. The value you set for both attributes must
     * be the same.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>target_failover.on_unhealthy</code> - Indicates how the Gateway Load Balancer handles existing flows when a
     * target is unhealthy. The possible values are <code>rebalance</code> and <code>no_rebalance</code>. The default is
     * <code>no_rebalance</code>. The two attributes (<code>target_failover.on_deregistration</code> and
     * <code>target_failover.on_unhealthy</code>) cannot be set independently. The value you set for both attributes
     * must be the same.
     * </p>
     * </li>
     * </ul>
     */
    private String key;
    /**
     * <p>
     * The value of the attribute.
     * </p>
     */
    private String value;

    /**
     * <p>
     * The name of the attribute.
     * </p>
     * <p>
     * The following attributes are supported by all load balancers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>deregistration_delay.timeout_seconds</code> - The amount of time, in seconds, for Elastic Load Balancing to
     * wait before changing the state of a deregistering target from <code>draining</code> to <code>unused</code>. The
     * range is 0-3600 seconds. The default value is 300 seconds. If the target is a Lambda function, this attribute is
     * not supported.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>stickiness.enabled</code> - Indicates whether target stickiness is enabled. The value is <code>true</code>
     * or <code>false</code>. The default is <code>false</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>stickiness.type</code> - Indicates the type of stickiness. The possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>lb_cookie</code> and <code>app_cookie</code> for Application Load Balancers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>source_ip</code> for Network Load Balancers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>source_ip_dest_ip</code> and <code>source_ip_dest_ip_proto</code> for Gateway Load Balancers.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * The following attributes are supported by Application Load Balancers and Network Load Balancers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>load_balancing.cross_zone.enabled</code> - Indicates whether cross zone load balancing is enabled. The
     * value is <code>true</code>, <code>false</code> or <code>use_load_balancer_configuration</code>. The default is
     * <code>use_load_balancer_configuration</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>target_group_health.dns_failover.minimum_healthy_targets.count</code> - The minimum number of targets that
     * must be healthy. If the number of healthy targets is below this value, mark the zone as unhealthy in DNS, so that
     * traffic is routed only to healthy zones. The possible values are <code>off</code> or an integer from 1 to the
     * maximum number of targets. The default is <code>off</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>target_group_health.dns_failover.minimum_healthy_targets.percentage</code> - The minimum percentage of
     * targets that must be healthy. If the percentage of healthy targets is below this value, mark the zone as
     * unhealthy in DNS, so that traffic is routed only to healthy zones. The possible values are <code>off</code> or an
     * integer from 1 to 100. The default is <code>off</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>target_group_health.unhealthy_state_routing.minimum_healthy_targets.count</code> - The minimum number of
     * targets that must be healthy. If the number of healthy targets is below this value, send traffic to all targets,
     * including unhealthy targets. The possible values are 1 to the maximum number of targets. The default is 1.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>target_group_health.unhealthy_state_routing.minimum_healthy_targets.percentage</code> - The minimum
     * percentage of targets that must be healthy. If the percentage of healthy targets is below this value, send
     * traffic to all targets, including unhealthy targets. The possible values are <code>off</code> or an integer from
     * 1 to 100. The default is <code>off</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following attributes are supported only if the load balancer is an Application Load Balancer and the target
     * is an instance or an IP address:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>load_balancing.algorithm.type</code> - The load balancing algorithm determines how the load balancer
     * selects targets when routing requests. The value is <code>round_robin</code> or
     * <code>least_outstanding_requests</code>. The default is <code>round_robin</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>slow_start.duration_seconds</code> - The time period, in seconds, during which a newly registered target
     * receives an increasing share of the traffic to the target group. After this time period ends, the target receives
     * its full share of traffic. The range is 30-900 seconds (15 minutes). The default is 0 seconds (disabled).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>stickiness.app_cookie.cookie_name</code> - Indicates the name of the application-based cookie. Names that
     * start with the following prefixes are not allowed: <code>AWSALB</code>, <code>AWSALBAPP</code>, and
     * <code>AWSALBTG</code>; they're reserved for use by the load balancer.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>stickiness.app_cookie.duration_seconds</code> - The time period, in seconds, during which requests from a
     * client should be routed to the same target. After this time period expires, the application-based cookie is
     * considered stale. The range is 1 second to 1 week (604800 seconds). The default value is 1 day (86400 seconds).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>stickiness.lb_cookie.duration_seconds</code> - The time period, in seconds, during which requests from a
     * client should be routed to the same target. After this time period expires, the load balancer-generated cookie is
     * considered stale. The range is 1 second to 1 week (604800 seconds). The default value is 1 day (86400 seconds).
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following attribute is supported only if the load balancer is an Application Load Balancer and the target is
     * a Lambda function:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>lambda.multi_value_headers.enabled</code> - Indicates whether the request and response headers that are
     * exchanged between the load balancer and the Lambda function include arrays of values or strings. The value is
     * <code>true</code> or <code>false</code>. The default is <code>false</code>. If the value is <code>false</code>
     * and the request contains a duplicate header field name or query parameter key, the load balancer uses the last
     * value sent by the client.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following attributes are supported only by Network Load Balancers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>deregistration_delay.connection_termination.enabled</code> - Indicates whether the load balancer terminates
     * connections at the end of the deregistration timeout. The value is <code>true</code> or <code>false</code>. The
     * default is <code>false</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>preserve_client_ip.enabled</code> - Indicates whether client IP preservation is enabled. The value is
     * <code>true</code> or <code>false</code>. The default is disabled if the target group type is IP address and the
     * target group protocol is TCP or TLS. Otherwise, the default is enabled. Client IP preservation cannot be disabled
     * for UDP and TCP_UDP target groups.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>proxy_protocol_v2.enabled</code> - Indicates whether Proxy Protocol version 2 is enabled. The value is
     * <code>true</code> or <code>false</code>. The default is <code>false</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following attributes are supported only by Gateway Load Balancers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>target_failover.on_deregistration</code> - Indicates how the Gateway Load Balancer handles existing flows
     * when a target is deregistered. The possible values are <code>rebalance</code> and <code>no_rebalance</code>. The
     * default is <code>no_rebalance</code>. The two attributes (<code>target_failover.on_deregistration</code> and
     * <code>target_failover.on_unhealthy</code>) can't be set independently. The value you set for both attributes must
     * be the same.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>target_failover.on_unhealthy</code> - Indicates how the Gateway Load Balancer handles existing flows when a
     * target is unhealthy. The possible values are <code>rebalance</code> and <code>no_rebalance</code>. The default is
     * <code>no_rebalance</code>. The two attributes (<code>target_failover.on_deregistration</code> and
     * <code>target_failover.on_unhealthy</code>) cannot be set independently. The value you set for both attributes
     * must be the same.
     * </p>
     * </li>
     * </ul>
     * 
     * @param key
     *        The name of the attribute.</p>
     *        <p>
     *        The following attributes are supported by all load balancers:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>deregistration_delay.timeout_seconds</code> - The amount of time, in seconds, for Elastic Load
     *        Balancing to wait before changing the state of a deregistering target from <code>draining</code> to
     *        <code>unused</code>. The range is 0-3600 seconds. The default value is 300 seconds. If the target is a
     *        Lambda function, this attribute is not supported.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>stickiness.enabled</code> - Indicates whether target stickiness is enabled. The value is
     *        <code>true</code> or <code>false</code>. The default is <code>false</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>stickiness.type</code> - Indicates the type of stickiness. The possible values are:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>lb_cookie</code> and <code>app_cookie</code> for Application Load Balancers.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>source_ip</code> for Network Load Balancers.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>source_ip_dest_ip</code> and <code>source_ip_dest_ip_proto</code> for Gateway Load Balancers.
     *        </p>
     *        </li>
     *        </ul>
     *        </li>
     *        </ul>
     *        <p>
     *        The following attributes are supported by Application Load Balancers and Network Load Balancers:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>load_balancing.cross_zone.enabled</code> - Indicates whether cross zone load balancing is enabled.
     *        The value is <code>true</code>, <code>false</code> or <code>use_load_balancer_configuration</code>. The
     *        default is <code>use_load_balancer_configuration</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>target_group_health.dns_failover.minimum_healthy_targets.count</code> - The minimum number of
     *        targets that must be healthy. If the number of healthy targets is below this value, mark the zone as
     *        unhealthy in DNS, so that traffic is routed only to healthy zones. The possible values are
     *        <code>off</code> or an integer from 1 to the maximum number of targets. The default is <code>off</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>target_group_health.dns_failover.minimum_healthy_targets.percentage</code> - The minimum percentage
     *        of targets that must be healthy. If the percentage of healthy targets is below this value, mark the zone
     *        as unhealthy in DNS, so that traffic is routed only to healthy zones. The possible values are
     *        <code>off</code> or an integer from 1 to 100. The default is <code>off</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>target_group_health.unhealthy_state_routing.minimum_healthy_targets.count</code> - The minimum
     *        number of targets that must be healthy. If the number of healthy targets is below this value, send traffic
     *        to all targets, including unhealthy targets. The possible values are 1 to the maximum number of targets.
     *        The default is 1.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>target_group_health.unhealthy_state_routing.minimum_healthy_targets.percentage</code> - The minimum
     *        percentage of targets that must be healthy. If the percentage of healthy targets is below this value, send
     *        traffic to all targets, including unhealthy targets. The possible values are <code>off</code> or an
     *        integer from 1 to 100. The default is <code>off</code>.
     *        </p>
     *        </li>
     *        </ul>
     *        <p>
     *        The following attributes are supported only if the load balancer is an Application Load Balancer and the
     *        target is an instance or an IP address:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>load_balancing.algorithm.type</code> - The load balancing algorithm determines how the load balancer
     *        selects targets when routing requests. The value is <code>round_robin</code> or
     *        <code>least_outstanding_requests</code>. The default is <code>round_robin</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>slow_start.duration_seconds</code> - The time period, in seconds, during which a newly registered
     *        target receives an increasing share of the traffic to the target group. After this time period ends, the
     *        target receives its full share of traffic. The range is 30-900 seconds (15 minutes). The default is 0
     *        seconds (disabled).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>stickiness.app_cookie.cookie_name</code> - Indicates the name of the application-based cookie. Names
     *        that start with the following prefixes are not allowed: <code>AWSALB</code>, <code>AWSALBAPP</code>, and
     *        <code>AWSALBTG</code>; they're reserved for use by the load balancer.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>stickiness.app_cookie.duration_seconds</code> - The time period, in seconds, during which requests
     *        from a client should be routed to the same target. After this time period expires, the application-based
     *        cookie is considered stale. The range is 1 second to 1 week (604800 seconds). The default value is 1 day
     *        (86400 seconds).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>stickiness.lb_cookie.duration_seconds</code> - The time period, in seconds, during which requests
     *        from a client should be routed to the same target. After this time period expires, the load
     *        balancer-generated cookie is considered stale. The range is 1 second to 1 week (604800 seconds). The
     *        default value is 1 day (86400 seconds).
     *        </p>
     *        </li>
     *        </ul>
     *        <p>
     *        The following attribute is supported only if the load balancer is an Application Load Balancer and the
     *        target is a Lambda function:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>lambda.multi_value_headers.enabled</code> - Indicates whether the request and response headers that
     *        are exchanged between the load balancer and the Lambda function include arrays of values or strings. The
     *        value is <code>true</code> or <code>false</code>. The default is <code>false</code>. If the value is
     *        <code>false</code> and the request contains a duplicate header field name or query parameter key, the load
     *        balancer uses the last value sent by the client.
     *        </p>
     *        </li>
     *        </ul>
     *        <p>
     *        The following attributes are supported only by Network Load Balancers:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>deregistration_delay.connection_termination.enabled</code> - Indicates whether the load balancer
     *        terminates connections at the end of the deregistration timeout. The value is <code>true</code> or
     *        <code>false</code>. The default is <code>false</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>preserve_client_ip.enabled</code> - Indicates whether client IP preservation is enabled. The value
     *        is <code>true</code> or <code>false</code>. The default is disabled if the target group type is IP address
     *        and the target group protocol is TCP or TLS. Otherwise, the default is enabled. Client IP preservation
     *        cannot be disabled for UDP and TCP_UDP target groups.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>proxy_protocol_v2.enabled</code> - Indicates whether Proxy Protocol version 2 is enabled. The value
     *        is <code>true</code> or <code>false</code>. The default is <code>false</code>.
     *        </p>
     *        </li>
     *        </ul>
     *        <p>
     *        The following attributes are supported only by Gateway Load Balancers:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>target_failover.on_deregistration</code> - Indicates how the Gateway Load Balancer handles existing
     *        flows when a target is deregistered. The possible values are <code>rebalance</code> and
     *        <code>no_rebalance</code>. The default is <code>no_rebalance</code>. The two attributes (
     *        <code>target_failover.on_deregistration</code> and <code>target_failover.on_unhealthy</code>) can't be set
     *        independently. The value you set for both attributes must be the same.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>target_failover.on_unhealthy</code> - Indicates how the Gateway Load Balancer handles existing flows
     *        when a target is unhealthy. The possible values are <code>rebalance</code> and <code>no_rebalance</code>.
     *        The default is <code>no_rebalance</code>. The two attributes (
     *        <code>target_failover.on_deregistration</code> and <code>target_failover.on_unhealthy</code>) cannot be
     *        set independently. The value you set for both attributes must be the same.
     *        </p>
     *        </li>
     */

    public void setKey(String key) {
        this.key = key;
    }

    /**
     * <p>
     * The name of the attribute.
     * </p>
     * <p>
     * The following attributes are supported by all load balancers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>deregistration_delay.timeout_seconds</code> - The amount of time, in seconds, for Elastic Load Balancing to
     * wait before changing the state of a deregistering target from <code>draining</code> to <code>unused</code>. The
     * range is 0-3600 seconds. The default value is 300 seconds. If the target is a Lambda function, this attribute is
     * not supported.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>stickiness.enabled</code> - Indicates whether target stickiness is enabled. The value is <code>true</code>
     * or <code>false</code>. The default is <code>false</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>stickiness.type</code> - Indicates the type of stickiness. The possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>lb_cookie</code> and <code>app_cookie</code> for Application Load Balancers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>source_ip</code> for Network Load Balancers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>source_ip_dest_ip</code> and <code>source_ip_dest_ip_proto</code> for Gateway Load Balancers.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * The following attributes are supported by Application Load Balancers and Network Load Balancers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>load_balancing.cross_zone.enabled</code> - Indicates whether cross zone load balancing is enabled. The
     * value is <code>true</code>, <code>false</code> or <code>use_load_balancer_configuration</code>. The default is
     * <code>use_load_balancer_configuration</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>target_group_health.dns_failover.minimum_healthy_targets.count</code> - The minimum number of targets that
     * must be healthy. If the number of healthy targets is below this value, mark the zone as unhealthy in DNS, so that
     * traffic is routed only to healthy zones. The possible values are <code>off</code> or an integer from 1 to the
     * maximum number of targets. The default is <code>off</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>target_group_health.dns_failover.minimum_healthy_targets.percentage</code> - The minimum percentage of
     * targets that must be healthy. If the percentage of healthy targets is below this value, mark the zone as
     * unhealthy in DNS, so that traffic is routed only to healthy zones. The possible values are <code>off</code> or an
     * integer from 1 to 100. The default is <code>off</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>target_group_health.unhealthy_state_routing.minimum_healthy_targets.count</code> - The minimum number of
     * targets that must be healthy. If the number of healthy targets is below this value, send traffic to all targets,
     * including unhealthy targets. The possible values are 1 to the maximum number of targets. The default is 1.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>target_group_health.unhealthy_state_routing.minimum_healthy_targets.percentage</code> - The minimum
     * percentage of targets that must be healthy. If the percentage of healthy targets is below this value, send
     * traffic to all targets, including unhealthy targets. The possible values are <code>off</code> or an integer from
     * 1 to 100. The default is <code>off</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following attributes are supported only if the load balancer is an Application Load Balancer and the target
     * is an instance or an IP address:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>load_balancing.algorithm.type</code> - The load balancing algorithm determines how the load balancer
     * selects targets when routing requests. The value is <code>round_robin</code> or
     * <code>least_outstanding_requests</code>. The default is <code>round_robin</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>slow_start.duration_seconds</code> - The time period, in seconds, during which a newly registered target
     * receives an increasing share of the traffic to the target group. After this time period ends, the target receives
     * its full share of traffic. The range is 30-900 seconds (15 minutes). The default is 0 seconds (disabled).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>stickiness.app_cookie.cookie_name</code> - Indicates the name of the application-based cookie. Names that
     * start with the following prefixes are not allowed: <code>AWSALB</code>, <code>AWSALBAPP</code>, and
     * <code>AWSALBTG</code>; they're reserved for use by the load balancer.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>stickiness.app_cookie.duration_seconds</code> - The time period, in seconds, during which requests from a
     * client should be routed to the same target. After this time period expires, the application-based cookie is
     * considered stale. The range is 1 second to 1 week (604800 seconds). The default value is 1 day (86400 seconds).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>stickiness.lb_cookie.duration_seconds</code> - The time period, in seconds, during which requests from a
     * client should be routed to the same target. After this time period expires, the load balancer-generated cookie is
     * considered stale. The range is 1 second to 1 week (604800 seconds). The default value is 1 day (86400 seconds).
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following attribute is supported only if the load balancer is an Application Load Balancer and the target is
     * a Lambda function:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>lambda.multi_value_headers.enabled</code> - Indicates whether the request and response headers that are
     * exchanged between the load balancer and the Lambda function include arrays of values or strings. The value is
     * <code>true</code> or <code>false</code>. The default is <code>false</code>. If the value is <code>false</code>
     * and the request contains a duplicate header field name or query parameter key, the load balancer uses the last
     * value sent by the client.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following attributes are supported only by Network Load Balancers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>deregistration_delay.connection_termination.enabled</code> - Indicates whether the load balancer terminates
     * connections at the end of the deregistration timeout. The value is <code>true</code> or <code>false</code>. The
     * default is <code>false</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>preserve_client_ip.enabled</code> - Indicates whether client IP preservation is enabled. The value is
     * <code>true</code> or <code>false</code>. The default is disabled if the target group type is IP address and the
     * target group protocol is TCP or TLS. Otherwise, the default is enabled. Client IP preservation cannot be disabled
     * for UDP and TCP_UDP target groups.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>proxy_protocol_v2.enabled</code> - Indicates whether Proxy Protocol version 2 is enabled. The value is
     * <code>true</code> or <code>false</code>. The default is <code>false</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following attributes are supported only by Gateway Load Balancers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>target_failover.on_deregistration</code> - Indicates how the Gateway Load Balancer handles existing flows
     * when a target is deregistered. The possible values are <code>rebalance</code> and <code>no_rebalance</code>. The
     * default is <code>no_rebalance</code>. The two attributes (<code>target_failover.on_deregistration</code> and
     * <code>target_failover.on_unhealthy</code>) can't be set independently. The value you set for both attributes must
     * be the same.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>target_failover.on_unhealthy</code> - Indicates how the Gateway Load Balancer handles existing flows when a
     * target is unhealthy. The possible values are <code>rebalance</code> and <code>no_rebalance</code>. The default is
     * <code>no_rebalance</code>. The two attributes (<code>target_failover.on_deregistration</code> and
     * <code>target_failover.on_unhealthy</code>) cannot be set independently. The value you set for both attributes
     * must be the same.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the attribute.</p>
     *         <p>
     *         The following attributes are supported by all load balancers:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>deregistration_delay.timeout_seconds</code> - The amount of time, in seconds, for Elastic Load
     *         Balancing to wait before changing the state of a deregistering target from <code>draining</code> to
     *         <code>unused</code>. The range is 0-3600 seconds. The default value is 300 seconds. If the target is a
     *         Lambda function, this attribute is not supported.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>stickiness.enabled</code> - Indicates whether target stickiness is enabled. The value is
     *         <code>true</code> or <code>false</code>. The default is <code>false</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>stickiness.type</code> - Indicates the type of stickiness. The possible values are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>lb_cookie</code> and <code>app_cookie</code> for Application Load Balancers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>source_ip</code> for Network Load Balancers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>source_ip_dest_ip</code> and <code>source_ip_dest_ip_proto</code> for Gateway Load Balancers.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         <p>
     *         The following attributes are supported by Application Load Balancers and Network Load Balancers:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>load_balancing.cross_zone.enabled</code> - Indicates whether cross zone load balancing is enabled.
     *         The value is <code>true</code>, <code>false</code> or <code>use_load_balancer_configuration</code>. The
     *         default is <code>use_load_balancer_configuration</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>target_group_health.dns_failover.minimum_healthy_targets.count</code> - The minimum number of
     *         targets that must be healthy. If the number of healthy targets is below this value, mark the zone as
     *         unhealthy in DNS, so that traffic is routed only to healthy zones. The possible values are
     *         <code>off</code> or an integer from 1 to the maximum number of targets. The default is <code>off</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>target_group_health.dns_failover.minimum_healthy_targets.percentage</code> - The minimum percentage
     *         of targets that must be healthy. If the percentage of healthy targets is below this value, mark the zone
     *         as unhealthy in DNS, so that traffic is routed only to healthy zones. The possible values are
     *         <code>off</code> or an integer from 1 to 100. The default is <code>off</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>target_group_health.unhealthy_state_routing.minimum_healthy_targets.count</code> - The minimum
     *         number of targets that must be healthy. If the number of healthy targets is below this value, send
     *         traffic to all targets, including unhealthy targets. The possible values are 1 to the maximum number of
     *         targets. The default is 1.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>target_group_health.unhealthy_state_routing.minimum_healthy_targets.percentage</code> - The minimum
     *         percentage of targets that must be healthy. If the percentage of healthy targets is below this value,
     *         send traffic to all targets, including unhealthy targets. The possible values are <code>off</code> or an
     *         integer from 1 to 100. The default is <code>off</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The following attributes are supported only if the load balancer is an Application Load Balancer and the
     *         target is an instance or an IP address:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>load_balancing.algorithm.type</code> - The load balancing algorithm determines how the load
     *         balancer selects targets when routing requests. The value is <code>round_robin</code> or
     *         <code>least_outstanding_requests</code>. The default is <code>round_robin</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>slow_start.duration_seconds</code> - The time period, in seconds, during which a newly registered
     *         target receives an increasing share of the traffic to the target group. After this time period ends, the
     *         target receives its full share of traffic. The range is 30-900 seconds (15 minutes). The default is 0
     *         seconds (disabled).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>stickiness.app_cookie.cookie_name</code> - Indicates the name of the application-based cookie.
     *         Names that start with the following prefixes are not allowed: <code>AWSALB</code>, <code>AWSALBAPP</code>
     *         , and <code>AWSALBTG</code>; they're reserved for use by the load balancer.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>stickiness.app_cookie.duration_seconds</code> - The time period, in seconds, during which requests
     *         from a client should be routed to the same target. After this time period expires, the application-based
     *         cookie is considered stale. The range is 1 second to 1 week (604800 seconds). The default value is 1 day
     *         (86400 seconds).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>stickiness.lb_cookie.duration_seconds</code> - The time period, in seconds, during which requests
     *         from a client should be routed to the same target. After this time period expires, the load
     *         balancer-generated cookie is considered stale. The range is 1 second to 1 week (604800 seconds). The
     *         default value is 1 day (86400 seconds).
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The following attribute is supported only if the load balancer is an Application Load Balancer and the
     *         target is a Lambda function:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>lambda.multi_value_headers.enabled</code> - Indicates whether the request and response headers that
     *         are exchanged between the load balancer and the Lambda function include arrays of values or strings. The
     *         value is <code>true</code> or <code>false</code>. The default is <code>false</code>. If the value is
     *         <code>false</code> and the request contains a duplicate header field name or query parameter key, the
     *         load balancer uses the last value sent by the client.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The following attributes are supported only by Network Load Balancers:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>deregistration_delay.connection_termination.enabled</code> - Indicates whether the load balancer
     *         terminates connections at the end of the deregistration timeout. The value is <code>true</code> or
     *         <code>false</code>. The default is <code>false</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>preserve_client_ip.enabled</code> - Indicates whether client IP preservation is enabled. The value
     *         is <code>true</code> or <code>false</code>. The default is disabled if the target group type is IP
     *         address and the target group protocol is TCP or TLS. Otherwise, the default is enabled. Client IP
     *         preservation cannot be disabled for UDP and TCP_UDP target groups.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>proxy_protocol_v2.enabled</code> - Indicates whether Proxy Protocol version 2 is enabled. The value
     *         is <code>true</code> or <code>false</code>. The default is <code>false</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The following attributes are supported only by Gateway Load Balancers:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>target_failover.on_deregistration</code> - Indicates how the Gateway Load Balancer handles existing
     *         flows when a target is deregistered. The possible values are <code>rebalance</code> and
     *         <code>no_rebalance</code>. The default is <code>no_rebalance</code>. The two attributes (
     *         <code>target_failover.on_deregistration</code> and <code>target_failover.on_unhealthy</code>) can't be
     *         set independently. The value you set for both attributes must be the same.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>target_failover.on_unhealthy</code> - Indicates how the Gateway Load Balancer handles existing
     *         flows when a target is unhealthy. The possible values are <code>rebalance</code> and
     *         <code>no_rebalance</code>. The default is <code>no_rebalance</code>. The two attributes (
     *         <code>target_failover.on_deregistration</code> and <code>target_failover.on_unhealthy</code>) cannot be
     *         set independently. The value you set for both attributes must be the same.
     *         </p>
     *         </li>
     */

    public String getKey() {
        return this.key;
    }

    /**
     * <p>
     * The name of the attribute.
     * </p>
     * <p>
     * The following attributes are supported by all load balancers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>deregistration_delay.timeout_seconds</code> - The amount of time, in seconds, for Elastic Load Balancing to
     * wait before changing the state of a deregistering target from <code>draining</code> to <code>unused</code>. The
     * range is 0-3600 seconds. The default value is 300 seconds. If the target is a Lambda function, this attribute is
     * not supported.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>stickiness.enabled</code> - Indicates whether target stickiness is enabled. The value is <code>true</code>
     * or <code>false</code>. The default is <code>false</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>stickiness.type</code> - Indicates the type of stickiness. The possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>lb_cookie</code> and <code>app_cookie</code> for Application Load Balancers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>source_ip</code> for Network Load Balancers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>source_ip_dest_ip</code> and <code>source_ip_dest_ip_proto</code> for Gateway Load Balancers.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * The following attributes are supported by Application Load Balancers and Network Load Balancers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>load_balancing.cross_zone.enabled</code> - Indicates whether cross zone load balancing is enabled. The
     * value is <code>true</code>, <code>false</code> or <code>use_load_balancer_configuration</code>. The default is
     * <code>use_load_balancer_configuration</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>target_group_health.dns_failover.minimum_healthy_targets.count</code> - The minimum number of targets that
     * must be healthy. If the number of healthy targets is below this value, mark the zone as unhealthy in DNS, so that
     * traffic is routed only to healthy zones. The possible values are <code>off</code> or an integer from 1 to the
     * maximum number of targets. The default is <code>off</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>target_group_health.dns_failover.minimum_healthy_targets.percentage</code> - The minimum percentage of
     * targets that must be healthy. If the percentage of healthy targets is below this value, mark the zone as
     * unhealthy in DNS, so that traffic is routed only to healthy zones. The possible values are <code>off</code> or an
     * integer from 1 to 100. The default is <code>off</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>target_group_health.unhealthy_state_routing.minimum_healthy_targets.count</code> - The minimum number of
     * targets that must be healthy. If the number of healthy targets is below this value, send traffic to all targets,
     * including unhealthy targets. The possible values are 1 to the maximum number of targets. The default is 1.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>target_group_health.unhealthy_state_routing.minimum_healthy_targets.percentage</code> - The minimum
     * percentage of targets that must be healthy. If the percentage of healthy targets is below this value, send
     * traffic to all targets, including unhealthy targets. The possible values are <code>off</code> or an integer from
     * 1 to 100. The default is <code>off</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following attributes are supported only if the load balancer is an Application Load Balancer and the target
     * is an instance or an IP address:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>load_balancing.algorithm.type</code> - The load balancing algorithm determines how the load balancer
     * selects targets when routing requests. The value is <code>round_robin</code> or
     * <code>least_outstanding_requests</code>. The default is <code>round_robin</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>slow_start.duration_seconds</code> - The time period, in seconds, during which a newly registered target
     * receives an increasing share of the traffic to the target group. After this time period ends, the target receives
     * its full share of traffic. The range is 30-900 seconds (15 minutes). The default is 0 seconds (disabled).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>stickiness.app_cookie.cookie_name</code> - Indicates the name of the application-based cookie. Names that
     * start with the following prefixes are not allowed: <code>AWSALB</code>, <code>AWSALBAPP</code>, and
     * <code>AWSALBTG</code>; they're reserved for use by the load balancer.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>stickiness.app_cookie.duration_seconds</code> - The time period, in seconds, during which requests from a
     * client should be routed to the same target. After this time period expires, the application-based cookie is
     * considered stale. The range is 1 second to 1 week (604800 seconds). The default value is 1 day (86400 seconds).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>stickiness.lb_cookie.duration_seconds</code> - The time period, in seconds, during which requests from a
     * client should be routed to the same target. After this time period expires, the load balancer-generated cookie is
     * considered stale. The range is 1 second to 1 week (604800 seconds). The default value is 1 day (86400 seconds).
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following attribute is supported only if the load balancer is an Application Load Balancer and the target is
     * a Lambda function:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>lambda.multi_value_headers.enabled</code> - Indicates whether the request and response headers that are
     * exchanged between the load balancer and the Lambda function include arrays of values or strings. The value is
     * <code>true</code> or <code>false</code>. The default is <code>false</code>. If the value is <code>false</code>
     * and the request contains a duplicate header field name or query parameter key, the load balancer uses the last
     * value sent by the client.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following attributes are supported only by Network Load Balancers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>deregistration_delay.connection_termination.enabled</code> - Indicates whether the load balancer terminates
     * connections at the end of the deregistration timeout. The value is <code>true</code> or <code>false</code>. The
     * default is <code>false</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>preserve_client_ip.enabled</code> - Indicates whether client IP preservation is enabled. The value is
     * <code>true</code> or <code>false</code>. The default is disabled if the target group type is IP address and the
     * target group protocol is TCP or TLS. Otherwise, the default is enabled. Client IP preservation cannot be disabled
     * for UDP and TCP_UDP target groups.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>proxy_protocol_v2.enabled</code> - Indicates whether Proxy Protocol version 2 is enabled. The value is
     * <code>true</code> or <code>false</code>. The default is <code>false</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following attributes are supported only by Gateway Load Balancers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>target_failover.on_deregistration</code> - Indicates how the Gateway Load Balancer handles existing flows
     * when a target is deregistered. The possible values are <code>rebalance</code> and <code>no_rebalance</code>. The
     * default is <code>no_rebalance</code>. The two attributes (<code>target_failover.on_deregistration</code> and
     * <code>target_failover.on_unhealthy</code>) can't be set independently. The value you set for both attributes must
     * be the same.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>target_failover.on_unhealthy</code> - Indicates how the Gateway Load Balancer handles existing flows when a
     * target is unhealthy. The possible values are <code>rebalance</code> and <code>no_rebalance</code>. The default is
     * <code>no_rebalance</code>. The two attributes (<code>target_failover.on_deregistration</code> and
     * <code>target_failover.on_unhealthy</code>) cannot be set independently. The value you set for both attributes
     * must be the same.
     * </p>
     * </li>
     * </ul>
     * 
     * @param key
     *        The name of the attribute.</p>
     *        <p>
     *        The following attributes are supported by all load balancers:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>deregistration_delay.timeout_seconds</code> - The amount of time, in seconds, for Elastic Load
     *        Balancing to wait before changing the state of a deregistering target from <code>draining</code> to
     *        <code>unused</code>. The range is 0-3600 seconds. The default value is 300 seconds. If the target is a
     *        Lambda function, this attribute is not supported.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>stickiness.enabled</code> - Indicates whether target stickiness is enabled. The value is
     *        <code>true</code> or <code>false</code>. The default is <code>false</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>stickiness.type</code> - Indicates the type of stickiness. The possible values are:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>lb_cookie</code> and <code>app_cookie</code> for Application Load Balancers.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>source_ip</code> for Network Load Balancers.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>source_ip_dest_ip</code> and <code>source_ip_dest_ip_proto</code> for Gateway Load Balancers.
     *        </p>
     *        </li>
     *        </ul>
     *        </li>
     *        </ul>
     *        <p>
     *        The following attributes are supported by Application Load Balancers and Network Load Balancers:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>load_balancing.cross_zone.enabled</code> - Indicates whether cross zone load balancing is enabled.
     *        The value is <code>true</code>, <code>false</code> or <code>use_load_balancer_configuration</code>. The
     *        default is <code>use_load_balancer_configuration</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>target_group_health.dns_failover.minimum_healthy_targets.count</code> - The minimum number of
     *        targets that must be healthy. If the number of healthy targets is below this value, mark the zone as
     *        unhealthy in DNS, so that traffic is routed only to healthy zones. The possible values are
     *        <code>off</code> or an integer from 1 to the maximum number of targets. The default is <code>off</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>target_group_health.dns_failover.minimum_healthy_targets.percentage</code> - The minimum percentage
     *        of targets that must be healthy. If the percentage of healthy targets is below this value, mark the zone
     *        as unhealthy in DNS, so that traffic is routed only to healthy zones. The possible values are
     *        <code>off</code> or an integer from 1 to 100. The default is <code>off</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>target_group_health.unhealthy_state_routing.minimum_healthy_targets.count</code> - The minimum
     *        number of targets that must be healthy. If the number of healthy targets is below this value, send traffic
     *        to all targets, including unhealthy targets. The possible values are 1 to the maximum number of targets.
     *        The default is 1.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>target_group_health.unhealthy_state_routing.minimum_healthy_targets.percentage</code> - The minimum
     *        percentage of targets that must be healthy. If the percentage of healthy targets is below this value, send
     *        traffic to all targets, including unhealthy targets. The possible values are <code>off</code> or an
     *        integer from 1 to 100. The default is <code>off</code>.
     *        </p>
     *        </li>
     *        </ul>
     *        <p>
     *        The following attributes are supported only if the load balancer is an Application Load Balancer and the
     *        target is an instance or an IP address:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>load_balancing.algorithm.type</code> - The load balancing algorithm determines how the load balancer
     *        selects targets when routing requests. The value is <code>round_robin</code> or
     *        <code>least_outstanding_requests</code>. The default is <code>round_robin</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>slow_start.duration_seconds</code> - The time period, in seconds, during which a newly registered
     *        target receives an increasing share of the traffic to the target group. After this time period ends, the
     *        target receives its full share of traffic. The range is 30-900 seconds (15 minutes). The default is 0
     *        seconds (disabled).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>stickiness.app_cookie.cookie_name</code> - Indicates the name of the application-based cookie. Names
     *        that start with the following prefixes are not allowed: <code>AWSALB</code>, <code>AWSALBAPP</code>, and
     *        <code>AWSALBTG</code>; they're reserved for use by the load balancer.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>stickiness.app_cookie.duration_seconds</code> - The time period, in seconds, during which requests
     *        from a client should be routed to the same target. After this time period expires, the application-based
     *        cookie is considered stale. The range is 1 second to 1 week (604800 seconds). The default value is 1 day
     *        (86400 seconds).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>stickiness.lb_cookie.duration_seconds</code> - The time period, in seconds, during which requests
     *        from a client should be routed to the same target. After this time period expires, the load
     *        balancer-generated cookie is considered stale. The range is 1 second to 1 week (604800 seconds). The
     *        default value is 1 day (86400 seconds).
     *        </p>
     *        </li>
     *        </ul>
     *        <p>
     *        The following attribute is supported only if the load balancer is an Application Load Balancer and the
     *        target is a Lambda function:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>lambda.multi_value_headers.enabled</code> - Indicates whether the request and response headers that
     *        are exchanged between the load balancer and the Lambda function include arrays of values or strings. The
     *        value is <code>true</code> or <code>false</code>. The default is <code>false</code>. If the value is
     *        <code>false</code> and the request contains a duplicate header field name or query parameter key, the load
     *        balancer uses the last value sent by the client.
     *        </p>
     *        </li>
     *        </ul>
     *        <p>
     *        The following attributes are supported only by Network Load Balancers:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>deregistration_delay.connection_termination.enabled</code> - Indicates whether the load balancer
     *        terminates connections at the end of the deregistration timeout. The value is <code>true</code> or
     *        <code>false</code>. The default is <code>false</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>preserve_client_ip.enabled</code> - Indicates whether client IP preservation is enabled. The value
     *        is <code>true</code> or <code>false</code>. The default is disabled if the target group type is IP address
     *        and the target group protocol is TCP or TLS. Otherwise, the default is enabled. Client IP preservation
     *        cannot be disabled for UDP and TCP_UDP target groups.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>proxy_protocol_v2.enabled</code> - Indicates whether Proxy Protocol version 2 is enabled. The value
     *        is <code>true</code> or <code>false</code>. The default is <code>false</code>.
     *        </p>
     *        </li>
     *        </ul>
     *        <p>
     *        The following attributes are supported only by Gateway Load Balancers:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>target_failover.on_deregistration</code> - Indicates how the Gateway Load Balancer handles existing
     *        flows when a target is deregistered. The possible values are <code>rebalance</code> and
     *        <code>no_rebalance</code>. The default is <code>no_rebalance</code>. The two attributes (
     *        <code>target_failover.on_deregistration</code> and <code>target_failover.on_unhealthy</code>) can't be set
     *        independently. The value you set for both attributes must be the same.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>target_failover.on_unhealthy</code> - Indicates how the Gateway Load Balancer handles existing flows
     *        when a target is unhealthy. The possible values are <code>rebalance</code> and <code>no_rebalance</code>.
     *        The default is <code>no_rebalance</code>. The two attributes (
     *        <code>target_failover.on_deregistration</code> and <code>target_failover.on_unhealthy</code>) cannot be
     *        set independently. The value you set for both attributes must be the same.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public TargetGroupAttribute withKey(String key) {
        setKey(key);
        return this;
    }

    /**
     * <p>
     * The value of the attribute.
     * </p>
     * 
     * @param value
     *        The value of the attribute.
     */

    public void setValue(String value) {
        this.value = value;
    }

    /**
     * <p>
     * The value of the attribute.
     * </p>
     * 
     * @return The value of the attribute.
     */

    public String getValue() {
        return this.value;
    }

    /**
     * <p>
     * The value of the attribute.
     * </p>
     * 
     * @param value
     *        The value of the attribute.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public TargetGroupAttribute withValue(String value) {
        setValue(value);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getKey() != null)
            sb.append("Key: ").append(getKey()).append(",");
        if (getValue() != null)
            sb.append("Value: ").append(getValue());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof TargetGroupAttribute == false)
            return false;
        TargetGroupAttribute other = (TargetGroupAttribute) obj;
        if (other.getKey() == null ^ this.getKey() == null)
            return false;
        if (other.getKey() != null && other.getKey().equals(this.getKey()) == false)
            return false;
        if (other.getValue() == null ^ this.getValue() == null)
            return false;
        if (other.getValue() != null && other.getValue().equals(this.getValue()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getKey() == null) ? 0 : getKey().hashCode());
        hashCode = prime * hashCode + ((getValue() == null) ? 0 : getValue().hashCode());
        return hashCode;
    }

    @Override
    public TargetGroupAttribute clone() {
        try {
            return (TargetGroupAttribute) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
