/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.elasticloadbalancingv2;

import javax.annotation.Generated;

import com.amazonaws.services.elasticloadbalancingv2.model.*;
import com.amazonaws.*;
import com.amazonaws.services.elasticloadbalancingv2.waiters.AmazonElasticLoadBalancingWaiters;

/**
 * Abstract implementation of {@code AmazonElasticLoadBalancing}. Convenient method forms pass through to the
 * corresponding overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonElasticLoadBalancing implements AmazonElasticLoadBalancing {

    protected AbstractAmazonElasticLoadBalancing() {
    }

    @Override
    public void setEndpoint(String endpoint) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void setRegion(com.amazonaws.regions.Region region) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AddListenerCertificatesResult addListenerCertificates(AddListenerCertificatesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AddTagsResult addTags(AddTagsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AddTrustStoreRevocationsResult addTrustStoreRevocations(AddTrustStoreRevocationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateListenerResult createListener(CreateListenerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateLoadBalancerResult createLoadBalancer(CreateLoadBalancerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateRuleResult createRule(CreateRuleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateTargetGroupResult createTargetGroup(CreateTargetGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateTrustStoreResult createTrustStore(CreateTrustStoreRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteListenerResult deleteListener(DeleteListenerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteLoadBalancerResult deleteLoadBalancer(DeleteLoadBalancerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteRuleResult deleteRule(DeleteRuleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteTargetGroupResult deleteTargetGroup(DeleteTargetGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteTrustStoreResult deleteTrustStore(DeleteTrustStoreRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeregisterTargetsResult deregisterTargets(DeregisterTargetsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAccountLimitsResult describeAccountLimits(DescribeAccountLimitsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeListenerCertificatesResult describeListenerCertificates(DescribeListenerCertificatesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeListenersResult describeListeners(DescribeListenersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeLoadBalancerAttributesResult describeLoadBalancerAttributes(DescribeLoadBalancerAttributesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeLoadBalancersResult describeLoadBalancers(DescribeLoadBalancersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeRulesResult describeRules(DescribeRulesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeSSLPoliciesResult describeSSLPolicies(DescribeSSLPoliciesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeTagsResult describeTags(DescribeTagsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeTargetGroupAttributesResult describeTargetGroupAttributes(DescribeTargetGroupAttributesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeTargetGroupsResult describeTargetGroups(DescribeTargetGroupsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeTargetHealthResult describeTargetHealth(DescribeTargetHealthRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeTrustStoreAssociationsResult describeTrustStoreAssociations(DescribeTrustStoreAssociationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeTrustStoreRevocationsResult describeTrustStoreRevocations(DescribeTrustStoreRevocationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeTrustStoresResult describeTrustStores(DescribeTrustStoresRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetTrustStoreCaCertificatesBundleResult getTrustStoreCaCertificatesBundle(GetTrustStoreCaCertificatesBundleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetTrustStoreRevocationContentResult getTrustStoreRevocationContent(GetTrustStoreRevocationContentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ModifyListenerResult modifyListener(ModifyListenerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ModifyLoadBalancerAttributesResult modifyLoadBalancerAttributes(ModifyLoadBalancerAttributesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ModifyRuleResult modifyRule(ModifyRuleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ModifyTargetGroupResult modifyTargetGroup(ModifyTargetGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ModifyTargetGroupAttributesResult modifyTargetGroupAttributes(ModifyTargetGroupAttributesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ModifyTrustStoreResult modifyTrustStore(ModifyTrustStoreRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RegisterTargetsResult registerTargets(RegisterTargetsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RemoveListenerCertificatesResult removeListenerCertificates(RemoveListenerCertificatesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RemoveTagsResult removeTags(RemoveTagsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RemoveTrustStoreRevocationsResult removeTrustStoreRevocations(RemoveTrustStoreRevocationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SetIpAddressTypeResult setIpAddressType(SetIpAddressTypeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SetRulePrioritiesResult setRulePriorities(SetRulePrioritiesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SetSecurityGroupsResult setSecurityGroups(SetSecurityGroupsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SetSubnetsResult setSubnets(SetSubnetsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AmazonElasticLoadBalancingWaiters waiters() {
        throw new java.lang.UnsupportedOperationException();
    }

}
