/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/ModifyTrustStore"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ModifyTrustStoreResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * Information about the modified trust store.
     * </p>
     */
    private java.util.List<TrustStore> trustStores;

    /**
     * <p>
     * Information about the modified trust store.
     * </p>
     * 
     * @return Information about the modified trust store.
     */

    public java.util.List<TrustStore> getTrustStores() {
        return trustStores;
    }

    /**
     * <p>
     * Information about the modified trust store.
     * </p>
     * 
     * @param trustStores
     *        Information about the modified trust store.
     */

    public void setTrustStores(java.util.Collection<TrustStore> trustStores) {
        if (trustStores == null) {
            this.trustStores = null;
            return;
        }

        this.trustStores = new java.util.ArrayList<TrustStore>(trustStores);
    }

    /**
     * <p>
     * Information about the modified trust store.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setTrustStores(java.util.Collection)} or {@link #withTrustStores(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param trustStores
     *        Information about the modified trust store.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ModifyTrustStoreResult withTrustStores(TrustStore... trustStores) {
        if (this.trustStores == null) {
            setTrustStores(new java.util.ArrayList<TrustStore>(trustStores.length));
        }
        for (TrustStore ele : trustStores) {
            this.trustStores.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * Information about the modified trust store.
     * </p>
     * 
     * @param trustStores
     *        Information about the modified trust store.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ModifyTrustStoreResult withTrustStores(java.util.Collection<TrustStore> trustStores) {
        setTrustStores(trustStores);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getTrustStores() != null)
            sb.append("TrustStores: ").append(getTrustStores());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ModifyTrustStoreResult == false)
            return false;
        ModifyTrustStoreResult other = (ModifyTrustStoreResult) obj;
        if (other.getTrustStores() == null ^ this.getTrustStores() == null)
            return false;
        if (other.getTrustStores() != null && other.getTrustStores().equals(this.getTrustStores()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getTrustStores() == null) ? 0 : getTrustStores().hashCode());
        return hashCode;
    }

    @Override
    public ModifyTrustStoreResult clone() {
        try {
            return (ModifyTrustStoreResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
