/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancingv2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.TargetDescription;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DeregisterTargetsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String targetGroupArn;
    private List<TargetDescription> targets;

    public void setTargetGroupArn(String targetGroupArn) {
        this.targetGroupArn = targetGroupArn;
    }

    public String getTargetGroupArn() {
        return this.targetGroupArn;
    }

    public DeregisterTargetsRequest withTargetGroupArn(String targetGroupArn) {
        this.setTargetGroupArn(targetGroupArn);
        return this;
    }

    public List<TargetDescription> getTargets() {
        return this.targets;
    }

    public void setTargets(Collection<TargetDescription> targets) {
        if (targets == null) {
            this.targets = null;
            return;
        }
        this.targets = new ArrayList<TargetDescription>(targets);
    }

    public DeregisterTargetsRequest withTargets(TargetDescription ... targets) {
        if (this.targets == null) {
            this.setTargets(new ArrayList<TargetDescription>(targets.length));
        }
        for (TargetDescription ele : targets) {
            this.targets.add(ele);
        }
        return this;
    }

    public DeregisterTargetsRequest withTargets(Collection<TargetDescription> targets) {
        this.setTargets(targets);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTargetGroupArn() != null) {
            sb.append("TargetGroupArn: ").append(this.getTargetGroupArn()).append(",");
        }
        if (this.getTargets() != null) {
            sb.append("Targets: ").append(this.getTargets());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeregisterTargetsRequest)) {
            return false;
        }
        DeregisterTargetsRequest other = (DeregisterTargetsRequest)obj;
        if (other.getTargetGroupArn() == null ^ this.getTargetGroupArn() == null) {
            return false;
        }
        if (other.getTargetGroupArn() != null && !other.getTargetGroupArn().equals(this.getTargetGroupArn())) {
            return false;
        }
        if (other.getTargets() == null ^ this.getTargets() == null) {
            return false;
        }
        return other.getTargets() == null || other.getTargets().equals(this.getTargets());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTargetGroupArn() == null ? 0 : this.getTargetGroupArn().hashCode());
        hashCode = 31 * hashCode + (this.getTargets() == null ? 0 : this.getTargets().hashCode());
        return hashCode;
    }

    public DeregisterTargetsRequest clone() {
        return (DeregisterTargetsRequest)super.clone();
    }
}

