/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.elasticsearch.model;

import java.io.Serializable;

/**
 * <p>
 * Specifies the time, in UTC format, when the service takes a daily automated snapshot of the specified Elasticsearch
 * domain. Default value is <code>0</code> hours.
 * </p>
 */
public class SnapshotOptions implements Serializable, Cloneable {

    /**
     * <p>
     * Specifies the time, in UTC format, when the service takes a daily automated snapshot of the specified
     * Elasticsearch domain. Default value is <code>0</code> hours.
     * </p>
     */
    private Integer automatedSnapshotStartHour;

    /**
     * <p>
     * Specifies the time, in UTC format, when the service takes a daily automated snapshot of the specified
     * Elasticsearch domain. Default value is <code>0</code> hours.
     * </p>
     * 
     * @param automatedSnapshotStartHour
     *        Specifies the time, in UTC format, when the service takes a daily automated snapshot of the specified
     *        Elasticsearch domain. Default value is <code>0</code> hours.
     */

    public void setAutomatedSnapshotStartHour(Integer automatedSnapshotStartHour) {
        this.automatedSnapshotStartHour = automatedSnapshotStartHour;
    }

    /**
     * <p>
     * Specifies the time, in UTC format, when the service takes a daily automated snapshot of the specified
     * Elasticsearch domain. Default value is <code>0</code> hours.
     * </p>
     * 
     * @return Specifies the time, in UTC format, when the service takes a daily automated snapshot of the specified
     *         Elasticsearch domain. Default value is <code>0</code> hours.
     */

    public Integer getAutomatedSnapshotStartHour() {
        return this.automatedSnapshotStartHour;
    }

    /**
     * <p>
     * Specifies the time, in UTC format, when the service takes a daily automated snapshot of the specified
     * Elasticsearch domain. Default value is <code>0</code> hours.
     * </p>
     * 
     * @param automatedSnapshotStartHour
     *        Specifies the time, in UTC format, when the service takes a daily automated snapshot of the specified
     *        Elasticsearch domain. Default value is <code>0</code> hours.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SnapshotOptions withAutomatedSnapshotStartHour(Integer automatedSnapshotStartHour) {
        setAutomatedSnapshotStartHour(automatedSnapshotStartHour);
        return this;
    }

    /**
     * Returns a string representation of this object; useful for testing and debugging.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getAutomatedSnapshotStartHour() != null)
            sb.append("AutomatedSnapshotStartHour: ").append(getAutomatedSnapshotStartHour());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof SnapshotOptions == false)
            return false;
        SnapshotOptions other = (SnapshotOptions) obj;
        if (other.getAutomatedSnapshotStartHour() == null ^ this.getAutomatedSnapshotStartHour() == null)
            return false;
        if (other.getAutomatedSnapshotStartHour() != null && other.getAutomatedSnapshotStartHour().equals(this.getAutomatedSnapshotStartHour()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getAutomatedSnapshotStartHour() == null) ? 0 : getAutomatedSnapshotStartHour().hashCode());
        return hashCode;
    }

    @Override
    public SnapshotOptions clone() {
        try {
            return (SnapshotOptions) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }
}
