/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.elastictranscoder.model.CaptionFormat;
import com.amazonaws.services.elastictranscoder.model.transform.EncryptionJsonMarshaller;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class CaptionFormatJsonMarshaller {
    private static CaptionFormatJsonMarshaller instance;

    public void marshall(CaptionFormat captionFormat, StructuredJsonGenerator jsonGenerator) {
        if (captionFormat == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (captionFormat.getFormat() != null) {
                jsonGenerator.writeFieldName("Format").writeValue(captionFormat.getFormat());
            }
            if (captionFormat.getPattern() != null) {
                jsonGenerator.writeFieldName("Pattern").writeValue(captionFormat.getPattern());
            }
            if (captionFormat.getEncryption() != null) {
                jsonGenerator.writeFieldName("Encryption");
                EncryptionJsonMarshaller.getInstance().marshall(captionFormat.getEncryption(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static CaptionFormatJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new CaptionFormatJsonMarshaller();
        }
        return instance;
    }
}

