/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.elastictranscoder.model.TestRoleRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class TestRoleRequestMarshaller
implements Marshaller<Request<TestRoleRequest>, TestRoleRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public TestRoleRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<TestRoleRequest> marshall(TestRoleRequest testRoleRequest) {
        if (testRoleRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)testRoleRequest, "AmazonElasticTranscoder");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2012-09-25/roleTests";
        request.setResourcePath(uriResourcePath);
        try {
            SdkInternalList topicsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (testRoleRequest.getRole() != null) {
                jsonGenerator.writeFieldName("Role").writeValue(testRoleRequest.getRole());
            }
            if (testRoleRequest.getInputBucket() != null) {
                jsonGenerator.writeFieldName("InputBucket").writeValue(testRoleRequest.getInputBucket());
            }
            if (testRoleRequest.getOutputBucket() != null) {
                jsonGenerator.writeFieldName("OutputBucket").writeValue(testRoleRequest.getOutputBucket());
            }
            if (!(topicsList = (SdkInternalList)testRoleRequest.getTopics()).isEmpty() || !topicsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Topics");
                jsonGenerator.writeStartArray();
                for (String topicsListValue : topicsList) {
                    if (topicsListValue == null) continue;
                    jsonGenerator.writeValue(topicsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

