/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model;

import com.amazonaws.internal.SdkInternalList;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class InstanceGroupModifyConfig
implements Serializable,
Cloneable {
    private String instanceGroupId;
    private Integer instanceCount;
    private SdkInternalList<String> eC2InstanceIdsToTerminate;

    public InstanceGroupModifyConfig() {
    }

    public InstanceGroupModifyConfig(String instanceGroupId, Integer instanceCount) {
        this.setInstanceGroupId(instanceGroupId);
        this.setInstanceCount(instanceCount);
    }

    public void setInstanceGroupId(String instanceGroupId) {
        this.instanceGroupId = instanceGroupId;
    }

    public String getInstanceGroupId() {
        return this.instanceGroupId;
    }

    public InstanceGroupModifyConfig withInstanceGroupId(String instanceGroupId) {
        this.setInstanceGroupId(instanceGroupId);
        return this;
    }

    public void setInstanceCount(Integer instanceCount) {
        this.instanceCount = instanceCount;
    }

    public Integer getInstanceCount() {
        return this.instanceCount;
    }

    public InstanceGroupModifyConfig withInstanceCount(Integer instanceCount) {
        this.setInstanceCount(instanceCount);
        return this;
    }

    public List<String> getEC2InstanceIdsToTerminate() {
        if (this.eC2InstanceIdsToTerminate == null) {
            this.eC2InstanceIdsToTerminate = new SdkInternalList();
        }
        return this.eC2InstanceIdsToTerminate;
    }

    public void setEC2InstanceIdsToTerminate(Collection<String> eC2InstanceIdsToTerminate) {
        if (eC2InstanceIdsToTerminate == null) {
            this.eC2InstanceIdsToTerminate = null;
            return;
        }
        this.eC2InstanceIdsToTerminate = new SdkInternalList(eC2InstanceIdsToTerminate);
    }

    public InstanceGroupModifyConfig withEC2InstanceIdsToTerminate(String ... eC2InstanceIdsToTerminate) {
        if (this.eC2InstanceIdsToTerminate == null) {
            this.setEC2InstanceIdsToTerminate((Collection<String>)new SdkInternalList(eC2InstanceIdsToTerminate.length));
        }
        for (String ele : eC2InstanceIdsToTerminate) {
            this.eC2InstanceIdsToTerminate.add((Object)ele);
        }
        return this;
    }

    public InstanceGroupModifyConfig withEC2InstanceIdsToTerminate(Collection<String> eC2InstanceIdsToTerminate) {
        this.setEC2InstanceIdsToTerminate(eC2InstanceIdsToTerminate);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstanceGroupId() != null) {
            sb.append("InstanceGroupId: " + this.getInstanceGroupId() + ",");
        }
        if (this.getInstanceCount() != null) {
            sb.append("InstanceCount: " + this.getInstanceCount() + ",");
        }
        if (this.getEC2InstanceIdsToTerminate() != null) {
            sb.append("EC2InstanceIdsToTerminate: " + this.getEC2InstanceIdsToTerminate());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceGroupModifyConfig)) {
            return false;
        }
        InstanceGroupModifyConfig other = (InstanceGroupModifyConfig)obj;
        if (other.getInstanceGroupId() == null ^ this.getInstanceGroupId() == null) {
            return false;
        }
        if (other.getInstanceGroupId() != null && !other.getInstanceGroupId().equals(this.getInstanceGroupId())) {
            return false;
        }
        if (other.getInstanceCount() == null ^ this.getInstanceCount() == null) {
            return false;
        }
        if (other.getInstanceCount() != null && !other.getInstanceCount().equals(this.getInstanceCount())) {
            return false;
        }
        if (other.getEC2InstanceIdsToTerminate() == null ^ this.getEC2InstanceIdsToTerminate() == null) {
            return false;
        }
        return other.getEC2InstanceIdsToTerminate() == null || other.getEC2InstanceIdsToTerminate().equals(this.getEC2InstanceIdsToTerminate());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstanceGroupId() == null ? 0 : this.getInstanceGroupId().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceCount() == null ? 0 : this.getInstanceCount().hashCode());
        hashCode = 31 * hashCode + (this.getEC2InstanceIdsToTerminate() == null ? 0 : this.getEC2InstanceIdsToTerminate().hashCode());
        return hashCode;
    }

    public InstanceGroupModifyConfig clone() {
        try {
            return (InstanceGroupModifyConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

