/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticmapreduce.model.Configuration;
import com.amazonaws.services.elasticmapreduce.model.InstanceGroup;
import com.amazonaws.services.elasticmapreduce.model.transform.ConfigurationJsonMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.InstanceGroupStatusJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class InstanceGroupJsonMarshaller {
    private static InstanceGroupJsonMarshaller instance;

    public void marshall(InstanceGroup instanceGroup, JSONWriter jsonWriter) {
        if (instanceGroup == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList configurationsList;
            jsonWriter.object();
            if (instanceGroup.getId() != null) {
                jsonWriter.key("Id").value((Object)instanceGroup.getId());
            }
            if (instanceGroup.getName() != null) {
                jsonWriter.key("Name").value((Object)instanceGroup.getName());
            }
            if (instanceGroup.getMarket() != null) {
                jsonWriter.key("Market").value((Object)instanceGroup.getMarket());
            }
            if (instanceGroup.getInstanceGroupType() != null) {
                jsonWriter.key("InstanceGroupType").value((Object)instanceGroup.getInstanceGroupType());
            }
            if (instanceGroup.getBidPrice() != null) {
                jsonWriter.key("BidPrice").value((Object)instanceGroup.getBidPrice());
            }
            if (instanceGroup.getInstanceType() != null) {
                jsonWriter.key("InstanceType").value((Object)instanceGroup.getInstanceType());
            }
            if (instanceGroup.getRequestedInstanceCount() != null) {
                jsonWriter.key("RequestedInstanceCount").value((Object)instanceGroup.getRequestedInstanceCount());
            }
            if (instanceGroup.getRunningInstanceCount() != null) {
                jsonWriter.key("RunningInstanceCount").value((Object)instanceGroup.getRunningInstanceCount());
            }
            if (instanceGroup.getStatus() != null) {
                jsonWriter.key("Status");
                InstanceGroupStatusJsonMarshaller.getInstance().marshall(instanceGroup.getStatus(), jsonWriter);
            }
            if (!(configurationsList = (SdkInternalList)instanceGroup.getConfigurations()).isEmpty() || !configurationsList.isAutoConstruct()) {
                jsonWriter.key("Configurations");
                jsonWriter.array();
                for (Configuration configurationsListValue : configurationsList) {
                    if (configurationsListValue == null) continue;
                    ConfigurationJsonMarshaller.getInstance().marshall(configurationsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static InstanceGroupJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new InstanceGroupJsonMarshaller();
        }
        return instance;
    }
}

