/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.elasticmapreduce.model.ClusterSummary;
import com.amazonaws.services.elasticmapreduce.model.transform.ClusterStatusJsonMarshaller;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class ClusterSummaryJsonMarshaller {
    private static ClusterSummaryJsonMarshaller instance;

    public void marshall(ClusterSummary clusterSummary, StructuredJsonGenerator jsonGenerator) {
        if (clusterSummary == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (clusterSummary.getId() != null) {
                jsonGenerator.writeFieldName("Id").writeValue(clusterSummary.getId());
            }
            if (clusterSummary.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(clusterSummary.getName());
            }
            if (clusterSummary.getStatus() != null) {
                jsonGenerator.writeFieldName("Status");
                ClusterStatusJsonMarshaller.getInstance().marshall(clusterSummary.getStatus(), jsonGenerator);
            }
            if (clusterSummary.getNormalizedInstanceHours() != null) {
                jsonGenerator.writeFieldName("NormalizedInstanceHours").writeValue(clusterSummary.getNormalizedInstanceHours().intValue());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ClusterSummaryJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ClusterSummaryJsonMarshaller();
        }
        return instance;
    }
}

