/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticmapreduce.model.InstanceResizePolicy;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class InstanceResizePolicyJsonMarshaller {
    private static InstanceResizePolicyJsonMarshaller instance;

    public void marshall(InstanceResizePolicy instanceResizePolicy, StructuredJsonGenerator jsonGenerator) {
        if (instanceResizePolicy == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList instancesToProtectList;
            jsonGenerator.writeStartObject();
            SdkInternalList instancesToTerminateList = (SdkInternalList)instanceResizePolicy.getInstancesToTerminate();
            if (!instancesToTerminateList.isEmpty() || !instancesToTerminateList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("InstancesToTerminate");
                jsonGenerator.writeStartArray();
                for (String instancesToTerminateListValue : instancesToTerminateList) {
                    if (instancesToTerminateListValue == null) continue;
                    jsonGenerator.writeValue(instancesToTerminateListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(instancesToProtectList = (SdkInternalList)instanceResizePolicy.getInstancesToProtect()).isEmpty() || !instancesToProtectList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("InstancesToProtect");
                jsonGenerator.writeStartArray();
                for (String instancesToProtectListValue : instancesToProtectList) {
                    if (instancesToProtectListValue == null) continue;
                    jsonGenerator.writeValue(instancesToProtectListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (instanceResizePolicy.getInstanceTerminationTimeout() != null) {
                jsonGenerator.writeFieldName("InstanceTerminationTimeout").writeValue(instanceResizePolicy.getInstanceTerminationTimeout().intValue());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static InstanceResizePolicyJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new InstanceResizePolicyJsonMarshaller();
        }
        return instance;
    }
}

