/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.elasticmapreduce.model.AutoScalingPolicy;
import com.amazonaws.services.elasticmapreduce.model.ScalingRule;
import com.amazonaws.services.elasticmapreduce.model.transform.ScalingConstraintsJsonMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.ScalingRuleJsonMarshaller;

public class AutoScalingPolicyJsonMarshaller {
    private static AutoScalingPolicyJsonMarshaller instance;

    public void marshall(AutoScalingPolicy autoScalingPolicy, StructuredJsonGenerator jsonGenerator) {
        if (autoScalingPolicy == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList rulesList;
            jsonGenerator.writeStartObject();
            if (autoScalingPolicy.getConstraints() != null) {
                jsonGenerator.writeFieldName("Constraints");
                ScalingConstraintsJsonMarshaller.getInstance().marshall(autoScalingPolicy.getConstraints(), jsonGenerator);
            }
            if (!(rulesList = (SdkInternalList)autoScalingPolicy.getRules()).isEmpty() || !rulesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Rules");
                jsonGenerator.writeStartArray();
                for (ScalingRule rulesListValue : rulesList) {
                    if (rulesListValue == null) continue;
                    ScalingRuleJsonMarshaller.getInstance().marshall(rulesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static AutoScalingPolicyJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new AutoScalingPolicyJsonMarshaller();
        }
        return instance;
    }
}

