/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.emrcontainers.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Authorization-related configuration inputs for the security configuration.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/emr-containers-2020-10-01/AuthorizationConfiguration"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AuthorizationConfiguration implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * Lake Formation related configuration inputs for the security configuration.
     * </p>
     */
    private LakeFormationConfiguration lakeFormationConfiguration;
    /**
     * <p>
     * Encryption-related configuration input for the security configuration.
     * </p>
     */
    private EncryptionConfiguration encryptionConfiguration;

    /**
     * <p>
     * Lake Formation related configuration inputs for the security configuration.
     * </p>
     * 
     * @param lakeFormationConfiguration
     *        Lake Formation related configuration inputs for the security configuration.
     */

    public void setLakeFormationConfiguration(LakeFormationConfiguration lakeFormationConfiguration) {
        this.lakeFormationConfiguration = lakeFormationConfiguration;
    }

    /**
     * <p>
     * Lake Formation related configuration inputs for the security configuration.
     * </p>
     * 
     * @return Lake Formation related configuration inputs for the security configuration.
     */

    public LakeFormationConfiguration getLakeFormationConfiguration() {
        return this.lakeFormationConfiguration;
    }

    /**
     * <p>
     * Lake Formation related configuration inputs for the security configuration.
     * </p>
     * 
     * @param lakeFormationConfiguration
     *        Lake Formation related configuration inputs for the security configuration.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AuthorizationConfiguration withLakeFormationConfiguration(LakeFormationConfiguration lakeFormationConfiguration) {
        setLakeFormationConfiguration(lakeFormationConfiguration);
        return this;
    }

    /**
     * <p>
     * Encryption-related configuration input for the security configuration.
     * </p>
     * 
     * @param encryptionConfiguration
     *        Encryption-related configuration input for the security configuration.
     */

    public void setEncryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
        this.encryptionConfiguration = encryptionConfiguration;
    }

    /**
     * <p>
     * Encryption-related configuration input for the security configuration.
     * </p>
     * 
     * @return Encryption-related configuration input for the security configuration.
     */

    public EncryptionConfiguration getEncryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    /**
     * <p>
     * Encryption-related configuration input for the security configuration.
     * </p>
     * 
     * @param encryptionConfiguration
     *        Encryption-related configuration input for the security configuration.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AuthorizationConfiguration withEncryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
        setEncryptionConfiguration(encryptionConfiguration);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getLakeFormationConfiguration() != null)
            sb.append("LakeFormationConfiguration: ").append(getLakeFormationConfiguration()).append(",");
        if (getEncryptionConfiguration() != null)
            sb.append("EncryptionConfiguration: ").append(getEncryptionConfiguration());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof AuthorizationConfiguration == false)
            return false;
        AuthorizationConfiguration other = (AuthorizationConfiguration) obj;
        if (other.getLakeFormationConfiguration() == null ^ this.getLakeFormationConfiguration() == null)
            return false;
        if (other.getLakeFormationConfiguration() != null && other.getLakeFormationConfiguration().equals(this.getLakeFormationConfiguration()) == false)
            return false;
        if (other.getEncryptionConfiguration() == null ^ this.getEncryptionConfiguration() == null)
            return false;
        if (other.getEncryptionConfiguration() != null && other.getEncryptionConfiguration().equals(this.getEncryptionConfiguration()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getLakeFormationConfiguration() == null) ? 0 : getLakeFormationConfiguration().hashCode());
        hashCode = prime * hashCode + ((getEncryptionConfiguration() == null) ? 0 : getEncryptionConfiguration().hashCode());
        return hashCode;
    }

    @Override
    public AuthorizationConfiguration clone() {
        try {
            return (AuthorizationConfiguration) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.emrcontainers.model.transform.AuthorizationConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
