/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.emrcontainers.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Inputs related to the security configuration. Security configurations in Amazon EMR on EKS are templates for
 * different security setups. You can use security configurations to configure the Lake Formation integration setup. You
 * can also create a security configuration to re-use a security setup each time you create a virtual cluster.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/emr-containers-2020-10-01/SecurityConfiguration"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class SecurityConfiguration implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The ID of the security configuration.
     * </p>
     */
    private String id;
    /**
     * <p>
     * The name of the security configuration.
     * </p>
     */
    private String name;
    /**
     * <p>
     * The ARN (Amazon Resource Name) of the security configuration.
     * </p>
     */
    private String arn;
    /**
     * <p>
     * The date and time that the job run was created.
     * </p>
     */
    private java.util.Date createdAt;
    /**
     * <p>
     * The user who created the job run.
     * </p>
     */
    private String createdBy;
    /**
     * <p>
     * Security configuration inputs for the request.
     * </p>
     */
    private SecurityConfigurationData securityConfigurationData;
    /**
     * <p>
     * The tags to assign to the security configuration.
     * </p>
     */
    private java.util.Map<String, String> tags;

    /**
     * <p>
     * The ID of the security configuration.
     * </p>
     * 
     * @param id
     *        The ID of the security configuration.
     */

    public void setId(String id) {
        this.id = id;
    }

    /**
     * <p>
     * The ID of the security configuration.
     * </p>
     * 
     * @return The ID of the security configuration.
     */

    public String getId() {
        return this.id;
    }

    /**
     * <p>
     * The ID of the security configuration.
     * </p>
     * 
     * @param id
     *        The ID of the security configuration.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SecurityConfiguration withId(String id) {
        setId(id);
        return this;
    }

    /**
     * <p>
     * The name of the security configuration.
     * </p>
     * 
     * @param name
     *        The name of the security configuration.
     */

    public void setName(String name) {
        this.name = name;
    }

    /**
     * <p>
     * The name of the security configuration.
     * </p>
     * 
     * @return The name of the security configuration.
     */

    public String getName() {
        return this.name;
    }

    /**
     * <p>
     * The name of the security configuration.
     * </p>
     * 
     * @param name
     *        The name of the security configuration.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SecurityConfiguration withName(String name) {
        setName(name);
        return this;
    }

    /**
     * <p>
     * The ARN (Amazon Resource Name) of the security configuration.
     * </p>
     * 
     * @param arn
     *        The ARN (Amazon Resource Name) of the security configuration.
     */

    public void setArn(String arn) {
        this.arn = arn;
    }

    /**
     * <p>
     * The ARN (Amazon Resource Name) of the security configuration.
     * </p>
     * 
     * @return The ARN (Amazon Resource Name) of the security configuration.
     */

    public String getArn() {
        return this.arn;
    }

    /**
     * <p>
     * The ARN (Amazon Resource Name) of the security configuration.
     * </p>
     * 
     * @param arn
     *        The ARN (Amazon Resource Name) of the security configuration.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SecurityConfiguration withArn(String arn) {
        setArn(arn);
        return this;
    }

    /**
     * <p>
     * The date and time that the job run was created.
     * </p>
     * 
     * @param createdAt
     *        The date and time that the job run was created.
     */

    public void setCreatedAt(java.util.Date createdAt) {
        this.createdAt = createdAt;
    }

    /**
     * <p>
     * The date and time that the job run was created.
     * </p>
     * 
     * @return The date and time that the job run was created.
     */

    public java.util.Date getCreatedAt() {
        return this.createdAt;
    }

    /**
     * <p>
     * The date and time that the job run was created.
     * </p>
     * 
     * @param createdAt
     *        The date and time that the job run was created.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SecurityConfiguration withCreatedAt(java.util.Date createdAt) {
        setCreatedAt(createdAt);
        return this;
    }

    /**
     * <p>
     * The user who created the job run.
     * </p>
     * 
     * @param createdBy
     *        The user who created the job run.
     */

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    /**
     * <p>
     * The user who created the job run.
     * </p>
     * 
     * @return The user who created the job run.
     */

    public String getCreatedBy() {
        return this.createdBy;
    }

    /**
     * <p>
     * The user who created the job run.
     * </p>
     * 
     * @param createdBy
     *        The user who created the job run.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SecurityConfiguration withCreatedBy(String createdBy) {
        setCreatedBy(createdBy);
        return this;
    }

    /**
     * <p>
     * Security configuration inputs for the request.
     * </p>
     * 
     * @param securityConfigurationData
     *        Security configuration inputs for the request.
     */

    public void setSecurityConfigurationData(SecurityConfigurationData securityConfigurationData) {
        this.securityConfigurationData = securityConfigurationData;
    }

    /**
     * <p>
     * Security configuration inputs for the request.
     * </p>
     * 
     * @return Security configuration inputs for the request.
     */

    public SecurityConfigurationData getSecurityConfigurationData() {
        return this.securityConfigurationData;
    }

    /**
     * <p>
     * Security configuration inputs for the request.
     * </p>
     * 
     * @param securityConfigurationData
     *        Security configuration inputs for the request.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SecurityConfiguration withSecurityConfigurationData(SecurityConfigurationData securityConfigurationData) {
        setSecurityConfigurationData(securityConfigurationData);
        return this;
    }

    /**
     * <p>
     * The tags to assign to the security configuration.
     * </p>
     * 
     * @return The tags to assign to the security configuration.
     */

    public java.util.Map<String, String> getTags() {
        return tags;
    }

    /**
     * <p>
     * The tags to assign to the security configuration.
     * </p>
     * 
     * @param tags
     *        The tags to assign to the security configuration.
     */

    public void setTags(java.util.Map<String, String> tags) {
        this.tags = tags;
    }

    /**
     * <p>
     * The tags to assign to the security configuration.
     * </p>
     * 
     * @param tags
     *        The tags to assign to the security configuration.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SecurityConfiguration withTags(java.util.Map<String, String> tags) {
        setTags(tags);
        return this;
    }

    /**
     * Add a single Tags entry
     *
     * @see SecurityConfiguration#withTags
     * @returns a reference to this object so that method calls can be chained together.
     */

    public SecurityConfiguration addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new java.util.HashMap<String, String>();
        }
        if (this.tags.containsKey(key))
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        this.tags.put(key, value);
        return this;
    }

    /**
     * Removes all the entries added into Tags.
     *
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SecurityConfiguration clearTagsEntries() {
        this.tags = null;
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getId() != null)
            sb.append("Id: ").append(getId()).append(",");
        if (getName() != null)
            sb.append("Name: ").append(getName()).append(",");
        if (getArn() != null)
            sb.append("Arn: ").append(getArn()).append(",");
        if (getCreatedAt() != null)
            sb.append("CreatedAt: ").append(getCreatedAt()).append(",");
        if (getCreatedBy() != null)
            sb.append("CreatedBy: ").append(getCreatedBy()).append(",");
        if (getSecurityConfigurationData() != null)
            sb.append("SecurityConfigurationData: ").append(getSecurityConfigurationData()).append(",");
        if (getTags() != null)
            sb.append("Tags: ").append(getTags());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof SecurityConfiguration == false)
            return false;
        SecurityConfiguration other = (SecurityConfiguration) obj;
        if (other.getId() == null ^ this.getId() == null)
            return false;
        if (other.getId() != null && other.getId().equals(this.getId()) == false)
            return false;
        if (other.getName() == null ^ this.getName() == null)
            return false;
        if (other.getName() != null && other.getName().equals(this.getName()) == false)
            return false;
        if (other.getArn() == null ^ this.getArn() == null)
            return false;
        if (other.getArn() != null && other.getArn().equals(this.getArn()) == false)
            return false;
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null)
            return false;
        if (other.getCreatedAt() != null && other.getCreatedAt().equals(this.getCreatedAt()) == false)
            return false;
        if (other.getCreatedBy() == null ^ this.getCreatedBy() == null)
            return false;
        if (other.getCreatedBy() != null && other.getCreatedBy().equals(this.getCreatedBy()) == false)
            return false;
        if (other.getSecurityConfigurationData() == null ^ this.getSecurityConfigurationData() == null)
            return false;
        if (other.getSecurityConfigurationData() != null && other.getSecurityConfigurationData().equals(this.getSecurityConfigurationData()) == false)
            return false;
        if (other.getTags() == null ^ this.getTags() == null)
            return false;
        if (other.getTags() != null && other.getTags().equals(this.getTags()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getId() == null) ? 0 : getId().hashCode());
        hashCode = prime * hashCode + ((getName() == null) ? 0 : getName().hashCode());
        hashCode = prime * hashCode + ((getArn() == null) ? 0 : getArn().hashCode());
        hashCode = prime * hashCode + ((getCreatedAt() == null) ? 0 : getCreatedAt().hashCode());
        hashCode = prime * hashCode + ((getCreatedBy() == null) ? 0 : getCreatedBy().hashCode());
        hashCode = prime * hashCode + ((getSecurityConfigurationData() == null) ? 0 : getSecurityConfigurationData().hashCode());
        hashCode = prime * hashCode + ((getTags() == null) ? 0 : getTags().hashCode());
        return hashCode;
    }

    @Override
    public SecurityConfiguration clone() {
        try {
            return (SecurityConfiguration) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.emrcontainers.model.transform.SecurityConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
