/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <p>
 * Welcome to the <i>AWS Entity Resolution API Reference</i>.
 * </p>
 * <p>
 * AWS Entity Resolution is an AWS service that provides pre-configured entity resolution capabilities that enable
 * developers and analysts at advertising and marketing companies to build an accurate and complete view of their
 * consumers.
 * </p>
 * <p>
 * With AWS Entity Resolution, you have the ability to match source records containing consumer identifiers, such as
 * name, email address, and phone number. This holds true even when these records have incomplete or conflicting
 * identifiers. For example, AWS Entity Resolution can effectively match a source record from a customer relationship
 * management (CRM) system, which includes account information like first name, last name, postal address, phone number,
 * and email address, with a source record from a marketing system containing campaign information, such as username and
 * email address.
 * </p>
 * <p>
 * To learn more about AWS Entity Resolution concepts, procedures, and best practices, see the <a
 * href="https://docs.aws.amazon.com/entityresolution/latest/userguide/what-is-service.html">AWS Entity Resolution User
 * Guide</a>.
 * </p>
 */
package com.amazonaws.services.entityresolution;

