/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatchevents.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cloudwatchevents.model.ListRuleNamesByTargetRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ListRuleNamesByTargetRequestMarshaller
implements Marshaller<Request<ListRuleNamesByTargetRequest>, ListRuleNamesByTargetRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ListRuleNamesByTargetRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ListRuleNamesByTargetRequest> marshall(ListRuleNamesByTargetRequest listRuleNamesByTargetRequest) {
        if (listRuleNamesByTargetRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listRuleNamesByTargetRequest, "AmazonCloudWatchEvents");
        request.addHeader("X-Amz-Target", "AWSEvents.ListRuleNamesByTarget");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (listRuleNamesByTargetRequest.getTargetArn() != null) {
                jsonGenerator.writeFieldName("TargetArn").writeValue(listRuleNamesByTargetRequest.getTargetArn());
            }
            if (listRuleNamesByTargetRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(listRuleNamesByTargetRequest.getNextToken());
            }
            if (listRuleNamesByTargetRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue(listRuleNamesByTargetRequest.getLimit().intValue());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

