/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.finspace.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.finspace.model.transform.KxDatabaseCacheConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class KxDatabaseCacheConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String cacheType;
    private List<String> dbPaths;
    private String dataviewName;

    public void setCacheType(String cacheType) {
        this.cacheType = cacheType;
    }

    public String getCacheType() {
        return this.cacheType;
    }

    public KxDatabaseCacheConfiguration withCacheType(String cacheType) {
        this.setCacheType(cacheType);
        return this;
    }

    public List<String> getDbPaths() {
        return this.dbPaths;
    }

    public void setDbPaths(Collection<String> dbPaths) {
        if (dbPaths == null) {
            this.dbPaths = null;
            return;
        }
        this.dbPaths = new ArrayList<String>(dbPaths);
    }

    public KxDatabaseCacheConfiguration withDbPaths(String ... dbPaths) {
        if (this.dbPaths == null) {
            this.setDbPaths(new ArrayList<String>(dbPaths.length));
        }
        for (String ele : dbPaths) {
            this.dbPaths.add(ele);
        }
        return this;
    }

    public KxDatabaseCacheConfiguration withDbPaths(Collection<String> dbPaths) {
        this.setDbPaths(dbPaths);
        return this;
    }

    public void setDataviewName(String dataviewName) {
        this.dataviewName = dataviewName;
    }

    public String getDataviewName() {
        return this.dataviewName;
    }

    public KxDatabaseCacheConfiguration withDataviewName(String dataviewName) {
        this.setDataviewName(dataviewName);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCacheType() != null) {
            sb.append("CacheType: ").append(this.getCacheType()).append(",");
        }
        if (this.getDbPaths() != null) {
            sb.append("DbPaths: ").append(this.getDbPaths()).append(",");
        }
        if (this.getDataviewName() != null) {
            sb.append("DataviewName: ").append(this.getDataviewName());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KxDatabaseCacheConfiguration)) {
            return false;
        }
        KxDatabaseCacheConfiguration other = (KxDatabaseCacheConfiguration)obj;
        if (other.getCacheType() == null ^ this.getCacheType() == null) {
            return false;
        }
        if (other.getCacheType() != null && !other.getCacheType().equals(this.getCacheType())) {
            return false;
        }
        if (other.getDbPaths() == null ^ this.getDbPaths() == null) {
            return false;
        }
        if (other.getDbPaths() != null && !other.getDbPaths().equals(this.getDbPaths())) {
            return false;
        }
        if (other.getDataviewName() == null ^ this.getDataviewName() == null) {
            return false;
        }
        return other.getDataviewName() == null || other.getDataviewName().equals(this.getDataviewName());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCacheType() == null ? 0 : this.getCacheType().hashCode());
        hashCode = 31 * hashCode + (this.getDbPaths() == null ? 0 : this.getDbPaths().hashCode());
        hashCode = 31 * hashCode + (this.getDataviewName() == null ? 0 : this.getDataviewName().hashCode());
        return hashCode;
    }

    public KxDatabaseCacheConfiguration clone() {
        try {
            return (KxDatabaseCacheConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        KxDatabaseCacheConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

