/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.finspace.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.finspace.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * GetKxScalingGroupResult JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class GetKxScalingGroupResultJsonUnmarshaller implements Unmarshaller<GetKxScalingGroupResult, JsonUnmarshallerContext> {

    public GetKxScalingGroupResult unmarshall(JsonUnmarshallerContext context) throws Exception {
        GetKxScalingGroupResult getKxScalingGroupResult = new GetKxScalingGroupResult();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return getKxScalingGroupResult;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("scalingGroupName", targetDepth)) {
                    context.nextToken();
                    getKxScalingGroupResult.setScalingGroupName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("scalingGroupArn", targetDepth)) {
                    context.nextToken();
                    getKxScalingGroupResult.setScalingGroupArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("hostType", targetDepth)) {
                    context.nextToken();
                    getKxScalingGroupResult.setHostType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("clusters", targetDepth)) {
                    context.nextToken();
                    getKxScalingGroupResult.setClusters(new ListUnmarshaller<String>(context.getUnmarshaller(String.class))

                    .unmarshall(context));
                }
                if (context.testExpression("availabilityZoneId", targetDepth)) {
                    context.nextToken();
                    getKxScalingGroupResult.setAvailabilityZoneId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("status", targetDepth)) {
                    context.nextToken();
                    getKxScalingGroupResult.setStatus(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("statusReason", targetDepth)) {
                    context.nextToken();
                    getKxScalingGroupResult.setStatusReason(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("lastModifiedTimestamp", targetDepth)) {
                    context.nextToken();
                    getKxScalingGroupResult.setLastModifiedTimestamp(DateJsonUnmarshallerFactory.getInstance("unixTimestamp").unmarshall(context));
                }
                if (context.testExpression("createdTimestamp", targetDepth)) {
                    context.nextToken();
                    getKxScalingGroupResult.setCreatedTimestamp(DateJsonUnmarshallerFactory.getInstance("unixTimestamp").unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return getKxScalingGroupResult;
    }

    private static GetKxScalingGroupResultJsonUnmarshaller instance;

    public static GetKxScalingGroupResultJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new GetKxScalingGroupResultJsonUnmarshaller();
        return instance;
    }
}
