/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.finspacedata;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.finspacedata.AWSFinSpaceData;
import com.amazonaws.services.finspacedata.AWSFinSpaceDataClientBuilder;
import com.amazonaws.services.finspacedata.model.AWSFinSpaceDataException;
import com.amazonaws.services.finspacedata.model.CreateChangesetRequest;
import com.amazonaws.services.finspacedata.model.CreateChangesetResult;
import com.amazonaws.services.finspacedata.model.CreateDataViewRequest;
import com.amazonaws.services.finspacedata.model.CreateDataViewResult;
import com.amazonaws.services.finspacedata.model.CreateDatasetRequest;
import com.amazonaws.services.finspacedata.model.CreateDatasetResult;
import com.amazonaws.services.finspacedata.model.DeleteDatasetRequest;
import com.amazonaws.services.finspacedata.model.DeleteDatasetResult;
import com.amazonaws.services.finspacedata.model.GetChangesetRequest;
import com.amazonaws.services.finspacedata.model.GetChangesetResult;
import com.amazonaws.services.finspacedata.model.GetDataViewRequest;
import com.amazonaws.services.finspacedata.model.GetDataViewResult;
import com.amazonaws.services.finspacedata.model.GetDatasetRequest;
import com.amazonaws.services.finspacedata.model.GetDatasetResult;
import com.amazonaws.services.finspacedata.model.GetProgrammaticAccessCredentialsRequest;
import com.amazonaws.services.finspacedata.model.GetProgrammaticAccessCredentialsResult;
import com.amazonaws.services.finspacedata.model.GetWorkingLocationRequest;
import com.amazonaws.services.finspacedata.model.GetWorkingLocationResult;
import com.amazonaws.services.finspacedata.model.ListChangesetsRequest;
import com.amazonaws.services.finspacedata.model.ListChangesetsResult;
import com.amazonaws.services.finspacedata.model.ListDataViewsRequest;
import com.amazonaws.services.finspacedata.model.ListDataViewsResult;
import com.amazonaws.services.finspacedata.model.ListDatasetsRequest;
import com.amazonaws.services.finspacedata.model.ListDatasetsResult;
import com.amazonaws.services.finspacedata.model.UpdateChangesetRequest;
import com.amazonaws.services.finspacedata.model.UpdateChangesetResult;
import com.amazonaws.services.finspacedata.model.UpdateDatasetRequest;
import com.amazonaws.services.finspacedata.model.UpdateDatasetResult;
import com.amazonaws.services.finspacedata.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.finspacedata.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.finspacedata.model.transform.CreateChangesetRequestProtocolMarshaller;
import com.amazonaws.services.finspacedata.model.transform.CreateChangesetResultJsonUnmarshaller;
import com.amazonaws.services.finspacedata.model.transform.CreateDataViewRequestProtocolMarshaller;
import com.amazonaws.services.finspacedata.model.transform.CreateDataViewResultJsonUnmarshaller;
import com.amazonaws.services.finspacedata.model.transform.CreateDatasetRequestProtocolMarshaller;
import com.amazonaws.services.finspacedata.model.transform.CreateDatasetResultJsonUnmarshaller;
import com.amazonaws.services.finspacedata.model.transform.DeleteDatasetRequestProtocolMarshaller;
import com.amazonaws.services.finspacedata.model.transform.DeleteDatasetResultJsonUnmarshaller;
import com.amazonaws.services.finspacedata.model.transform.GetChangesetRequestProtocolMarshaller;
import com.amazonaws.services.finspacedata.model.transform.GetChangesetResultJsonUnmarshaller;
import com.amazonaws.services.finspacedata.model.transform.GetDataViewRequestProtocolMarshaller;
import com.amazonaws.services.finspacedata.model.transform.GetDataViewResultJsonUnmarshaller;
import com.amazonaws.services.finspacedata.model.transform.GetDatasetRequestProtocolMarshaller;
import com.amazonaws.services.finspacedata.model.transform.GetDatasetResultJsonUnmarshaller;
import com.amazonaws.services.finspacedata.model.transform.GetProgrammaticAccessCredentialsRequestProtocolMarshaller;
import com.amazonaws.services.finspacedata.model.transform.GetProgrammaticAccessCredentialsResultJsonUnmarshaller;
import com.amazonaws.services.finspacedata.model.transform.GetWorkingLocationRequestProtocolMarshaller;
import com.amazonaws.services.finspacedata.model.transform.GetWorkingLocationResultJsonUnmarshaller;
import com.amazonaws.services.finspacedata.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.finspacedata.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.finspacedata.model.transform.ListChangesetsRequestProtocolMarshaller;
import com.amazonaws.services.finspacedata.model.transform.ListChangesetsResultJsonUnmarshaller;
import com.amazonaws.services.finspacedata.model.transform.ListDataViewsRequestProtocolMarshaller;
import com.amazonaws.services.finspacedata.model.transform.ListDataViewsResultJsonUnmarshaller;
import com.amazonaws.services.finspacedata.model.transform.ListDatasetsRequestProtocolMarshaller;
import com.amazonaws.services.finspacedata.model.transform.ListDatasetsResultJsonUnmarshaller;
import com.amazonaws.services.finspacedata.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.finspacedata.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.finspacedata.model.transform.UpdateChangesetRequestProtocolMarshaller;
import com.amazonaws.services.finspacedata.model.transform.UpdateChangesetResultJsonUnmarshaller;
import com.amazonaws.services.finspacedata.model.transform.UpdateDatasetRequestProtocolMarshaller;
import com.amazonaws.services.finspacedata.model.transform.UpdateDatasetResultJsonUnmarshaller;
import com.amazonaws.services.finspacedata.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSFinSpaceDataClient
extends AmazonWebServiceClient
implements AWSFinSpaceData {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSFinSpaceData.class);
    private static final String DEFAULT_SIGNING_NAME = "finspace-api";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("application/json").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)LimitExceededExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSFinSpaceDataException.class));

    public static AWSFinSpaceDataClientBuilder builder() {
        return AWSFinSpaceDataClientBuilder.standard();
    }

    AWSFinSpaceDataClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSFinSpaceDataClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("finspace-api.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/finspacedata/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/finspacedata/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateChangesetResult createChangeset(CreateChangesetRequest request) {
        request = (CreateChangesetRequest)this.beforeClientExecution(request);
        return this.executeCreateChangeset(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateChangesetResult executeCreateChangeset(CreateChangesetRequest createChangesetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createChangesetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateChangesetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateChangesetRequestProtocolMarshaller(protocolFactory).marshall((CreateChangesetRequest)super.beforeMarshalling((AmazonWebServiceRequest)createChangesetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"finspace data");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateChangeset");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateChangesetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateChangesetResult createChangesetResult = (CreateChangesetResult)response.getAwsResponse();
            return createChangesetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateDataViewResult createDataView(CreateDataViewRequest request) {
        request = (CreateDataViewRequest)this.beforeClientExecution(request);
        return this.executeCreateDataView(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateDataViewResult executeCreateDataView(CreateDataViewRequest createDataViewRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createDataViewRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateDataViewRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateDataViewRequestProtocolMarshaller(protocolFactory).marshall((CreateDataViewRequest)super.beforeMarshalling((AmazonWebServiceRequest)createDataViewRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"finspace data");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateDataView");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateDataViewResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateDataViewResult createDataViewResult = (CreateDataViewResult)response.getAwsResponse();
            return createDataViewResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateDatasetResult createDataset(CreateDatasetRequest request) {
        request = (CreateDatasetRequest)this.beforeClientExecution(request);
        return this.executeCreateDataset(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateDatasetResult executeCreateDataset(CreateDatasetRequest createDatasetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createDatasetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateDatasetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateDatasetRequestProtocolMarshaller(protocolFactory).marshall((CreateDatasetRequest)super.beforeMarshalling((AmazonWebServiceRequest)createDatasetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"finspace data");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateDataset");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateDatasetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateDatasetResult createDatasetResult = (CreateDatasetResult)response.getAwsResponse();
            return createDatasetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteDatasetResult deleteDataset(DeleteDatasetRequest request) {
        request = (DeleteDatasetRequest)this.beforeClientExecution(request);
        return this.executeDeleteDataset(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteDatasetResult executeDeleteDataset(DeleteDatasetRequest deleteDatasetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteDatasetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteDatasetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteDatasetRequestProtocolMarshaller(protocolFactory).marshall((DeleteDatasetRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteDatasetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"finspace data");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteDataset");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteDatasetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteDatasetResult deleteDatasetResult = (DeleteDatasetResult)response.getAwsResponse();
            return deleteDatasetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetChangesetResult getChangeset(GetChangesetRequest request) {
        request = (GetChangesetRequest)this.beforeClientExecution(request);
        return this.executeGetChangeset(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetChangesetResult executeGetChangeset(GetChangesetRequest getChangesetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getChangesetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetChangesetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetChangesetRequestProtocolMarshaller(protocolFactory).marshall((GetChangesetRequest)super.beforeMarshalling((AmazonWebServiceRequest)getChangesetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"finspace data");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetChangeset");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetChangesetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetChangesetResult getChangesetResult = (GetChangesetResult)response.getAwsResponse();
            return getChangesetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetDataViewResult getDataView(GetDataViewRequest request) {
        request = (GetDataViewRequest)this.beforeClientExecution(request);
        return this.executeGetDataView(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetDataViewResult executeGetDataView(GetDataViewRequest getDataViewRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDataViewRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDataViewRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDataViewRequestProtocolMarshaller(protocolFactory).marshall((GetDataViewRequest)super.beforeMarshalling((AmazonWebServiceRequest)getDataViewRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"finspace data");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetDataView");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetDataViewResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetDataViewResult getDataViewResult = (GetDataViewResult)response.getAwsResponse();
            return getDataViewResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetDatasetResult getDataset(GetDatasetRequest request) {
        request = (GetDatasetRequest)this.beforeClientExecution(request);
        return this.executeGetDataset(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetDatasetResult executeGetDataset(GetDatasetRequest getDatasetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDatasetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDatasetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDatasetRequestProtocolMarshaller(protocolFactory).marshall((GetDatasetRequest)super.beforeMarshalling((AmazonWebServiceRequest)getDatasetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"finspace data");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetDataset");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetDatasetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetDatasetResult getDatasetResult = (GetDatasetResult)response.getAwsResponse();
            return getDatasetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetProgrammaticAccessCredentialsResult getProgrammaticAccessCredentials(GetProgrammaticAccessCredentialsRequest request) {
        request = (GetProgrammaticAccessCredentialsRequest)this.beforeClientExecution(request);
        return this.executeGetProgrammaticAccessCredentials(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetProgrammaticAccessCredentialsResult executeGetProgrammaticAccessCredentials(GetProgrammaticAccessCredentialsRequest getProgrammaticAccessCredentialsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getProgrammaticAccessCredentialsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetProgrammaticAccessCredentialsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetProgrammaticAccessCredentialsRequestProtocolMarshaller(protocolFactory).marshall((GetProgrammaticAccessCredentialsRequest)super.beforeMarshalling((AmazonWebServiceRequest)getProgrammaticAccessCredentialsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"finspace data");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetProgrammaticAccessCredentials");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetProgrammaticAccessCredentialsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetProgrammaticAccessCredentialsResult getProgrammaticAccessCredentialsResult = (GetProgrammaticAccessCredentialsResult)response.getAwsResponse();
            return getProgrammaticAccessCredentialsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetWorkingLocationResult getWorkingLocation(GetWorkingLocationRequest request) {
        request = (GetWorkingLocationRequest)this.beforeClientExecution(request);
        return this.executeGetWorkingLocation(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetWorkingLocationResult executeGetWorkingLocation(GetWorkingLocationRequest getWorkingLocationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getWorkingLocationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetWorkingLocationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetWorkingLocationRequestProtocolMarshaller(protocolFactory).marshall((GetWorkingLocationRequest)super.beforeMarshalling((AmazonWebServiceRequest)getWorkingLocationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"finspace data");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetWorkingLocation");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetWorkingLocationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetWorkingLocationResult getWorkingLocationResult = (GetWorkingLocationResult)response.getAwsResponse();
            return getWorkingLocationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListChangesetsResult listChangesets(ListChangesetsRequest request) {
        request = (ListChangesetsRequest)this.beforeClientExecution(request);
        return this.executeListChangesets(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListChangesetsResult executeListChangesets(ListChangesetsRequest listChangesetsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listChangesetsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListChangesetsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListChangesetsRequestProtocolMarshaller(protocolFactory).marshall((ListChangesetsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listChangesetsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"finspace data");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListChangesets");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListChangesetsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListChangesetsResult listChangesetsResult = (ListChangesetsResult)response.getAwsResponse();
            return listChangesetsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListDataViewsResult listDataViews(ListDataViewsRequest request) {
        request = (ListDataViewsRequest)this.beforeClientExecution(request);
        return this.executeListDataViews(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListDataViewsResult executeListDataViews(ListDataViewsRequest listDataViewsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDataViewsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDataViewsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDataViewsRequestProtocolMarshaller(protocolFactory).marshall((ListDataViewsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listDataViewsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"finspace data");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListDataViews");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListDataViewsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListDataViewsResult listDataViewsResult = (ListDataViewsResult)response.getAwsResponse();
            return listDataViewsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListDatasetsResult listDatasets(ListDatasetsRequest request) {
        request = (ListDatasetsRequest)this.beforeClientExecution(request);
        return this.executeListDatasets(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListDatasetsResult executeListDatasets(ListDatasetsRequest listDatasetsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDatasetsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDatasetsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDatasetsRequestProtocolMarshaller(protocolFactory).marshall((ListDatasetsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listDatasetsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"finspace data");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListDatasets");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListDatasetsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListDatasetsResult listDatasetsResult = (ListDatasetsResult)response.getAwsResponse();
            return listDatasetsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateChangesetResult updateChangeset(UpdateChangesetRequest request) {
        request = (UpdateChangesetRequest)this.beforeClientExecution(request);
        return this.executeUpdateChangeset(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateChangesetResult executeUpdateChangeset(UpdateChangesetRequest updateChangesetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateChangesetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateChangesetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateChangesetRequestProtocolMarshaller(protocolFactory).marshall((UpdateChangesetRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateChangesetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"finspace data");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateChangeset");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateChangesetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateChangesetResult updateChangesetResult = (UpdateChangesetResult)response.getAwsResponse();
            return updateChangesetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateDatasetResult updateDataset(UpdateDatasetRequest request) {
        request = (UpdateDatasetRequest)this.beforeClientExecution(request);
        return this.executeUpdateDataset(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateDatasetResult executeUpdateDataset(UpdateDatasetRequest updateDatasetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateDatasetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateDatasetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateDatasetRequestProtocolMarshaller(protocolFactory).marshall((UpdateDatasetRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateDatasetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"finspace data");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateDataset");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateDatasetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateDatasetResult updateDatasetResult = (UpdateDatasetResult)response.getAwsResponse();
            return updateDatasetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

