/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.fms.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.fms.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * SecurityGroupRuleDescription JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class SecurityGroupRuleDescriptionJsonUnmarshaller implements Unmarshaller<SecurityGroupRuleDescription, JsonUnmarshallerContext> {

    public SecurityGroupRuleDescription unmarshall(JsonUnmarshallerContext context) throws Exception {
        SecurityGroupRuleDescription securityGroupRuleDescription = new SecurityGroupRuleDescription();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        boolean knownMember;

        while (true) {
            if (token == null)
                break;

            knownMember = false;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("IPV4Range", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    securityGroupRuleDescription.setIPV4Range(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("IPV6Range", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    securityGroupRuleDescription.setIPV6Range(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("PrefixListId", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    securityGroupRuleDescription.setPrefixListId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Protocol", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    securityGroupRuleDescription.setProtocol(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("FromPort", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    securityGroupRuleDescription.setFromPort(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (context.testExpression("ToPort", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    securityGroupRuleDescription.setToPort(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (token == FIELD_NAME && !knownMember) {
                    context.nextToken();
                    com.amazonaws.transform.UnknownMemberJsonUnmarshaller.getInstance().unmarshall(context);
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return securityGroupRuleDescription;
    }

    private static SecurityGroupRuleDescriptionJsonUnmarshaller instance;

    public static SecurityGroupRuleDescriptionJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new SecurityGroupRuleDescriptionJsonUnmarshaller();
        return instance;
    }
}
