/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.fms.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.fms.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * NetworkFirewallPolicyDescription JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class NetworkFirewallPolicyDescriptionJsonUnmarshaller implements Unmarshaller<NetworkFirewallPolicyDescription, JsonUnmarshallerContext> {

    public NetworkFirewallPolicyDescription unmarshall(JsonUnmarshallerContext context) throws Exception {
        NetworkFirewallPolicyDescription networkFirewallPolicyDescription = new NetworkFirewallPolicyDescription();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("StatelessRuleGroups", targetDepth)) {
                    context.nextToken();
                    networkFirewallPolicyDescription.setStatelessRuleGroups(new ListUnmarshaller<StatelessRuleGroup>(StatelessRuleGroupJsonUnmarshaller
                            .getInstance())

                    .unmarshall(context));
                }
                if (context.testExpression("StatelessDefaultActions", targetDepth)) {
                    context.nextToken();
                    networkFirewallPolicyDescription.setStatelessDefaultActions(new ListUnmarshaller<String>(context.getUnmarshaller(String.class))

                    .unmarshall(context));
                }
                if (context.testExpression("StatelessFragmentDefaultActions", targetDepth)) {
                    context.nextToken();
                    networkFirewallPolicyDescription.setStatelessFragmentDefaultActions(new ListUnmarshaller<String>(context.getUnmarshaller(String.class))

                    .unmarshall(context));
                }
                if (context.testExpression("StatelessCustomActions", targetDepth)) {
                    context.nextToken();
                    networkFirewallPolicyDescription.setStatelessCustomActions(new ListUnmarshaller<String>(context.getUnmarshaller(String.class))

                    .unmarshall(context));
                }
                if (context.testExpression("StatefulRuleGroups", targetDepth)) {
                    context.nextToken();
                    networkFirewallPolicyDescription.setStatefulRuleGroups(new ListUnmarshaller<StatefulRuleGroup>(StatefulRuleGroupJsonUnmarshaller
                            .getInstance())

                    .unmarshall(context));
                }
                if (context.testExpression("StatefulDefaultActions", targetDepth)) {
                    context.nextToken();
                    networkFirewallPolicyDescription.setStatefulDefaultActions(new ListUnmarshaller<String>(context.getUnmarshaller(String.class))

                    .unmarshall(context));
                }
                if (context.testExpression("StatefulEngineOptions", targetDepth)) {
                    context.nextToken();
                    networkFirewallPolicyDescription.setStatefulEngineOptions(StatefulEngineOptionsJsonUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return networkFirewallPolicyDescription;
    }

    private static NetworkFirewallPolicyDescriptionJsonUnmarshaller instance;

    public static NetworkFirewallPolicyDescriptionJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new NetworkFirewallPolicyDescriptionJsonUnmarshaller();
        return instance;
    }
}
