/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.forecast.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.forecast.model.ForecastSummary;
import java.util.Date;

@SdkInternalApi
public class ForecastSummaryMarshaller {
    private static final MarshallingInfo<String> FORECASTARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ForecastArn").build();
    private static final MarshallingInfo<String> FORECASTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ForecastName").build();
    private static final MarshallingInfo<String> PREDICTORARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PredictorArn").build();
    private static final MarshallingInfo<String> DATASETGROUPARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatasetGroupArn").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<String> MESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Message").build();
    private static final MarshallingInfo<Date> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> LASTMODIFICATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModificationTime").timestampFormat("unixTimestamp").build();
    private static final ForecastSummaryMarshaller instance = new ForecastSummaryMarshaller();

    public static ForecastSummaryMarshaller getInstance() {
        return instance;
    }

    public void marshall(ForecastSummary forecastSummary, ProtocolMarshaller protocolMarshaller) {
        if (forecastSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)forecastSummary.getForecastArn(), FORECASTARN_BINDING);
            protocolMarshaller.marshall((Object)forecastSummary.getForecastName(), FORECASTNAME_BINDING);
            protocolMarshaller.marshall((Object)forecastSummary.getPredictorArn(), PREDICTORARN_BINDING);
            protocolMarshaller.marshall((Object)forecastSummary.getDatasetGroupArn(), DATASETGROUPARN_BINDING);
            protocolMarshaller.marshall((Object)forecastSummary.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)forecastSummary.getMessage(), MESSAGE_BINDING);
            protocolMarshaller.marshall((Object)forecastSummary.getCreationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)forecastSummary.getLastModificationTime(), LASTMODIFICATIONTIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

