/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.forecast.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.forecast.model.DatasetType;
import com.amazonaws.services.forecast.model.Domain;
import com.amazonaws.services.forecast.model.EncryptionConfig;
import com.amazonaws.services.forecast.model.Schema;
import com.amazonaws.services.forecast.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateDatasetRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String datasetName;
    private String domain;
    private String datasetType;
    private String dataFrequency;
    private Schema schema;
    private EncryptionConfig encryptionConfig;
    private List<Tag> tags;

    public void setDatasetName(String datasetName) {
        this.datasetName = datasetName;
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public CreateDatasetRequest withDatasetName(String datasetName) {
        this.setDatasetName(datasetName);
        return this;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getDomain() {
        return this.domain;
    }

    public CreateDatasetRequest withDomain(String domain) {
        this.setDomain(domain);
        return this;
    }

    public CreateDatasetRequest withDomain(Domain domain) {
        this.domain = domain.toString();
        return this;
    }

    public void setDatasetType(String datasetType) {
        this.datasetType = datasetType;
    }

    public String getDatasetType() {
        return this.datasetType;
    }

    public CreateDatasetRequest withDatasetType(String datasetType) {
        this.setDatasetType(datasetType);
        return this;
    }

    public CreateDatasetRequest withDatasetType(DatasetType datasetType) {
        this.datasetType = datasetType.toString();
        return this;
    }

    public void setDataFrequency(String dataFrequency) {
        this.dataFrequency = dataFrequency;
    }

    public String getDataFrequency() {
        return this.dataFrequency;
    }

    public CreateDatasetRequest withDataFrequency(String dataFrequency) {
        this.setDataFrequency(dataFrequency);
        return this;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public CreateDatasetRequest withSchema(Schema schema) {
        this.setSchema(schema);
        return this;
    }

    public void setEncryptionConfig(EncryptionConfig encryptionConfig) {
        this.encryptionConfig = encryptionConfig;
    }

    public EncryptionConfig getEncryptionConfig() {
        return this.encryptionConfig;
    }

    public CreateDatasetRequest withEncryptionConfig(EncryptionConfig encryptionConfig) {
        this.setEncryptionConfig(encryptionConfig);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateDatasetRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateDatasetRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDatasetName() != null) {
            sb.append("DatasetName: ").append(this.getDatasetName()).append(",");
        }
        if (this.getDomain() != null) {
            sb.append("Domain: ").append(this.getDomain()).append(",");
        }
        if (this.getDatasetType() != null) {
            sb.append("DatasetType: ").append(this.getDatasetType()).append(",");
        }
        if (this.getDataFrequency() != null) {
            sb.append("DataFrequency: ").append(this.getDataFrequency()).append(",");
        }
        if (this.getSchema() != null) {
            sb.append("Schema: ").append(this.getSchema()).append(",");
        }
        if (this.getEncryptionConfig() != null) {
            sb.append("EncryptionConfig: ").append(this.getEncryptionConfig()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDatasetRequest)) {
            return false;
        }
        CreateDatasetRequest other = (CreateDatasetRequest)obj;
        if (other.getDatasetName() == null ^ this.getDatasetName() == null) {
            return false;
        }
        if (other.getDatasetName() != null && !other.getDatasetName().equals(this.getDatasetName())) {
            return false;
        }
        if (other.getDomain() == null ^ this.getDomain() == null) {
            return false;
        }
        if (other.getDomain() != null && !other.getDomain().equals(this.getDomain())) {
            return false;
        }
        if (other.getDatasetType() == null ^ this.getDatasetType() == null) {
            return false;
        }
        if (other.getDatasetType() != null && !other.getDatasetType().equals(this.getDatasetType())) {
            return false;
        }
        if (other.getDataFrequency() == null ^ this.getDataFrequency() == null) {
            return false;
        }
        if (other.getDataFrequency() != null && !other.getDataFrequency().equals(this.getDataFrequency())) {
            return false;
        }
        if (other.getSchema() == null ^ this.getSchema() == null) {
            return false;
        }
        if (other.getSchema() != null && !other.getSchema().equals(this.getSchema())) {
            return false;
        }
        if (other.getEncryptionConfig() == null ^ this.getEncryptionConfig() == null) {
            return false;
        }
        if (other.getEncryptionConfig() != null && !other.getEncryptionConfig().equals(this.getEncryptionConfig())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDatasetName() == null ? 0 : this.getDatasetName().hashCode());
        hashCode = 31 * hashCode + (this.getDomain() == null ? 0 : this.getDomain().hashCode());
        hashCode = 31 * hashCode + (this.getDatasetType() == null ? 0 : this.getDatasetType().hashCode());
        hashCode = 31 * hashCode + (this.getDataFrequency() == null ? 0 : this.getDataFrequency().hashCode());
        hashCode = 31 * hashCode + (this.getSchema() == null ? 0 : this.getSchema().hashCode());
        hashCode = 31 * hashCode + (this.getEncryptionConfig() == null ? 0 : this.getEncryptionConfig().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateDatasetRequest clone() {
        return (CreateDatasetRequest)super.clone();
    }
}

