/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.forecast.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.forecast.model.DataConfig;
import com.amazonaws.services.forecast.model.EncryptionConfig;
import com.amazonaws.services.forecast.model.OptimizationMetric;
import com.amazonaws.services.forecast.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateAutoPredictorRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String predictorName;
    private Integer forecastHorizon;
    private List<String> forecastTypes;
    private List<String> forecastDimensions;
    private String forecastFrequency;
    private DataConfig dataConfig;
    private EncryptionConfig encryptionConfig;
    private String referencePredictorArn;
    private String optimizationMetric;
    private Boolean explainPredictor;
    private List<Tag> tags;

    public void setPredictorName(String predictorName) {
        this.predictorName = predictorName;
    }

    public String getPredictorName() {
        return this.predictorName;
    }

    public CreateAutoPredictorRequest withPredictorName(String predictorName) {
        this.setPredictorName(predictorName);
        return this;
    }

    public void setForecastHorizon(Integer forecastHorizon) {
        this.forecastHorizon = forecastHorizon;
    }

    public Integer getForecastHorizon() {
        return this.forecastHorizon;
    }

    public CreateAutoPredictorRequest withForecastHorizon(Integer forecastHorizon) {
        this.setForecastHorizon(forecastHorizon);
        return this;
    }

    public List<String> getForecastTypes() {
        return this.forecastTypes;
    }

    public void setForecastTypes(Collection<String> forecastTypes) {
        if (forecastTypes == null) {
            this.forecastTypes = null;
            return;
        }
        this.forecastTypes = new ArrayList<String>(forecastTypes);
    }

    public CreateAutoPredictorRequest withForecastTypes(String ... forecastTypes) {
        if (this.forecastTypes == null) {
            this.setForecastTypes(new ArrayList<String>(forecastTypes.length));
        }
        for (String ele : forecastTypes) {
            this.forecastTypes.add(ele);
        }
        return this;
    }

    public CreateAutoPredictorRequest withForecastTypes(Collection<String> forecastTypes) {
        this.setForecastTypes(forecastTypes);
        return this;
    }

    public List<String> getForecastDimensions() {
        return this.forecastDimensions;
    }

    public void setForecastDimensions(Collection<String> forecastDimensions) {
        if (forecastDimensions == null) {
            this.forecastDimensions = null;
            return;
        }
        this.forecastDimensions = new ArrayList<String>(forecastDimensions);
    }

    public CreateAutoPredictorRequest withForecastDimensions(String ... forecastDimensions) {
        if (this.forecastDimensions == null) {
            this.setForecastDimensions(new ArrayList<String>(forecastDimensions.length));
        }
        for (String ele : forecastDimensions) {
            this.forecastDimensions.add(ele);
        }
        return this;
    }

    public CreateAutoPredictorRequest withForecastDimensions(Collection<String> forecastDimensions) {
        this.setForecastDimensions(forecastDimensions);
        return this;
    }

    public void setForecastFrequency(String forecastFrequency) {
        this.forecastFrequency = forecastFrequency;
    }

    public String getForecastFrequency() {
        return this.forecastFrequency;
    }

    public CreateAutoPredictorRequest withForecastFrequency(String forecastFrequency) {
        this.setForecastFrequency(forecastFrequency);
        return this;
    }

    public void setDataConfig(DataConfig dataConfig) {
        this.dataConfig = dataConfig;
    }

    public DataConfig getDataConfig() {
        return this.dataConfig;
    }

    public CreateAutoPredictorRequest withDataConfig(DataConfig dataConfig) {
        this.setDataConfig(dataConfig);
        return this;
    }

    public void setEncryptionConfig(EncryptionConfig encryptionConfig) {
        this.encryptionConfig = encryptionConfig;
    }

    public EncryptionConfig getEncryptionConfig() {
        return this.encryptionConfig;
    }

    public CreateAutoPredictorRequest withEncryptionConfig(EncryptionConfig encryptionConfig) {
        this.setEncryptionConfig(encryptionConfig);
        return this;
    }

    public void setReferencePredictorArn(String referencePredictorArn) {
        this.referencePredictorArn = referencePredictorArn;
    }

    public String getReferencePredictorArn() {
        return this.referencePredictorArn;
    }

    public CreateAutoPredictorRequest withReferencePredictorArn(String referencePredictorArn) {
        this.setReferencePredictorArn(referencePredictorArn);
        return this;
    }

    public void setOptimizationMetric(String optimizationMetric) {
        this.optimizationMetric = optimizationMetric;
    }

    public String getOptimizationMetric() {
        return this.optimizationMetric;
    }

    public CreateAutoPredictorRequest withOptimizationMetric(String optimizationMetric) {
        this.setOptimizationMetric(optimizationMetric);
        return this;
    }

    public CreateAutoPredictorRequest withOptimizationMetric(OptimizationMetric optimizationMetric) {
        this.optimizationMetric = optimizationMetric.toString();
        return this;
    }

    public void setExplainPredictor(Boolean explainPredictor) {
        this.explainPredictor = explainPredictor;
    }

    public Boolean getExplainPredictor() {
        return this.explainPredictor;
    }

    public CreateAutoPredictorRequest withExplainPredictor(Boolean explainPredictor) {
        this.setExplainPredictor(explainPredictor);
        return this;
    }

    public Boolean isExplainPredictor() {
        return this.explainPredictor;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateAutoPredictorRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateAutoPredictorRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPredictorName() != null) {
            sb.append("PredictorName: ").append(this.getPredictorName()).append(",");
        }
        if (this.getForecastHorizon() != null) {
            sb.append("ForecastHorizon: ").append(this.getForecastHorizon()).append(",");
        }
        if (this.getForecastTypes() != null) {
            sb.append("ForecastTypes: ").append(this.getForecastTypes()).append(",");
        }
        if (this.getForecastDimensions() != null) {
            sb.append("ForecastDimensions: ").append(this.getForecastDimensions()).append(",");
        }
        if (this.getForecastFrequency() != null) {
            sb.append("ForecastFrequency: ").append(this.getForecastFrequency()).append(",");
        }
        if (this.getDataConfig() != null) {
            sb.append("DataConfig: ").append(this.getDataConfig()).append(",");
        }
        if (this.getEncryptionConfig() != null) {
            sb.append("EncryptionConfig: ").append(this.getEncryptionConfig()).append(",");
        }
        if (this.getReferencePredictorArn() != null) {
            sb.append("ReferencePredictorArn: ").append(this.getReferencePredictorArn()).append(",");
        }
        if (this.getOptimizationMetric() != null) {
            sb.append("OptimizationMetric: ").append(this.getOptimizationMetric()).append(",");
        }
        if (this.getExplainPredictor() != null) {
            sb.append("ExplainPredictor: ").append(this.getExplainPredictor()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAutoPredictorRequest)) {
            return false;
        }
        CreateAutoPredictorRequest other = (CreateAutoPredictorRequest)obj;
        if (other.getPredictorName() == null ^ this.getPredictorName() == null) {
            return false;
        }
        if (other.getPredictorName() != null && !other.getPredictorName().equals(this.getPredictorName())) {
            return false;
        }
        if (other.getForecastHorizon() == null ^ this.getForecastHorizon() == null) {
            return false;
        }
        if (other.getForecastHorizon() != null && !other.getForecastHorizon().equals(this.getForecastHorizon())) {
            return false;
        }
        if (other.getForecastTypes() == null ^ this.getForecastTypes() == null) {
            return false;
        }
        if (other.getForecastTypes() != null && !other.getForecastTypes().equals(this.getForecastTypes())) {
            return false;
        }
        if (other.getForecastDimensions() == null ^ this.getForecastDimensions() == null) {
            return false;
        }
        if (other.getForecastDimensions() != null && !other.getForecastDimensions().equals(this.getForecastDimensions())) {
            return false;
        }
        if (other.getForecastFrequency() == null ^ this.getForecastFrequency() == null) {
            return false;
        }
        if (other.getForecastFrequency() != null && !other.getForecastFrequency().equals(this.getForecastFrequency())) {
            return false;
        }
        if (other.getDataConfig() == null ^ this.getDataConfig() == null) {
            return false;
        }
        if (other.getDataConfig() != null && !other.getDataConfig().equals(this.getDataConfig())) {
            return false;
        }
        if (other.getEncryptionConfig() == null ^ this.getEncryptionConfig() == null) {
            return false;
        }
        if (other.getEncryptionConfig() != null && !other.getEncryptionConfig().equals(this.getEncryptionConfig())) {
            return false;
        }
        if (other.getReferencePredictorArn() == null ^ this.getReferencePredictorArn() == null) {
            return false;
        }
        if (other.getReferencePredictorArn() != null && !other.getReferencePredictorArn().equals(this.getReferencePredictorArn())) {
            return false;
        }
        if (other.getOptimizationMetric() == null ^ this.getOptimizationMetric() == null) {
            return false;
        }
        if (other.getOptimizationMetric() != null && !other.getOptimizationMetric().equals(this.getOptimizationMetric())) {
            return false;
        }
        if (other.getExplainPredictor() == null ^ this.getExplainPredictor() == null) {
            return false;
        }
        if (other.getExplainPredictor() != null && !other.getExplainPredictor().equals(this.getExplainPredictor())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPredictorName() == null ? 0 : this.getPredictorName().hashCode());
        hashCode = 31 * hashCode + (this.getForecastHorizon() == null ? 0 : this.getForecastHorizon().hashCode());
        hashCode = 31 * hashCode + (this.getForecastTypes() == null ? 0 : this.getForecastTypes().hashCode());
        hashCode = 31 * hashCode + (this.getForecastDimensions() == null ? 0 : this.getForecastDimensions().hashCode());
        hashCode = 31 * hashCode + (this.getForecastFrequency() == null ? 0 : this.getForecastFrequency().hashCode());
        hashCode = 31 * hashCode + (this.getDataConfig() == null ? 0 : this.getDataConfig().hashCode());
        hashCode = 31 * hashCode + (this.getEncryptionConfig() == null ? 0 : this.getEncryptionConfig().hashCode());
        hashCode = 31 * hashCode + (this.getReferencePredictorArn() == null ? 0 : this.getReferencePredictorArn().hashCode());
        hashCode = 31 * hashCode + (this.getOptimizationMetric() == null ? 0 : this.getOptimizationMetric().hashCode());
        hashCode = 31 * hashCode + (this.getExplainPredictor() == null ? 0 : this.getExplainPredictor().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateAutoPredictorRequest clone() {
        return (CreateAutoPredictorRequest)super.clone();
    }
}

