/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.forecast;

import javax.annotation.Generated;

import com.amazonaws.services.forecast.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AmazonForecast}. Convenient method forms pass through to the corresponding overload
 * that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonForecast implements AmazonForecast {

    protected AbstractAmazonForecast() {
    }

    @Override
    public CreateAutoPredictorResult createAutoPredictor(CreateAutoPredictorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDatasetResult createDataset(CreateDatasetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDatasetGroupResult createDatasetGroup(CreateDatasetGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDatasetImportJobResult createDatasetImportJob(CreateDatasetImportJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateExplainabilityResult createExplainability(CreateExplainabilityRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateExplainabilityExportResult createExplainabilityExport(CreateExplainabilityExportRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateForecastResult createForecast(CreateForecastRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateForecastExportJobResult createForecastExportJob(CreateForecastExportJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateMonitorResult createMonitor(CreateMonitorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreatePredictorResult createPredictor(CreatePredictorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreatePredictorBacktestExportJobResult createPredictorBacktestExportJob(CreatePredictorBacktestExportJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateWhatIfAnalysisResult createWhatIfAnalysis(CreateWhatIfAnalysisRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateWhatIfForecastResult createWhatIfForecast(CreateWhatIfForecastRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateWhatIfForecastExportResult createWhatIfForecastExport(CreateWhatIfForecastExportRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDatasetResult deleteDataset(DeleteDatasetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDatasetGroupResult deleteDatasetGroup(DeleteDatasetGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDatasetImportJobResult deleteDatasetImportJob(DeleteDatasetImportJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteExplainabilityResult deleteExplainability(DeleteExplainabilityRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteExplainabilityExportResult deleteExplainabilityExport(DeleteExplainabilityExportRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteForecastResult deleteForecast(DeleteForecastRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteForecastExportJobResult deleteForecastExportJob(DeleteForecastExportJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteMonitorResult deleteMonitor(DeleteMonitorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeletePredictorResult deletePredictor(DeletePredictorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeletePredictorBacktestExportJobResult deletePredictorBacktestExportJob(DeletePredictorBacktestExportJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteResourceTreeResult deleteResourceTree(DeleteResourceTreeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteWhatIfAnalysisResult deleteWhatIfAnalysis(DeleteWhatIfAnalysisRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteWhatIfForecastResult deleteWhatIfForecast(DeleteWhatIfForecastRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteWhatIfForecastExportResult deleteWhatIfForecastExport(DeleteWhatIfForecastExportRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAutoPredictorResult describeAutoPredictor(DescribeAutoPredictorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeDatasetResult describeDataset(DescribeDatasetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeDatasetGroupResult describeDatasetGroup(DescribeDatasetGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeDatasetImportJobResult describeDatasetImportJob(DescribeDatasetImportJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeExplainabilityResult describeExplainability(DescribeExplainabilityRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeExplainabilityExportResult describeExplainabilityExport(DescribeExplainabilityExportRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeForecastResult describeForecast(DescribeForecastRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeForecastExportJobResult describeForecastExportJob(DescribeForecastExportJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeMonitorResult describeMonitor(DescribeMonitorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribePredictorResult describePredictor(DescribePredictorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribePredictorBacktestExportJobResult describePredictorBacktestExportJob(DescribePredictorBacktestExportJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeWhatIfAnalysisResult describeWhatIfAnalysis(DescribeWhatIfAnalysisRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeWhatIfForecastResult describeWhatIfForecast(DescribeWhatIfForecastRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeWhatIfForecastExportResult describeWhatIfForecastExport(DescribeWhatIfForecastExportRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAccuracyMetricsResult getAccuracyMetrics(GetAccuracyMetricsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDatasetGroupsResult listDatasetGroups(ListDatasetGroupsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDatasetImportJobsResult listDatasetImportJobs(ListDatasetImportJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDatasetsResult listDatasets(ListDatasetsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListExplainabilitiesResult listExplainabilities(ListExplainabilitiesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListExplainabilityExportsResult listExplainabilityExports(ListExplainabilityExportsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListForecastExportJobsResult listForecastExportJobs(ListForecastExportJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListForecastsResult listForecasts(ListForecastsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListMonitorEvaluationsResult listMonitorEvaluations(ListMonitorEvaluationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListMonitorsResult listMonitors(ListMonitorsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPredictorBacktestExportJobsResult listPredictorBacktestExportJobs(ListPredictorBacktestExportJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPredictorsResult listPredictors(ListPredictorsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListWhatIfAnalysesResult listWhatIfAnalyses(ListWhatIfAnalysesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListWhatIfForecastExportsResult listWhatIfForecastExports(ListWhatIfForecastExportsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListWhatIfForecastsResult listWhatIfForecasts(ListWhatIfForecastsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ResumeResourceResult resumeResource(ResumeResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopResourceResult stopResource(StopResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDatasetGroupResult updateDatasetGroup(UpdateDatasetGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
