/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.forecast.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DescribeWhatIfForecastExport"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DescribeWhatIfForecastExportRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the what-if forecast export that you are interested in.
     * </p>
     */
    private String whatIfForecastExportArn;

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the what-if forecast export that you are interested in.
     * </p>
     * 
     * @param whatIfForecastExportArn
     *        The Amazon Resource Name (ARN) of the what-if forecast export that you are interested in.
     */

    public void setWhatIfForecastExportArn(String whatIfForecastExportArn) {
        this.whatIfForecastExportArn = whatIfForecastExportArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the what-if forecast export that you are interested in.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the what-if forecast export that you are interested in.
     */

    public String getWhatIfForecastExportArn() {
        return this.whatIfForecastExportArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the what-if forecast export that you are interested in.
     * </p>
     * 
     * @param whatIfForecastExportArn
     *        The Amazon Resource Name (ARN) of the what-if forecast export that you are interested in.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeWhatIfForecastExportRequest withWhatIfForecastExportArn(String whatIfForecastExportArn) {
        setWhatIfForecastExportArn(whatIfForecastExportArn);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getWhatIfForecastExportArn() != null)
            sb.append("WhatIfForecastExportArn: ").append(getWhatIfForecastExportArn());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DescribeWhatIfForecastExportRequest == false)
            return false;
        DescribeWhatIfForecastExportRequest other = (DescribeWhatIfForecastExportRequest) obj;
        if (other.getWhatIfForecastExportArn() == null ^ this.getWhatIfForecastExportArn() == null)
            return false;
        if (other.getWhatIfForecastExportArn() != null && other.getWhatIfForecastExportArn().equals(this.getWhatIfForecastExportArn()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getWhatIfForecastExportArn() == null) ? 0 : getWhatIfForecastExportArn().hashCode());
        return hashCode;
    }

    @Override
    public DescribeWhatIfForecastExportRequest clone() {
        return (DescribeWhatIfForecastExportRequest) super.clone();
    }

}
