/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.forecast.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DescribeWhatIfForecastExport"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DescribeWhatIfForecastExportResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the what-if forecast export.
     * </p>
     */
    private String whatIfForecastExportArn;
    /**
     * <p>
     * The name of the what-if forecast export.
     * </p>
     */
    private String whatIfForecastExportName;
    /**
     * <p>
     * An array of Amazon Resource Names (ARNs) that represent all of the what-if forecasts exported in this resource.
     * </p>
     */
    private java.util.List<String> whatIfForecastArns;

    private DataDestination destination;
    /**
     * <p>
     * If an error occurred, an informational message about the error.
     * </p>
     */
    private String message;
    /**
     * <p>
     * The status of the what-if forecast. States include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * The <code>Status</code> of the what-if forecast export must be <code>ACTIVE</code> before you can access the
     * forecast export.
     * </p>
     * </note>
     */
    private String status;
    /**
     * <p>
     * When the what-if forecast export was created.
     * </p>
     */
    private java.util.Date creationTime;
    /**
     * <p>
     * The approximate time remaining to complete the what-if forecast export, in minutes.
     * </p>
     */
    private Long estimatedTimeRemainingInMinutes;
    /**
     * <p>
     * The last time the resource was modified. The timestamp depends on the status of the job:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_IN_PROGRESS</code> - The current timestamp.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_STOPPING</code> - The current timestamp.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_STOPPED</code> - When the job stopped.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
     * </p>
     * </li>
     * </ul>
     */
    private java.util.Date lastModificationTime;
    /**
     * <p>
     * The format of the exported data, CSV or PARQUET.
     * </p>
     */
    private String format;

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the what-if forecast export.
     * </p>
     * 
     * @param whatIfForecastExportArn
     *        The Amazon Resource Name (ARN) of the what-if forecast export.
     */

    public void setWhatIfForecastExportArn(String whatIfForecastExportArn) {
        this.whatIfForecastExportArn = whatIfForecastExportArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the what-if forecast export.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the what-if forecast export.
     */

    public String getWhatIfForecastExportArn() {
        return this.whatIfForecastExportArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the what-if forecast export.
     * </p>
     * 
     * @param whatIfForecastExportArn
     *        The Amazon Resource Name (ARN) of the what-if forecast export.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeWhatIfForecastExportResult withWhatIfForecastExportArn(String whatIfForecastExportArn) {
        setWhatIfForecastExportArn(whatIfForecastExportArn);
        return this;
    }

    /**
     * <p>
     * The name of the what-if forecast export.
     * </p>
     * 
     * @param whatIfForecastExportName
     *        The name of the what-if forecast export.
     */

    public void setWhatIfForecastExportName(String whatIfForecastExportName) {
        this.whatIfForecastExportName = whatIfForecastExportName;
    }

    /**
     * <p>
     * The name of the what-if forecast export.
     * </p>
     * 
     * @return The name of the what-if forecast export.
     */

    public String getWhatIfForecastExportName() {
        return this.whatIfForecastExportName;
    }

    /**
     * <p>
     * The name of the what-if forecast export.
     * </p>
     * 
     * @param whatIfForecastExportName
     *        The name of the what-if forecast export.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeWhatIfForecastExportResult withWhatIfForecastExportName(String whatIfForecastExportName) {
        setWhatIfForecastExportName(whatIfForecastExportName);
        return this;
    }

    /**
     * <p>
     * An array of Amazon Resource Names (ARNs) that represent all of the what-if forecasts exported in this resource.
     * </p>
     * 
     * @return An array of Amazon Resource Names (ARNs) that represent all of the what-if forecasts exported in this
     *         resource.
     */

    public java.util.List<String> getWhatIfForecastArns() {
        return whatIfForecastArns;
    }

    /**
     * <p>
     * An array of Amazon Resource Names (ARNs) that represent all of the what-if forecasts exported in this resource.
     * </p>
     * 
     * @param whatIfForecastArns
     *        An array of Amazon Resource Names (ARNs) that represent all of the what-if forecasts exported in this
     *        resource.
     */

    public void setWhatIfForecastArns(java.util.Collection<String> whatIfForecastArns) {
        if (whatIfForecastArns == null) {
            this.whatIfForecastArns = null;
            return;
        }

        this.whatIfForecastArns = new java.util.ArrayList<String>(whatIfForecastArns);
    }

    /**
     * <p>
     * An array of Amazon Resource Names (ARNs) that represent all of the what-if forecasts exported in this resource.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setWhatIfForecastArns(java.util.Collection)} or {@link #withWhatIfForecastArns(java.util.Collection)} if
     * you want to override the existing values.
     * </p>
     * 
     * @param whatIfForecastArns
     *        An array of Amazon Resource Names (ARNs) that represent all of the what-if forecasts exported in this
     *        resource.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeWhatIfForecastExportResult withWhatIfForecastArns(String... whatIfForecastArns) {
        if (this.whatIfForecastArns == null) {
            setWhatIfForecastArns(new java.util.ArrayList<String>(whatIfForecastArns.length));
        }
        for (String ele : whatIfForecastArns) {
            this.whatIfForecastArns.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * An array of Amazon Resource Names (ARNs) that represent all of the what-if forecasts exported in this resource.
     * </p>
     * 
     * @param whatIfForecastArns
     *        An array of Amazon Resource Names (ARNs) that represent all of the what-if forecasts exported in this
     *        resource.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeWhatIfForecastExportResult withWhatIfForecastArns(java.util.Collection<String> whatIfForecastArns) {
        setWhatIfForecastArns(whatIfForecastArns);
        return this;
    }

    /**
     * @param destination
     */

    public void setDestination(DataDestination destination) {
        this.destination = destination;
    }

    /**
     * @return
     */

    public DataDestination getDestination() {
        return this.destination;
    }

    /**
     * @param destination
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeWhatIfForecastExportResult withDestination(DataDestination destination) {
        setDestination(destination);
        return this;
    }

    /**
     * <p>
     * If an error occurred, an informational message about the error.
     * </p>
     * 
     * @param message
     *        If an error occurred, an informational message about the error.
     */

    public void setMessage(String message) {
        this.message = message;
    }

    /**
     * <p>
     * If an error occurred, an informational message about the error.
     * </p>
     * 
     * @return If an error occurred, an informational message about the error.
     */

    public String getMessage() {
        return this.message;
    }

    /**
     * <p>
     * If an error occurred, an informational message about the error.
     * </p>
     * 
     * @param message
     *        If an error occurred, an informational message about the error.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeWhatIfForecastExportResult withMessage(String message) {
        setMessage(message);
        return this;
    }

    /**
     * <p>
     * The status of the what-if forecast. States include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * The <code>Status</code> of the what-if forecast export must be <code>ACTIVE</code> before you can access the
     * forecast export.
     * </p>
     * </note>
     * 
     * @param status
     *        The status of the what-if forecast. States include:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>ACTIVE</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
     *        </p>
     *        </li>
     *        </ul>
     *        <note>
     *        <p>
     *        The <code>Status</code> of the what-if forecast export must be <code>ACTIVE</code> before you can access
     *        the forecast export.
     *        </p>
     */

    public void setStatus(String status) {
        this.status = status;
    }

    /**
     * <p>
     * The status of the what-if forecast. States include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * The <code>Status</code> of the what-if forecast export must be <code>ACTIVE</code> before you can access the
     * forecast export.
     * </p>
     * </note>
     * 
     * @return The status of the what-if forecast. States include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         The <code>Status</code> of the what-if forecast export must be <code>ACTIVE</code> before you can access
     *         the forecast export.
     *         </p>
     */

    public String getStatus() {
        return this.status;
    }

    /**
     * <p>
     * The status of the what-if forecast. States include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * The <code>Status</code> of the what-if forecast export must be <code>ACTIVE</code> before you can access the
     * forecast export.
     * </p>
     * </note>
     * 
     * @param status
     *        The status of the what-if forecast. States include:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>ACTIVE</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
     *        </p>
     *        </li>
     *        </ul>
     *        <note>
     *        <p>
     *        The <code>Status</code> of the what-if forecast export must be <code>ACTIVE</code> before you can access
     *        the forecast export.
     *        </p>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeWhatIfForecastExportResult withStatus(String status) {
        setStatus(status);
        return this;
    }

    /**
     * <p>
     * When the what-if forecast export was created.
     * </p>
     * 
     * @param creationTime
     *        When the what-if forecast export was created.
     */

    public void setCreationTime(java.util.Date creationTime) {
        this.creationTime = creationTime;
    }

    /**
     * <p>
     * When the what-if forecast export was created.
     * </p>
     * 
     * @return When the what-if forecast export was created.
     */

    public java.util.Date getCreationTime() {
        return this.creationTime;
    }

    /**
     * <p>
     * When the what-if forecast export was created.
     * </p>
     * 
     * @param creationTime
     *        When the what-if forecast export was created.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeWhatIfForecastExportResult withCreationTime(java.util.Date creationTime) {
        setCreationTime(creationTime);
        return this;
    }

    /**
     * <p>
     * The approximate time remaining to complete the what-if forecast export, in minutes.
     * </p>
     * 
     * @param estimatedTimeRemainingInMinutes
     *        The approximate time remaining to complete the what-if forecast export, in minutes.
     */

    public void setEstimatedTimeRemainingInMinutes(Long estimatedTimeRemainingInMinutes) {
        this.estimatedTimeRemainingInMinutes = estimatedTimeRemainingInMinutes;
    }

    /**
     * <p>
     * The approximate time remaining to complete the what-if forecast export, in minutes.
     * </p>
     * 
     * @return The approximate time remaining to complete the what-if forecast export, in minutes.
     */

    public Long getEstimatedTimeRemainingInMinutes() {
        return this.estimatedTimeRemainingInMinutes;
    }

    /**
     * <p>
     * The approximate time remaining to complete the what-if forecast export, in minutes.
     * </p>
     * 
     * @param estimatedTimeRemainingInMinutes
     *        The approximate time remaining to complete the what-if forecast export, in minutes.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeWhatIfForecastExportResult withEstimatedTimeRemainingInMinutes(Long estimatedTimeRemainingInMinutes) {
        setEstimatedTimeRemainingInMinutes(estimatedTimeRemainingInMinutes);
        return this;
    }

    /**
     * <p>
     * The last time the resource was modified. The timestamp depends on the status of the job:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_IN_PROGRESS</code> - The current timestamp.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_STOPPING</code> - The current timestamp.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_STOPPED</code> - When the job stopped.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
     * </p>
     * </li>
     * </ul>
     * 
     * @param lastModificationTime
     *        The last time the resource was modified. The timestamp depends on the status of the job:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>CREATE_IN_PROGRESS</code> - The current timestamp.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>CREATE_STOPPING</code> - The current timestamp.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>CREATE_STOPPED</code> - When the job stopped.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
     *        </p>
     *        </li>
     */

    public void setLastModificationTime(java.util.Date lastModificationTime) {
        this.lastModificationTime = lastModificationTime;
    }

    /**
     * <p>
     * The last time the resource was modified. The timestamp depends on the status of the job:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_IN_PROGRESS</code> - The current timestamp.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_STOPPING</code> - The current timestamp.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_STOPPED</code> - When the job stopped.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The last time the resource was modified. The timestamp depends on the status of the job:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_IN_PROGRESS</code> - The current timestamp.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_STOPPING</code> - The current timestamp.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_STOPPED</code> - When the job stopped.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
     *         </p>
     *         </li>
     */

    public java.util.Date getLastModificationTime() {
        return this.lastModificationTime;
    }

    /**
     * <p>
     * The last time the resource was modified. The timestamp depends on the status of the job:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_IN_PROGRESS</code> - The current timestamp.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_STOPPING</code> - The current timestamp.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_STOPPED</code> - When the job stopped.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
     * </p>
     * </li>
     * </ul>
     * 
     * @param lastModificationTime
     *        The last time the resource was modified. The timestamp depends on the status of the job:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>CREATE_IN_PROGRESS</code> - The current timestamp.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>CREATE_STOPPING</code> - The current timestamp.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>CREATE_STOPPED</code> - When the job stopped.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeWhatIfForecastExportResult withLastModificationTime(java.util.Date lastModificationTime) {
        setLastModificationTime(lastModificationTime);
        return this;
    }

    /**
     * <p>
     * The format of the exported data, CSV or PARQUET.
     * </p>
     * 
     * @param format
     *        The format of the exported data, CSV or PARQUET.
     */

    public void setFormat(String format) {
        this.format = format;
    }

    /**
     * <p>
     * The format of the exported data, CSV or PARQUET.
     * </p>
     * 
     * @return The format of the exported data, CSV or PARQUET.
     */

    public String getFormat() {
        return this.format;
    }

    /**
     * <p>
     * The format of the exported data, CSV or PARQUET.
     * </p>
     * 
     * @param format
     *        The format of the exported data, CSV or PARQUET.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeWhatIfForecastExportResult withFormat(String format) {
        setFormat(format);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getWhatIfForecastExportArn() != null)
            sb.append("WhatIfForecastExportArn: ").append(getWhatIfForecastExportArn()).append(",");
        if (getWhatIfForecastExportName() != null)
            sb.append("WhatIfForecastExportName: ").append(getWhatIfForecastExportName()).append(",");
        if (getWhatIfForecastArns() != null)
            sb.append("WhatIfForecastArns: ").append(getWhatIfForecastArns()).append(",");
        if (getDestination() != null)
            sb.append("Destination: ").append(getDestination()).append(",");
        if (getMessage() != null)
            sb.append("Message: ").append(getMessage()).append(",");
        if (getStatus() != null)
            sb.append("Status: ").append(getStatus()).append(",");
        if (getCreationTime() != null)
            sb.append("CreationTime: ").append(getCreationTime()).append(",");
        if (getEstimatedTimeRemainingInMinutes() != null)
            sb.append("EstimatedTimeRemainingInMinutes: ").append(getEstimatedTimeRemainingInMinutes()).append(",");
        if (getLastModificationTime() != null)
            sb.append("LastModificationTime: ").append(getLastModificationTime()).append(",");
        if (getFormat() != null)
            sb.append("Format: ").append(getFormat());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DescribeWhatIfForecastExportResult == false)
            return false;
        DescribeWhatIfForecastExportResult other = (DescribeWhatIfForecastExportResult) obj;
        if (other.getWhatIfForecastExportArn() == null ^ this.getWhatIfForecastExportArn() == null)
            return false;
        if (other.getWhatIfForecastExportArn() != null && other.getWhatIfForecastExportArn().equals(this.getWhatIfForecastExportArn()) == false)
            return false;
        if (other.getWhatIfForecastExportName() == null ^ this.getWhatIfForecastExportName() == null)
            return false;
        if (other.getWhatIfForecastExportName() != null && other.getWhatIfForecastExportName().equals(this.getWhatIfForecastExportName()) == false)
            return false;
        if (other.getWhatIfForecastArns() == null ^ this.getWhatIfForecastArns() == null)
            return false;
        if (other.getWhatIfForecastArns() != null && other.getWhatIfForecastArns().equals(this.getWhatIfForecastArns()) == false)
            return false;
        if (other.getDestination() == null ^ this.getDestination() == null)
            return false;
        if (other.getDestination() != null && other.getDestination().equals(this.getDestination()) == false)
            return false;
        if (other.getMessage() == null ^ this.getMessage() == null)
            return false;
        if (other.getMessage() != null && other.getMessage().equals(this.getMessage()) == false)
            return false;
        if (other.getStatus() == null ^ this.getStatus() == null)
            return false;
        if (other.getStatus() != null && other.getStatus().equals(this.getStatus()) == false)
            return false;
        if (other.getCreationTime() == null ^ this.getCreationTime() == null)
            return false;
        if (other.getCreationTime() != null && other.getCreationTime().equals(this.getCreationTime()) == false)
            return false;
        if (other.getEstimatedTimeRemainingInMinutes() == null ^ this.getEstimatedTimeRemainingInMinutes() == null)
            return false;
        if (other.getEstimatedTimeRemainingInMinutes() != null
                && other.getEstimatedTimeRemainingInMinutes().equals(this.getEstimatedTimeRemainingInMinutes()) == false)
            return false;
        if (other.getLastModificationTime() == null ^ this.getLastModificationTime() == null)
            return false;
        if (other.getLastModificationTime() != null && other.getLastModificationTime().equals(this.getLastModificationTime()) == false)
            return false;
        if (other.getFormat() == null ^ this.getFormat() == null)
            return false;
        if (other.getFormat() != null && other.getFormat().equals(this.getFormat()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getWhatIfForecastExportArn() == null) ? 0 : getWhatIfForecastExportArn().hashCode());
        hashCode = prime * hashCode + ((getWhatIfForecastExportName() == null) ? 0 : getWhatIfForecastExportName().hashCode());
        hashCode = prime * hashCode + ((getWhatIfForecastArns() == null) ? 0 : getWhatIfForecastArns().hashCode());
        hashCode = prime * hashCode + ((getDestination() == null) ? 0 : getDestination().hashCode());
        hashCode = prime * hashCode + ((getMessage() == null) ? 0 : getMessage().hashCode());
        hashCode = prime * hashCode + ((getStatus() == null) ? 0 : getStatus().hashCode());
        hashCode = prime * hashCode + ((getCreationTime() == null) ? 0 : getCreationTime().hashCode());
        hashCode = prime * hashCode + ((getEstimatedTimeRemainingInMinutes() == null) ? 0 : getEstimatedTimeRemainingInMinutes().hashCode());
        hashCode = prime * hashCode + ((getLastModificationTime() == null) ? 0 : getLastModificationTime().hashCode());
        hashCode = prime * hashCode + ((getFormat() == null) ? 0 : getFormat().hashCode());
        return hashCode;
    }

    @Override
    public DescribeWhatIfForecastExportResult clone() {
        try {
            return (DescribeWhatIfForecastExportResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
