/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.frauddetector;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.frauddetector.AmazonFraudDetectorAsync;
import com.amazonaws.services.frauddetector.AmazonFraudDetectorAsyncClientBuilder;
import com.amazonaws.services.frauddetector.AmazonFraudDetectorClient;
import com.amazonaws.services.frauddetector.model.BatchCreateVariableRequest;
import com.amazonaws.services.frauddetector.model.BatchCreateVariableResult;
import com.amazonaws.services.frauddetector.model.BatchGetVariableRequest;
import com.amazonaws.services.frauddetector.model.BatchGetVariableResult;
import com.amazonaws.services.frauddetector.model.CreateDetectorVersionRequest;
import com.amazonaws.services.frauddetector.model.CreateDetectorVersionResult;
import com.amazonaws.services.frauddetector.model.CreateModelVersionRequest;
import com.amazonaws.services.frauddetector.model.CreateModelVersionResult;
import com.amazonaws.services.frauddetector.model.CreateRuleRequest;
import com.amazonaws.services.frauddetector.model.CreateRuleResult;
import com.amazonaws.services.frauddetector.model.CreateVariableRequest;
import com.amazonaws.services.frauddetector.model.CreateVariableResult;
import com.amazonaws.services.frauddetector.model.DeleteDetectorRequest;
import com.amazonaws.services.frauddetector.model.DeleteDetectorResult;
import com.amazonaws.services.frauddetector.model.DeleteDetectorVersionRequest;
import com.amazonaws.services.frauddetector.model.DeleteDetectorVersionResult;
import com.amazonaws.services.frauddetector.model.DeleteEventRequest;
import com.amazonaws.services.frauddetector.model.DeleteEventResult;
import com.amazonaws.services.frauddetector.model.DeleteRuleVersionRequest;
import com.amazonaws.services.frauddetector.model.DeleteRuleVersionResult;
import com.amazonaws.services.frauddetector.model.DescribeDetectorRequest;
import com.amazonaws.services.frauddetector.model.DescribeDetectorResult;
import com.amazonaws.services.frauddetector.model.DescribeModelVersionsRequest;
import com.amazonaws.services.frauddetector.model.DescribeModelVersionsResult;
import com.amazonaws.services.frauddetector.model.GetDetectorVersionRequest;
import com.amazonaws.services.frauddetector.model.GetDetectorVersionResult;
import com.amazonaws.services.frauddetector.model.GetDetectorsRequest;
import com.amazonaws.services.frauddetector.model.GetDetectorsResult;
import com.amazonaws.services.frauddetector.model.GetExternalModelsRequest;
import com.amazonaws.services.frauddetector.model.GetExternalModelsResult;
import com.amazonaws.services.frauddetector.model.GetModelVersionRequest;
import com.amazonaws.services.frauddetector.model.GetModelVersionResult;
import com.amazonaws.services.frauddetector.model.GetModelsRequest;
import com.amazonaws.services.frauddetector.model.GetModelsResult;
import com.amazonaws.services.frauddetector.model.GetOutcomesRequest;
import com.amazonaws.services.frauddetector.model.GetOutcomesResult;
import com.amazonaws.services.frauddetector.model.GetPredictionRequest;
import com.amazonaws.services.frauddetector.model.GetPredictionResult;
import com.amazonaws.services.frauddetector.model.GetRulesRequest;
import com.amazonaws.services.frauddetector.model.GetRulesResult;
import com.amazonaws.services.frauddetector.model.GetVariablesRequest;
import com.amazonaws.services.frauddetector.model.GetVariablesResult;
import com.amazonaws.services.frauddetector.model.PutDetectorRequest;
import com.amazonaws.services.frauddetector.model.PutDetectorResult;
import com.amazonaws.services.frauddetector.model.PutExternalModelRequest;
import com.amazonaws.services.frauddetector.model.PutExternalModelResult;
import com.amazonaws.services.frauddetector.model.PutModelRequest;
import com.amazonaws.services.frauddetector.model.PutModelResult;
import com.amazonaws.services.frauddetector.model.PutOutcomeRequest;
import com.amazonaws.services.frauddetector.model.PutOutcomeResult;
import com.amazonaws.services.frauddetector.model.UpdateDetectorVersionMetadataRequest;
import com.amazonaws.services.frauddetector.model.UpdateDetectorVersionMetadataResult;
import com.amazonaws.services.frauddetector.model.UpdateDetectorVersionRequest;
import com.amazonaws.services.frauddetector.model.UpdateDetectorVersionResult;
import com.amazonaws.services.frauddetector.model.UpdateDetectorVersionStatusRequest;
import com.amazonaws.services.frauddetector.model.UpdateDetectorVersionStatusResult;
import com.amazonaws.services.frauddetector.model.UpdateModelVersionRequest;
import com.amazonaws.services.frauddetector.model.UpdateModelVersionResult;
import com.amazonaws.services.frauddetector.model.UpdateRuleMetadataRequest;
import com.amazonaws.services.frauddetector.model.UpdateRuleMetadataResult;
import com.amazonaws.services.frauddetector.model.UpdateRuleVersionRequest;
import com.amazonaws.services.frauddetector.model.UpdateRuleVersionResult;
import com.amazonaws.services.frauddetector.model.UpdateVariableRequest;
import com.amazonaws.services.frauddetector.model.UpdateVariableResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonFraudDetectorAsyncClient
extends AmazonFraudDetectorClient
implements AmazonFraudDetectorAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonFraudDetectorAsyncClientBuilder asyncBuilder() {
        return AmazonFraudDetectorAsyncClientBuilder.standard();
    }

    AmazonFraudDetectorAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonFraudDetectorAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<BatchCreateVariableResult> batchCreateVariableAsync(BatchCreateVariableRequest request) {
        return this.batchCreateVariableAsync(request, null);
    }

    @Override
    public Future<BatchCreateVariableResult> batchCreateVariableAsync(BatchCreateVariableRequest request, final AsyncHandler<BatchCreateVariableRequest, BatchCreateVariableResult> asyncHandler) {
        final BatchCreateVariableRequest finalRequest = (BatchCreateVariableRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchCreateVariableResult>(){

            @Override
            public BatchCreateVariableResult call() throws Exception {
                BatchCreateVariableResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeBatchCreateVariable(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchGetVariableResult> batchGetVariableAsync(BatchGetVariableRequest request) {
        return this.batchGetVariableAsync(request, null);
    }

    @Override
    public Future<BatchGetVariableResult> batchGetVariableAsync(BatchGetVariableRequest request, final AsyncHandler<BatchGetVariableRequest, BatchGetVariableResult> asyncHandler) {
        final BatchGetVariableRequest finalRequest = (BatchGetVariableRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchGetVariableResult>(){

            @Override
            public BatchGetVariableResult call() throws Exception {
                BatchGetVariableResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeBatchGetVariable(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateDetectorVersionResult> createDetectorVersionAsync(CreateDetectorVersionRequest request) {
        return this.createDetectorVersionAsync(request, null);
    }

    @Override
    public Future<CreateDetectorVersionResult> createDetectorVersionAsync(CreateDetectorVersionRequest request, final AsyncHandler<CreateDetectorVersionRequest, CreateDetectorVersionResult> asyncHandler) {
        final CreateDetectorVersionRequest finalRequest = (CreateDetectorVersionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateDetectorVersionResult>(){

            @Override
            public CreateDetectorVersionResult call() throws Exception {
                CreateDetectorVersionResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeCreateDetectorVersion(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateModelVersionResult> createModelVersionAsync(CreateModelVersionRequest request) {
        return this.createModelVersionAsync(request, null);
    }

    @Override
    public Future<CreateModelVersionResult> createModelVersionAsync(CreateModelVersionRequest request, final AsyncHandler<CreateModelVersionRequest, CreateModelVersionResult> asyncHandler) {
        final CreateModelVersionRequest finalRequest = (CreateModelVersionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateModelVersionResult>(){

            @Override
            public CreateModelVersionResult call() throws Exception {
                CreateModelVersionResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeCreateModelVersion(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateRuleResult> createRuleAsync(CreateRuleRequest request) {
        return this.createRuleAsync(request, null);
    }

    @Override
    public Future<CreateRuleResult> createRuleAsync(CreateRuleRequest request, final AsyncHandler<CreateRuleRequest, CreateRuleResult> asyncHandler) {
        final CreateRuleRequest finalRequest = (CreateRuleRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateRuleResult>(){

            @Override
            public CreateRuleResult call() throws Exception {
                CreateRuleResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeCreateRule(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateVariableResult> createVariableAsync(CreateVariableRequest request) {
        return this.createVariableAsync(request, null);
    }

    @Override
    public Future<CreateVariableResult> createVariableAsync(CreateVariableRequest request, final AsyncHandler<CreateVariableRequest, CreateVariableResult> asyncHandler) {
        final CreateVariableRequest finalRequest = (CreateVariableRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateVariableResult>(){

            @Override
            public CreateVariableResult call() throws Exception {
                CreateVariableResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeCreateVariable(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDetectorResult> deleteDetectorAsync(DeleteDetectorRequest request) {
        return this.deleteDetectorAsync(request, null);
    }

    @Override
    public Future<DeleteDetectorResult> deleteDetectorAsync(DeleteDetectorRequest request, final AsyncHandler<DeleteDetectorRequest, DeleteDetectorResult> asyncHandler) {
        final DeleteDetectorRequest finalRequest = (DeleteDetectorRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteDetectorResult>(){

            @Override
            public DeleteDetectorResult call() throws Exception {
                DeleteDetectorResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeDeleteDetector(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDetectorVersionResult> deleteDetectorVersionAsync(DeleteDetectorVersionRequest request) {
        return this.deleteDetectorVersionAsync(request, null);
    }

    @Override
    public Future<DeleteDetectorVersionResult> deleteDetectorVersionAsync(DeleteDetectorVersionRequest request, final AsyncHandler<DeleteDetectorVersionRequest, DeleteDetectorVersionResult> asyncHandler) {
        final DeleteDetectorVersionRequest finalRequest = (DeleteDetectorVersionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteDetectorVersionResult>(){

            @Override
            public DeleteDetectorVersionResult call() throws Exception {
                DeleteDetectorVersionResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeDeleteDetectorVersion(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteEventResult> deleteEventAsync(DeleteEventRequest request) {
        return this.deleteEventAsync(request, null);
    }

    @Override
    public Future<DeleteEventResult> deleteEventAsync(DeleteEventRequest request, final AsyncHandler<DeleteEventRequest, DeleteEventResult> asyncHandler) {
        final DeleteEventRequest finalRequest = (DeleteEventRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteEventResult>(){

            @Override
            public DeleteEventResult call() throws Exception {
                DeleteEventResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeDeleteEvent(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteRuleVersionResult> deleteRuleVersionAsync(DeleteRuleVersionRequest request) {
        return this.deleteRuleVersionAsync(request, null);
    }

    @Override
    public Future<DeleteRuleVersionResult> deleteRuleVersionAsync(DeleteRuleVersionRequest request, final AsyncHandler<DeleteRuleVersionRequest, DeleteRuleVersionResult> asyncHandler) {
        final DeleteRuleVersionRequest finalRequest = (DeleteRuleVersionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteRuleVersionResult>(){

            @Override
            public DeleteRuleVersionResult call() throws Exception {
                DeleteRuleVersionResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeDeleteRuleVersion(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDetectorResult> describeDetectorAsync(DescribeDetectorRequest request) {
        return this.describeDetectorAsync(request, null);
    }

    @Override
    public Future<DescribeDetectorResult> describeDetectorAsync(DescribeDetectorRequest request, final AsyncHandler<DescribeDetectorRequest, DescribeDetectorResult> asyncHandler) {
        final DescribeDetectorRequest finalRequest = (DescribeDetectorRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDetectorResult>(){

            @Override
            public DescribeDetectorResult call() throws Exception {
                DescribeDetectorResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeDescribeDetector(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeModelVersionsResult> describeModelVersionsAsync(DescribeModelVersionsRequest request) {
        return this.describeModelVersionsAsync(request, null);
    }

    @Override
    public Future<DescribeModelVersionsResult> describeModelVersionsAsync(DescribeModelVersionsRequest request, final AsyncHandler<DescribeModelVersionsRequest, DescribeModelVersionsResult> asyncHandler) {
        final DescribeModelVersionsRequest finalRequest = (DescribeModelVersionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeModelVersionsResult>(){

            @Override
            public DescribeModelVersionsResult call() throws Exception {
                DescribeModelVersionsResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeDescribeModelVersions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDetectorVersionResult> getDetectorVersionAsync(GetDetectorVersionRequest request) {
        return this.getDetectorVersionAsync(request, null);
    }

    @Override
    public Future<GetDetectorVersionResult> getDetectorVersionAsync(GetDetectorVersionRequest request, final AsyncHandler<GetDetectorVersionRequest, GetDetectorVersionResult> asyncHandler) {
        final GetDetectorVersionRequest finalRequest = (GetDetectorVersionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDetectorVersionResult>(){

            @Override
            public GetDetectorVersionResult call() throws Exception {
                GetDetectorVersionResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeGetDetectorVersion(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDetectorsResult> getDetectorsAsync(GetDetectorsRequest request) {
        return this.getDetectorsAsync(request, null);
    }

    @Override
    public Future<GetDetectorsResult> getDetectorsAsync(GetDetectorsRequest request, final AsyncHandler<GetDetectorsRequest, GetDetectorsResult> asyncHandler) {
        final GetDetectorsRequest finalRequest = (GetDetectorsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDetectorsResult>(){

            @Override
            public GetDetectorsResult call() throws Exception {
                GetDetectorsResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeGetDetectors(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetExternalModelsResult> getExternalModelsAsync(GetExternalModelsRequest request) {
        return this.getExternalModelsAsync(request, null);
    }

    @Override
    public Future<GetExternalModelsResult> getExternalModelsAsync(GetExternalModelsRequest request, final AsyncHandler<GetExternalModelsRequest, GetExternalModelsResult> asyncHandler) {
        final GetExternalModelsRequest finalRequest = (GetExternalModelsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetExternalModelsResult>(){

            @Override
            public GetExternalModelsResult call() throws Exception {
                GetExternalModelsResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeGetExternalModels(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetModelVersionResult> getModelVersionAsync(GetModelVersionRequest request) {
        return this.getModelVersionAsync(request, null);
    }

    @Override
    public Future<GetModelVersionResult> getModelVersionAsync(GetModelVersionRequest request, final AsyncHandler<GetModelVersionRequest, GetModelVersionResult> asyncHandler) {
        final GetModelVersionRequest finalRequest = (GetModelVersionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetModelVersionResult>(){

            @Override
            public GetModelVersionResult call() throws Exception {
                GetModelVersionResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeGetModelVersion(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetModelsResult> getModelsAsync(GetModelsRequest request) {
        return this.getModelsAsync(request, null);
    }

    @Override
    public Future<GetModelsResult> getModelsAsync(GetModelsRequest request, final AsyncHandler<GetModelsRequest, GetModelsResult> asyncHandler) {
        final GetModelsRequest finalRequest = (GetModelsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetModelsResult>(){

            @Override
            public GetModelsResult call() throws Exception {
                GetModelsResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeGetModels(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetOutcomesResult> getOutcomesAsync(GetOutcomesRequest request) {
        return this.getOutcomesAsync(request, null);
    }

    @Override
    public Future<GetOutcomesResult> getOutcomesAsync(GetOutcomesRequest request, final AsyncHandler<GetOutcomesRequest, GetOutcomesResult> asyncHandler) {
        final GetOutcomesRequest finalRequest = (GetOutcomesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetOutcomesResult>(){

            @Override
            public GetOutcomesResult call() throws Exception {
                GetOutcomesResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeGetOutcomes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetPredictionResult> getPredictionAsync(GetPredictionRequest request) {
        return this.getPredictionAsync(request, null);
    }

    @Override
    public Future<GetPredictionResult> getPredictionAsync(GetPredictionRequest request, final AsyncHandler<GetPredictionRequest, GetPredictionResult> asyncHandler) {
        final GetPredictionRequest finalRequest = (GetPredictionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetPredictionResult>(){

            @Override
            public GetPredictionResult call() throws Exception {
                GetPredictionResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeGetPrediction(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetRulesResult> getRulesAsync(GetRulesRequest request) {
        return this.getRulesAsync(request, null);
    }

    @Override
    public Future<GetRulesResult> getRulesAsync(GetRulesRequest request, final AsyncHandler<GetRulesRequest, GetRulesResult> asyncHandler) {
        final GetRulesRequest finalRequest = (GetRulesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetRulesResult>(){

            @Override
            public GetRulesResult call() throws Exception {
                GetRulesResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeGetRules(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetVariablesResult> getVariablesAsync(GetVariablesRequest request) {
        return this.getVariablesAsync(request, null);
    }

    @Override
    public Future<GetVariablesResult> getVariablesAsync(GetVariablesRequest request, final AsyncHandler<GetVariablesRequest, GetVariablesResult> asyncHandler) {
        final GetVariablesRequest finalRequest = (GetVariablesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetVariablesResult>(){

            @Override
            public GetVariablesResult call() throws Exception {
                GetVariablesResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeGetVariables(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutDetectorResult> putDetectorAsync(PutDetectorRequest request) {
        return this.putDetectorAsync(request, null);
    }

    @Override
    public Future<PutDetectorResult> putDetectorAsync(PutDetectorRequest request, final AsyncHandler<PutDetectorRequest, PutDetectorResult> asyncHandler) {
        final PutDetectorRequest finalRequest = (PutDetectorRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutDetectorResult>(){

            @Override
            public PutDetectorResult call() throws Exception {
                PutDetectorResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executePutDetector(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutExternalModelResult> putExternalModelAsync(PutExternalModelRequest request) {
        return this.putExternalModelAsync(request, null);
    }

    @Override
    public Future<PutExternalModelResult> putExternalModelAsync(PutExternalModelRequest request, final AsyncHandler<PutExternalModelRequest, PutExternalModelResult> asyncHandler) {
        final PutExternalModelRequest finalRequest = (PutExternalModelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutExternalModelResult>(){

            @Override
            public PutExternalModelResult call() throws Exception {
                PutExternalModelResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executePutExternalModel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutModelResult> putModelAsync(PutModelRequest request) {
        return this.putModelAsync(request, null);
    }

    @Override
    public Future<PutModelResult> putModelAsync(PutModelRequest request, final AsyncHandler<PutModelRequest, PutModelResult> asyncHandler) {
        final PutModelRequest finalRequest = (PutModelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutModelResult>(){

            @Override
            public PutModelResult call() throws Exception {
                PutModelResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executePutModel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutOutcomeResult> putOutcomeAsync(PutOutcomeRequest request) {
        return this.putOutcomeAsync(request, null);
    }

    @Override
    public Future<PutOutcomeResult> putOutcomeAsync(PutOutcomeRequest request, final AsyncHandler<PutOutcomeRequest, PutOutcomeResult> asyncHandler) {
        final PutOutcomeRequest finalRequest = (PutOutcomeRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutOutcomeResult>(){

            @Override
            public PutOutcomeResult call() throws Exception {
                PutOutcomeResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executePutOutcome(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateDetectorVersionResult> updateDetectorVersionAsync(UpdateDetectorVersionRequest request) {
        return this.updateDetectorVersionAsync(request, null);
    }

    @Override
    public Future<UpdateDetectorVersionResult> updateDetectorVersionAsync(UpdateDetectorVersionRequest request, final AsyncHandler<UpdateDetectorVersionRequest, UpdateDetectorVersionResult> asyncHandler) {
        final UpdateDetectorVersionRequest finalRequest = (UpdateDetectorVersionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateDetectorVersionResult>(){

            @Override
            public UpdateDetectorVersionResult call() throws Exception {
                UpdateDetectorVersionResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeUpdateDetectorVersion(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateDetectorVersionMetadataResult> updateDetectorVersionMetadataAsync(UpdateDetectorVersionMetadataRequest request) {
        return this.updateDetectorVersionMetadataAsync(request, null);
    }

    @Override
    public Future<UpdateDetectorVersionMetadataResult> updateDetectorVersionMetadataAsync(UpdateDetectorVersionMetadataRequest request, final AsyncHandler<UpdateDetectorVersionMetadataRequest, UpdateDetectorVersionMetadataResult> asyncHandler) {
        final UpdateDetectorVersionMetadataRequest finalRequest = (UpdateDetectorVersionMetadataRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateDetectorVersionMetadataResult>(){

            @Override
            public UpdateDetectorVersionMetadataResult call() throws Exception {
                UpdateDetectorVersionMetadataResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeUpdateDetectorVersionMetadata(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateDetectorVersionStatusResult> updateDetectorVersionStatusAsync(UpdateDetectorVersionStatusRequest request) {
        return this.updateDetectorVersionStatusAsync(request, null);
    }

    @Override
    public Future<UpdateDetectorVersionStatusResult> updateDetectorVersionStatusAsync(UpdateDetectorVersionStatusRequest request, final AsyncHandler<UpdateDetectorVersionStatusRequest, UpdateDetectorVersionStatusResult> asyncHandler) {
        final UpdateDetectorVersionStatusRequest finalRequest = (UpdateDetectorVersionStatusRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateDetectorVersionStatusResult>(){

            @Override
            public UpdateDetectorVersionStatusResult call() throws Exception {
                UpdateDetectorVersionStatusResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeUpdateDetectorVersionStatus(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateModelVersionResult> updateModelVersionAsync(UpdateModelVersionRequest request) {
        return this.updateModelVersionAsync(request, null);
    }

    @Override
    public Future<UpdateModelVersionResult> updateModelVersionAsync(UpdateModelVersionRequest request, final AsyncHandler<UpdateModelVersionRequest, UpdateModelVersionResult> asyncHandler) {
        final UpdateModelVersionRequest finalRequest = (UpdateModelVersionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateModelVersionResult>(){

            @Override
            public UpdateModelVersionResult call() throws Exception {
                UpdateModelVersionResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeUpdateModelVersion(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateRuleMetadataResult> updateRuleMetadataAsync(UpdateRuleMetadataRequest request) {
        return this.updateRuleMetadataAsync(request, null);
    }

    @Override
    public Future<UpdateRuleMetadataResult> updateRuleMetadataAsync(UpdateRuleMetadataRequest request, final AsyncHandler<UpdateRuleMetadataRequest, UpdateRuleMetadataResult> asyncHandler) {
        final UpdateRuleMetadataRequest finalRequest = (UpdateRuleMetadataRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateRuleMetadataResult>(){

            @Override
            public UpdateRuleMetadataResult call() throws Exception {
                UpdateRuleMetadataResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeUpdateRuleMetadata(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateRuleVersionResult> updateRuleVersionAsync(UpdateRuleVersionRequest request) {
        return this.updateRuleVersionAsync(request, null);
    }

    @Override
    public Future<UpdateRuleVersionResult> updateRuleVersionAsync(UpdateRuleVersionRequest request, final AsyncHandler<UpdateRuleVersionRequest, UpdateRuleVersionResult> asyncHandler) {
        final UpdateRuleVersionRequest finalRequest = (UpdateRuleVersionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateRuleVersionResult>(){

            @Override
            public UpdateRuleVersionResult call() throws Exception {
                UpdateRuleVersionResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeUpdateRuleVersion(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateVariableResult> updateVariableAsync(UpdateVariableRequest request) {
        return this.updateVariableAsync(request, null);
    }

    @Override
    public Future<UpdateVariableResult> updateVariableAsync(UpdateVariableRequest request, final AsyncHandler<UpdateVariableRequest, UpdateVariableResult> asyncHandler) {
        final UpdateVariableRequest finalRequest = (UpdateVariableRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateVariableResult>(){

            @Override
            public UpdateVariableResult call() throws Exception {
                UpdateVariableResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeUpdateVariable(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

