/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.frauddetector.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.frauddetector.model.ExternalModel;

@SdkInternalApi
public class ExternalModelMarshaller {
    private static final MarshallingInfo<String> MODELENDPOINT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("modelEndpoint").build();
    private static final MarshallingInfo<String> MODELSOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("modelSource").build();
    private static final MarshallingInfo<StructuredPojo> ROLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("role").build();
    private static final MarshallingInfo<StructuredPojo> INPUTCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("inputConfiguration").build();
    private static final MarshallingInfo<StructuredPojo> OUTPUTCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("outputConfiguration").build();
    private static final MarshallingInfo<String> MODELENDPOINTSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("modelEndpointStatus").build();
    private static final MarshallingInfo<String> LASTUPDATEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastUpdatedTime").build();
    private static final MarshallingInfo<String> CREATEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdTime").build();
    private static final ExternalModelMarshaller instance = new ExternalModelMarshaller();

    public static ExternalModelMarshaller getInstance() {
        return instance;
    }

    public void marshall(ExternalModel externalModel, ProtocolMarshaller protocolMarshaller) {
        if (externalModel == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)externalModel.getModelEndpoint(), MODELENDPOINT_BINDING);
            protocolMarshaller.marshall((Object)externalModel.getModelSource(), MODELSOURCE_BINDING);
            protocolMarshaller.marshall((Object)externalModel.getRole(), ROLE_BINDING);
            protocolMarshaller.marshall((Object)externalModel.getInputConfiguration(), INPUTCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)externalModel.getOutputConfiguration(), OUTPUTCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)externalModel.getModelEndpointStatus(), MODELENDPOINTSTATUS_BINDING);
            protocolMarshaller.marshall((Object)externalModel.getLastUpdatedTime(), LASTUPDATEDTIME_BINDING);
            protocolMarshaller.marshall((Object)externalModel.getCreatedTime(), CREATEDTIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

