/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.frauddetector.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.frauddetector.model.ListUpdateMode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateListRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private List<String> elements;
    private String description;
    private String updateMode;
    private String variableType;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public UpdateListRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public List<String> getElements() {
        return this.elements;
    }

    public void setElements(Collection<String> elements) {
        if (elements == null) {
            this.elements = null;
            return;
        }
        this.elements = new ArrayList<String>(elements);
    }

    public UpdateListRequest withElements(String ... elements) {
        if (this.elements == null) {
            this.setElements(new ArrayList<String>(elements.length));
        }
        for (String ele : elements) {
            this.elements.add(ele);
        }
        return this;
    }

    public UpdateListRequest withElements(Collection<String> elements) {
        this.setElements(elements);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public UpdateListRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setUpdateMode(String updateMode) {
        this.updateMode = updateMode;
    }

    public String getUpdateMode() {
        return this.updateMode;
    }

    public UpdateListRequest withUpdateMode(String updateMode) {
        this.setUpdateMode(updateMode);
        return this;
    }

    public UpdateListRequest withUpdateMode(ListUpdateMode updateMode) {
        this.updateMode = updateMode.toString();
        return this;
    }

    public void setVariableType(String variableType) {
        this.variableType = variableType;
    }

    public String getVariableType() {
        return this.variableType;
    }

    public UpdateListRequest withVariableType(String variableType) {
        this.setVariableType(variableType);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getElements() != null) {
            sb.append("Elements: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getUpdateMode() != null) {
            sb.append("UpdateMode: ").append(this.getUpdateMode()).append(",");
        }
        if (this.getVariableType() != null) {
            sb.append("VariableType: ").append(this.getVariableType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateListRequest)) {
            return false;
        }
        UpdateListRequest other = (UpdateListRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getElements() == null ^ this.getElements() == null) {
            return false;
        }
        if (other.getElements() != null && !other.getElements().equals(this.getElements())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getUpdateMode() == null ^ this.getUpdateMode() == null) {
            return false;
        }
        if (other.getUpdateMode() != null && !other.getUpdateMode().equals(this.getUpdateMode())) {
            return false;
        }
        if (other.getVariableType() == null ^ this.getVariableType() == null) {
            return false;
        }
        return other.getVariableType() == null || other.getVariableType().equals(this.getVariableType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getElements() == null ? 0 : this.getElements().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getUpdateMode() == null ? 0 : this.getUpdateMode().hashCode());
        hashCode = 31 * hashCode + (this.getVariableType() == null ? 0 : this.getVariableType().hashCode());
        return hashCode;
    }

    public UpdateListRequest clone() {
        return (UpdateListRequest)super.clone();
    }
}

