/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <p>
 * This is the Amazon Fraud Detector API Reference. This guide is for developers who need detailed information about
 * Amazon Fraud Detector API actions, data types, and errors. For more information about Amazon Fraud Detector features,
 * see the <a href="https://docs.aws.amazon.com/frauddetector/latest/ug/">Amazon Fraud Detector User Guide</a>.
 * </p>
 * <p>
 * We provide the Query API as well as AWS software development kits (SDK) for Amazon Fraud Detector in Java and Python
 * programming languages.
 * </p>
 * <p>
 * The Amazon Fraud Detector Query API provides HTTPS requests that use the HTTP verb GET or POST and a Query parameter
 * <code>Action</code>. AWS SDK provides libraries, sample code, tutorials, and other resources for software developers
 * who prefer to build applications using language-specific APIs instead of submitting a request over HTTP or HTTPS.
 * These libraries provide basic functions that automatically take care of tasks such as cryptographically signing your
 * requests, retrying requests, and handling error responses, so that it is easier for you to get started. For more
 * information about the AWS SDKs, go to <a href="https://aws.amazon.com/developer/tools/">Tools to build on AWS</a>
 * page, scroll down to the <b>SDK</b> section, and choose plus (+) sign to expand the section.
 * </p>
 */
package com.amazonaws.services.frauddetector;

