/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.fsx.model;

import javax.annotation.Generated;

/**
 * <p>
 * The request was rejected because the lifecycle status of the source backup isn't <code>AVAILABLE</code>.
 * </p>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class SourceBackupUnavailableException extends com.amazonaws.services.fsx.model.AmazonFSxException {
    private static final long serialVersionUID = 1L;

    private String backupId;

    /**
     * Constructs a new SourceBackupUnavailableException with the specified error message.
     *
     * @param message
     *        Describes the error encountered.
     */
    public SourceBackupUnavailableException(String message) {
        super(message);
    }

    /**
     * @param backupId
     */

    @com.fasterxml.jackson.annotation.JsonProperty("BackupId")
    public void setBackupId(String backupId) {
        this.backupId = backupId;
    }

    /**
     * @return
     */

    @com.fasterxml.jackson.annotation.JsonProperty("BackupId")
    public String getBackupId() {
        return this.backupId;
    }

    /**
     * @param backupId
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SourceBackupUnavailableException withBackupId(String backupId) {
        setBackupId(backupId);
        return this;
    }

}
