/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fsx.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.fsx.model.DiskIopsConfiguration;
import com.amazonaws.services.fsx.model.OpenZFSDeploymentType;
import com.amazonaws.services.fsx.model.transform.OpenZFSFileSystemConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class OpenZFSFileSystemConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer automaticBackupRetentionDays;
    private Boolean copyTagsToBackups;
    private Boolean copyTagsToVolumes;
    private String dailyAutomaticBackupStartTime;
    private String deploymentType;
    private Integer throughputCapacity;
    private String weeklyMaintenanceStartTime;
    private DiskIopsConfiguration diskIopsConfiguration;
    private String rootVolumeId;
    private String preferredSubnetId;
    private String endpointIpAddressRange;
    private List<String> routeTableIds;
    private String endpointIpAddress;

    public void setAutomaticBackupRetentionDays(Integer automaticBackupRetentionDays) {
        this.automaticBackupRetentionDays = automaticBackupRetentionDays;
    }

    public Integer getAutomaticBackupRetentionDays() {
        return this.automaticBackupRetentionDays;
    }

    public OpenZFSFileSystemConfiguration withAutomaticBackupRetentionDays(Integer automaticBackupRetentionDays) {
        this.setAutomaticBackupRetentionDays(automaticBackupRetentionDays);
        return this;
    }

    public void setCopyTagsToBackups(Boolean copyTagsToBackups) {
        this.copyTagsToBackups = copyTagsToBackups;
    }

    public Boolean getCopyTagsToBackups() {
        return this.copyTagsToBackups;
    }

    public OpenZFSFileSystemConfiguration withCopyTagsToBackups(Boolean copyTagsToBackups) {
        this.setCopyTagsToBackups(copyTagsToBackups);
        return this;
    }

    public Boolean isCopyTagsToBackups() {
        return this.copyTagsToBackups;
    }

    public void setCopyTagsToVolumes(Boolean copyTagsToVolumes) {
        this.copyTagsToVolumes = copyTagsToVolumes;
    }

    public Boolean getCopyTagsToVolumes() {
        return this.copyTagsToVolumes;
    }

    public OpenZFSFileSystemConfiguration withCopyTagsToVolumes(Boolean copyTagsToVolumes) {
        this.setCopyTagsToVolumes(copyTagsToVolumes);
        return this;
    }

    public Boolean isCopyTagsToVolumes() {
        return this.copyTagsToVolumes;
    }

    public void setDailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime) {
        this.dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime;
    }

    public String getDailyAutomaticBackupStartTime() {
        return this.dailyAutomaticBackupStartTime;
    }

    public OpenZFSFileSystemConfiguration withDailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime) {
        this.setDailyAutomaticBackupStartTime(dailyAutomaticBackupStartTime);
        return this;
    }

    public void setDeploymentType(String deploymentType) {
        this.deploymentType = deploymentType;
    }

    public String getDeploymentType() {
        return this.deploymentType;
    }

    public OpenZFSFileSystemConfiguration withDeploymentType(String deploymentType) {
        this.setDeploymentType(deploymentType);
        return this;
    }

    public OpenZFSFileSystemConfiguration withDeploymentType(OpenZFSDeploymentType deploymentType) {
        this.deploymentType = deploymentType.toString();
        return this;
    }

    public void setThroughputCapacity(Integer throughputCapacity) {
        this.throughputCapacity = throughputCapacity;
    }

    public Integer getThroughputCapacity() {
        return this.throughputCapacity;
    }

    public OpenZFSFileSystemConfiguration withThroughputCapacity(Integer throughputCapacity) {
        this.setThroughputCapacity(throughputCapacity);
        return this;
    }

    public void setWeeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
        this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
    }

    public String getWeeklyMaintenanceStartTime() {
        return this.weeklyMaintenanceStartTime;
    }

    public OpenZFSFileSystemConfiguration withWeeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
        this.setWeeklyMaintenanceStartTime(weeklyMaintenanceStartTime);
        return this;
    }

    public void setDiskIopsConfiguration(DiskIopsConfiguration diskIopsConfiguration) {
        this.diskIopsConfiguration = diskIopsConfiguration;
    }

    public DiskIopsConfiguration getDiskIopsConfiguration() {
        return this.diskIopsConfiguration;
    }

    public OpenZFSFileSystemConfiguration withDiskIopsConfiguration(DiskIopsConfiguration diskIopsConfiguration) {
        this.setDiskIopsConfiguration(diskIopsConfiguration);
        return this;
    }

    public void setRootVolumeId(String rootVolumeId) {
        this.rootVolumeId = rootVolumeId;
    }

    public String getRootVolumeId() {
        return this.rootVolumeId;
    }

    public OpenZFSFileSystemConfiguration withRootVolumeId(String rootVolumeId) {
        this.setRootVolumeId(rootVolumeId);
        return this;
    }

    public void setPreferredSubnetId(String preferredSubnetId) {
        this.preferredSubnetId = preferredSubnetId;
    }

    public String getPreferredSubnetId() {
        return this.preferredSubnetId;
    }

    public OpenZFSFileSystemConfiguration withPreferredSubnetId(String preferredSubnetId) {
        this.setPreferredSubnetId(preferredSubnetId);
        return this;
    }

    public void setEndpointIpAddressRange(String endpointIpAddressRange) {
        this.endpointIpAddressRange = endpointIpAddressRange;
    }

    public String getEndpointIpAddressRange() {
        return this.endpointIpAddressRange;
    }

    public OpenZFSFileSystemConfiguration withEndpointIpAddressRange(String endpointIpAddressRange) {
        this.setEndpointIpAddressRange(endpointIpAddressRange);
        return this;
    }

    public List<String> getRouteTableIds() {
        return this.routeTableIds;
    }

    public void setRouteTableIds(Collection<String> routeTableIds) {
        if (routeTableIds == null) {
            this.routeTableIds = null;
            return;
        }
        this.routeTableIds = new ArrayList<String>(routeTableIds);
    }

    public OpenZFSFileSystemConfiguration withRouteTableIds(String ... routeTableIds) {
        if (this.routeTableIds == null) {
            this.setRouteTableIds(new ArrayList<String>(routeTableIds.length));
        }
        for (String ele : routeTableIds) {
            this.routeTableIds.add(ele);
        }
        return this;
    }

    public OpenZFSFileSystemConfiguration withRouteTableIds(Collection<String> routeTableIds) {
        this.setRouteTableIds(routeTableIds);
        return this;
    }

    public void setEndpointIpAddress(String endpointIpAddress) {
        this.endpointIpAddress = endpointIpAddress;
    }

    public String getEndpointIpAddress() {
        return this.endpointIpAddress;
    }

    public OpenZFSFileSystemConfiguration withEndpointIpAddress(String endpointIpAddress) {
        this.setEndpointIpAddress(endpointIpAddress);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAutomaticBackupRetentionDays() != null) {
            sb.append("AutomaticBackupRetentionDays: ").append(this.getAutomaticBackupRetentionDays()).append(",");
        }
        if (this.getCopyTagsToBackups() != null) {
            sb.append("CopyTagsToBackups: ").append(this.getCopyTagsToBackups()).append(",");
        }
        if (this.getCopyTagsToVolumes() != null) {
            sb.append("CopyTagsToVolumes: ").append(this.getCopyTagsToVolumes()).append(",");
        }
        if (this.getDailyAutomaticBackupStartTime() != null) {
            sb.append("DailyAutomaticBackupStartTime: ").append(this.getDailyAutomaticBackupStartTime()).append(",");
        }
        if (this.getDeploymentType() != null) {
            sb.append("DeploymentType: ").append(this.getDeploymentType()).append(",");
        }
        if (this.getThroughputCapacity() != null) {
            sb.append("ThroughputCapacity: ").append(this.getThroughputCapacity()).append(",");
        }
        if (this.getWeeklyMaintenanceStartTime() != null) {
            sb.append("WeeklyMaintenanceStartTime: ").append(this.getWeeklyMaintenanceStartTime()).append(",");
        }
        if (this.getDiskIopsConfiguration() != null) {
            sb.append("DiskIopsConfiguration: ").append(this.getDiskIopsConfiguration()).append(",");
        }
        if (this.getRootVolumeId() != null) {
            sb.append("RootVolumeId: ").append(this.getRootVolumeId()).append(",");
        }
        if (this.getPreferredSubnetId() != null) {
            sb.append("PreferredSubnetId: ").append(this.getPreferredSubnetId()).append(",");
        }
        if (this.getEndpointIpAddressRange() != null) {
            sb.append("EndpointIpAddressRange: ").append(this.getEndpointIpAddressRange()).append(",");
        }
        if (this.getRouteTableIds() != null) {
            sb.append("RouteTableIds: ").append(this.getRouteTableIds()).append(",");
        }
        if (this.getEndpointIpAddress() != null) {
            sb.append("EndpointIpAddress: ").append(this.getEndpointIpAddress());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenZFSFileSystemConfiguration)) {
            return false;
        }
        OpenZFSFileSystemConfiguration other = (OpenZFSFileSystemConfiguration)obj;
        if (other.getAutomaticBackupRetentionDays() == null ^ this.getAutomaticBackupRetentionDays() == null) {
            return false;
        }
        if (other.getAutomaticBackupRetentionDays() != null && !other.getAutomaticBackupRetentionDays().equals(this.getAutomaticBackupRetentionDays())) {
            return false;
        }
        if (other.getCopyTagsToBackups() == null ^ this.getCopyTagsToBackups() == null) {
            return false;
        }
        if (other.getCopyTagsToBackups() != null && !other.getCopyTagsToBackups().equals(this.getCopyTagsToBackups())) {
            return false;
        }
        if (other.getCopyTagsToVolumes() == null ^ this.getCopyTagsToVolumes() == null) {
            return false;
        }
        if (other.getCopyTagsToVolumes() != null && !other.getCopyTagsToVolumes().equals(this.getCopyTagsToVolumes())) {
            return false;
        }
        if (other.getDailyAutomaticBackupStartTime() == null ^ this.getDailyAutomaticBackupStartTime() == null) {
            return false;
        }
        if (other.getDailyAutomaticBackupStartTime() != null && !other.getDailyAutomaticBackupStartTime().equals(this.getDailyAutomaticBackupStartTime())) {
            return false;
        }
        if (other.getDeploymentType() == null ^ this.getDeploymentType() == null) {
            return false;
        }
        if (other.getDeploymentType() != null && !other.getDeploymentType().equals(this.getDeploymentType())) {
            return false;
        }
        if (other.getThroughputCapacity() == null ^ this.getThroughputCapacity() == null) {
            return false;
        }
        if (other.getThroughputCapacity() != null && !other.getThroughputCapacity().equals(this.getThroughputCapacity())) {
            return false;
        }
        if (other.getWeeklyMaintenanceStartTime() == null ^ this.getWeeklyMaintenanceStartTime() == null) {
            return false;
        }
        if (other.getWeeklyMaintenanceStartTime() != null && !other.getWeeklyMaintenanceStartTime().equals(this.getWeeklyMaintenanceStartTime())) {
            return false;
        }
        if (other.getDiskIopsConfiguration() == null ^ this.getDiskIopsConfiguration() == null) {
            return false;
        }
        if (other.getDiskIopsConfiguration() != null && !other.getDiskIopsConfiguration().equals(this.getDiskIopsConfiguration())) {
            return false;
        }
        if (other.getRootVolumeId() == null ^ this.getRootVolumeId() == null) {
            return false;
        }
        if (other.getRootVolumeId() != null && !other.getRootVolumeId().equals(this.getRootVolumeId())) {
            return false;
        }
        if (other.getPreferredSubnetId() == null ^ this.getPreferredSubnetId() == null) {
            return false;
        }
        if (other.getPreferredSubnetId() != null && !other.getPreferredSubnetId().equals(this.getPreferredSubnetId())) {
            return false;
        }
        if (other.getEndpointIpAddressRange() == null ^ this.getEndpointIpAddressRange() == null) {
            return false;
        }
        if (other.getEndpointIpAddressRange() != null && !other.getEndpointIpAddressRange().equals(this.getEndpointIpAddressRange())) {
            return false;
        }
        if (other.getRouteTableIds() == null ^ this.getRouteTableIds() == null) {
            return false;
        }
        if (other.getRouteTableIds() != null && !other.getRouteTableIds().equals(this.getRouteTableIds())) {
            return false;
        }
        if (other.getEndpointIpAddress() == null ^ this.getEndpointIpAddress() == null) {
            return false;
        }
        return other.getEndpointIpAddress() == null || other.getEndpointIpAddress().equals(this.getEndpointIpAddress());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAutomaticBackupRetentionDays() == null ? 0 : this.getAutomaticBackupRetentionDays().hashCode());
        hashCode = 31 * hashCode + (this.getCopyTagsToBackups() == null ? 0 : this.getCopyTagsToBackups().hashCode());
        hashCode = 31 * hashCode + (this.getCopyTagsToVolumes() == null ? 0 : this.getCopyTagsToVolumes().hashCode());
        hashCode = 31 * hashCode + (this.getDailyAutomaticBackupStartTime() == null ? 0 : this.getDailyAutomaticBackupStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getDeploymentType() == null ? 0 : this.getDeploymentType().hashCode());
        hashCode = 31 * hashCode + (this.getThroughputCapacity() == null ? 0 : this.getThroughputCapacity().hashCode());
        hashCode = 31 * hashCode + (this.getWeeklyMaintenanceStartTime() == null ? 0 : this.getWeeklyMaintenanceStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getDiskIopsConfiguration() == null ? 0 : this.getDiskIopsConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getRootVolumeId() == null ? 0 : this.getRootVolumeId().hashCode());
        hashCode = 31 * hashCode + (this.getPreferredSubnetId() == null ? 0 : this.getPreferredSubnetId().hashCode());
        hashCode = 31 * hashCode + (this.getEndpointIpAddressRange() == null ? 0 : this.getEndpointIpAddressRange().hashCode());
        hashCode = 31 * hashCode + (this.getRouteTableIds() == null ? 0 : this.getRouteTableIds().hashCode());
        hashCode = 31 * hashCode + (this.getEndpointIpAddress() == null ? 0 : this.getEndpointIpAddress().hashCode());
        return hashCode;
    }

    public OpenZFSFileSystemConfiguration clone() {
        try {
            return (OpenZFSFileSystemConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OpenZFSFileSystemConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

