/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fsx.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.fsx.model.transform.FileSystemEndpointMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FileSystemEndpoint
implements Serializable,
Cloneable,
StructuredPojo {
    private String dNSName;
    private List<String> ipAddresses;

    public void setDNSName(String dNSName) {
        this.dNSName = dNSName;
    }

    public String getDNSName() {
        return this.dNSName;
    }

    public FileSystemEndpoint withDNSName(String dNSName) {
        this.setDNSName(dNSName);
        return this;
    }

    public List<String> getIpAddresses() {
        return this.ipAddresses;
    }

    public void setIpAddresses(Collection<String> ipAddresses) {
        if (ipAddresses == null) {
            this.ipAddresses = null;
            return;
        }
        this.ipAddresses = new ArrayList<String>(ipAddresses);
    }

    public FileSystemEndpoint withIpAddresses(String ... ipAddresses) {
        if (this.ipAddresses == null) {
            this.setIpAddresses(new ArrayList<String>(ipAddresses.length));
        }
        for (String ele : ipAddresses) {
            this.ipAddresses.add(ele);
        }
        return this;
    }

    public FileSystemEndpoint withIpAddresses(Collection<String> ipAddresses) {
        this.setIpAddresses(ipAddresses);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDNSName() != null) {
            sb.append("DNSName: ").append(this.getDNSName()).append(",");
        }
        if (this.getIpAddresses() != null) {
            sb.append("IpAddresses: ").append(this.getIpAddresses());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileSystemEndpoint)) {
            return false;
        }
        FileSystemEndpoint other = (FileSystemEndpoint)obj;
        if (other.getDNSName() == null ^ this.getDNSName() == null) {
            return false;
        }
        if (other.getDNSName() != null && !other.getDNSName().equals(this.getDNSName())) {
            return false;
        }
        if (other.getIpAddresses() == null ^ this.getIpAddresses() == null) {
            return false;
        }
        return other.getIpAddresses() == null || other.getIpAddresses().equals(this.getIpAddresses());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDNSName() == null ? 0 : this.getDNSName().hashCode());
        hashCode = 31 * hashCode + (this.getIpAddresses() == null ? 0 : this.getIpAddresses().hashCode());
        return hashCode;
    }

    public FileSystemEndpoint clone() {
        try {
            return (FileSystemEndpoint)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FileSystemEndpointMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

