/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.fsx.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * <p>
 * The request object for <code>DeleteFileSystem</code> operation.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/DeleteFileSystem" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DeleteFileSystemRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The ID of the file system that you want to delete.
     * </p>
     */
    private String fileSystemId;
    /**
     * <p>
     * A string of up to 63 ASCII characters that Amazon FSx uses to ensure idempotent deletion. This token is
     * automatically filled on your behalf when using the Command Line Interface (CLI) or an Amazon Web Services SDK.
     * </p>
     */
    private String clientRequestToken;

    private DeleteFileSystemWindowsConfiguration windowsConfiguration;

    private DeleteFileSystemLustreConfiguration lustreConfiguration;
    /**
     * <p>
     * The configuration object for the OpenZFS file system used in the <code>DeleteFileSystem</code> operation.
     * </p>
     */
    private DeleteFileSystemOpenZFSConfiguration openZFSConfiguration;

    /**
     * <p>
     * The ID of the file system that you want to delete.
     * </p>
     * 
     * @param fileSystemId
     *        The ID of the file system that you want to delete.
     */

    public void setFileSystemId(String fileSystemId) {
        this.fileSystemId = fileSystemId;
    }

    /**
     * <p>
     * The ID of the file system that you want to delete.
     * </p>
     * 
     * @return The ID of the file system that you want to delete.
     */

    public String getFileSystemId() {
        return this.fileSystemId;
    }

    /**
     * <p>
     * The ID of the file system that you want to delete.
     * </p>
     * 
     * @param fileSystemId
     *        The ID of the file system that you want to delete.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DeleteFileSystemRequest withFileSystemId(String fileSystemId) {
        setFileSystemId(fileSystemId);
        return this;
    }

    /**
     * <p>
     * A string of up to 63 ASCII characters that Amazon FSx uses to ensure idempotent deletion. This token is
     * automatically filled on your behalf when using the Command Line Interface (CLI) or an Amazon Web Services SDK.
     * </p>
     * 
     * @param clientRequestToken
     *        A string of up to 63 ASCII characters that Amazon FSx uses to ensure idempotent deletion. This token is
     *        automatically filled on your behalf when using the Command Line Interface (CLI) or an Amazon Web Services
     *        SDK.
     */

    public void setClientRequestToken(String clientRequestToken) {
        this.clientRequestToken = clientRequestToken;
    }

    /**
     * <p>
     * A string of up to 63 ASCII characters that Amazon FSx uses to ensure idempotent deletion. This token is
     * automatically filled on your behalf when using the Command Line Interface (CLI) or an Amazon Web Services SDK.
     * </p>
     * 
     * @return A string of up to 63 ASCII characters that Amazon FSx uses to ensure idempotent deletion. This token is
     *         automatically filled on your behalf when using the Command Line Interface (CLI) or an Amazon Web Services
     *         SDK.
     */

    public String getClientRequestToken() {
        return this.clientRequestToken;
    }

    /**
     * <p>
     * A string of up to 63 ASCII characters that Amazon FSx uses to ensure idempotent deletion. This token is
     * automatically filled on your behalf when using the Command Line Interface (CLI) or an Amazon Web Services SDK.
     * </p>
     * 
     * @param clientRequestToken
     *        A string of up to 63 ASCII characters that Amazon FSx uses to ensure idempotent deletion. This token is
     *        automatically filled on your behalf when using the Command Line Interface (CLI) or an Amazon Web Services
     *        SDK.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DeleteFileSystemRequest withClientRequestToken(String clientRequestToken) {
        setClientRequestToken(clientRequestToken);
        return this;
    }

    /**
     * @param windowsConfiguration
     */

    public void setWindowsConfiguration(DeleteFileSystemWindowsConfiguration windowsConfiguration) {
        this.windowsConfiguration = windowsConfiguration;
    }

    /**
     * @return
     */

    public DeleteFileSystemWindowsConfiguration getWindowsConfiguration() {
        return this.windowsConfiguration;
    }

    /**
     * @param windowsConfiguration
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DeleteFileSystemRequest withWindowsConfiguration(DeleteFileSystemWindowsConfiguration windowsConfiguration) {
        setWindowsConfiguration(windowsConfiguration);
        return this;
    }

    /**
     * @param lustreConfiguration
     */

    public void setLustreConfiguration(DeleteFileSystemLustreConfiguration lustreConfiguration) {
        this.lustreConfiguration = lustreConfiguration;
    }

    /**
     * @return
     */

    public DeleteFileSystemLustreConfiguration getLustreConfiguration() {
        return this.lustreConfiguration;
    }

    /**
     * @param lustreConfiguration
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DeleteFileSystemRequest withLustreConfiguration(DeleteFileSystemLustreConfiguration lustreConfiguration) {
        setLustreConfiguration(lustreConfiguration);
        return this;
    }

    /**
     * <p>
     * The configuration object for the OpenZFS file system used in the <code>DeleteFileSystem</code> operation.
     * </p>
     * 
     * @param openZFSConfiguration
     *        The configuration object for the OpenZFS file system used in the <code>DeleteFileSystem</code> operation.
     */

    public void setOpenZFSConfiguration(DeleteFileSystemOpenZFSConfiguration openZFSConfiguration) {
        this.openZFSConfiguration = openZFSConfiguration;
    }

    /**
     * <p>
     * The configuration object for the OpenZFS file system used in the <code>DeleteFileSystem</code> operation.
     * </p>
     * 
     * @return The configuration object for the OpenZFS file system used in the <code>DeleteFileSystem</code> operation.
     */

    public DeleteFileSystemOpenZFSConfiguration getOpenZFSConfiguration() {
        return this.openZFSConfiguration;
    }

    /**
     * <p>
     * The configuration object for the OpenZFS file system used in the <code>DeleteFileSystem</code> operation.
     * </p>
     * 
     * @param openZFSConfiguration
     *        The configuration object for the OpenZFS file system used in the <code>DeleteFileSystem</code> operation.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DeleteFileSystemRequest withOpenZFSConfiguration(DeleteFileSystemOpenZFSConfiguration openZFSConfiguration) {
        setOpenZFSConfiguration(openZFSConfiguration);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getFileSystemId() != null)
            sb.append("FileSystemId: ").append(getFileSystemId()).append(",");
        if (getClientRequestToken() != null)
            sb.append("ClientRequestToken: ").append(getClientRequestToken()).append(",");
        if (getWindowsConfiguration() != null)
            sb.append("WindowsConfiguration: ").append(getWindowsConfiguration()).append(",");
        if (getLustreConfiguration() != null)
            sb.append("LustreConfiguration: ").append(getLustreConfiguration()).append(",");
        if (getOpenZFSConfiguration() != null)
            sb.append("OpenZFSConfiguration: ").append(getOpenZFSConfiguration());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DeleteFileSystemRequest == false)
            return false;
        DeleteFileSystemRequest other = (DeleteFileSystemRequest) obj;
        if (other.getFileSystemId() == null ^ this.getFileSystemId() == null)
            return false;
        if (other.getFileSystemId() != null && other.getFileSystemId().equals(this.getFileSystemId()) == false)
            return false;
        if (other.getClientRequestToken() == null ^ this.getClientRequestToken() == null)
            return false;
        if (other.getClientRequestToken() != null && other.getClientRequestToken().equals(this.getClientRequestToken()) == false)
            return false;
        if (other.getWindowsConfiguration() == null ^ this.getWindowsConfiguration() == null)
            return false;
        if (other.getWindowsConfiguration() != null && other.getWindowsConfiguration().equals(this.getWindowsConfiguration()) == false)
            return false;
        if (other.getLustreConfiguration() == null ^ this.getLustreConfiguration() == null)
            return false;
        if (other.getLustreConfiguration() != null && other.getLustreConfiguration().equals(this.getLustreConfiguration()) == false)
            return false;
        if (other.getOpenZFSConfiguration() == null ^ this.getOpenZFSConfiguration() == null)
            return false;
        if (other.getOpenZFSConfiguration() != null && other.getOpenZFSConfiguration().equals(this.getOpenZFSConfiguration()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getFileSystemId() == null) ? 0 : getFileSystemId().hashCode());
        hashCode = prime * hashCode + ((getClientRequestToken() == null) ? 0 : getClientRequestToken().hashCode());
        hashCode = prime * hashCode + ((getWindowsConfiguration() == null) ? 0 : getWindowsConfiguration().hashCode());
        hashCode = prime * hashCode + ((getLustreConfiguration() == null) ? 0 : getLustreConfiguration().hashCode());
        hashCode = prime * hashCode + ((getOpenZFSConfiguration() == null) ? 0 : getOpenZFSConfiguration().hashCode());
        return hashCode;
    }

    @Override
    public DeleteFileSystemRequest clone() {
        return (DeleteFileSystemRequest) super.clone();
    }

}
