/*
 * Copyright 2010-2016 Amazon.com, Inc. or its affiliates. All Rights
 * Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 *  http://aws.amazon.com/apache2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

package com.amazonaws.services.gamelift.model;

import java.io.Serializable;
import com.amazonaws.AmazonWebServiceRequest;

/**
 * <p>
 * Represents the input for a request action.
 * </p>
 */
public class CreateFleetRequest extends AmazonWebServiceRequest implements
        Serializable, Cloneable {

    /**
     * <p>
     * Descriptive label associated with this fleet. Fleet names do not need to
     * be unique.
     * </p>
     */
    private String name;
    /**
     * <p>
     * Human-readable description of the fleet.
     * </p>
     */
    private String description;
    /**
     * <p>
     * Unique identifier for the build you want the new fleet to use.
     * </p>
     */
    private String buildId;
    /**
     * <p>
     * Path to the launch executable for the game server. a game server is built
     * into a C:\game drive. This value must be expressed as
     * "C:\game\[launchpath]". Example: If, when built, your game server files
     * are in a folder called "MyGame", your log path should be
     * "C:\game\MyGame\server.exe".
     * </p>
     */
    private String serverLaunchPath;
    /**
     * <p>
     * Parameters required to launch your game server. These parameters should
     * be expressed as a string of command-line parameters. Example:
     * "+sv_port 33435 +start_lobby".
     * </p>
     */
    private String serverLaunchParameters;
    /**
     * <p>
     * Path to game-session log files generated by your game server. Once a game
     * session terminates, GameLift captures and stores the logs on S3. Use the
     * Amazon GameLift console to access the stored logs.
     * </p>
     */
    private java.util.List<String> logPaths;
    /**
     * <p>
     * Type of EC2 instances used in the fleet. EC2 instance types define the
     * CPU, memory, storage, networking capacity, etc., of the hosts used. The
     * EC2 instance types supported by GameLift are listed below. See the lta
     * href="https://aws.amazon.com/ec2/instance-types/"gtEC2
     * documentationlt/agt for detailed descriptions of each instance type.
     * </p>
     */
    private String eC2InstanceType;
    /**
     * <p>
     * Access limits for incoming traffic. Setting these values limits game
     * server access to incoming traffic using specified IP ranges and port
     * numbers. Some ports in a range may be restricted. You can provide one or
     * more sets of permissions for the fleet.
     * </p>
     */
    private java.util.List<IpPermission> eC2InboundPermissions;

    /**
     * <p>
     * Descriptive label associated with this fleet. Fleet names do not need to
     * be unique.
     * </p>
     * 
     * @param name
     *        Descriptive label associated with this fleet. Fleet names do not
     *        need to be unique.
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * <p>
     * Descriptive label associated with this fleet. Fleet names do not need to
     * be unique.
     * </p>
     * 
     * @return Descriptive label associated with this fleet. Fleet names do not
     *         need to be unique.
     */
    public String getName() {
        return this.name;
    }

    /**
     * <p>
     * Descriptive label associated with this fleet. Fleet names do not need to
     * be unique.
     * </p>
     * 
     * @param name
     *        Descriptive label associated with this fleet. Fleet names do not
     *        need to be unique.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     */
    public CreateFleetRequest withName(String name) {
        setName(name);
        return this;
    }

    /**
     * <p>
     * Human-readable description of the fleet.
     * </p>
     * 
     * @param description
     *        Human-readable description of the fleet.
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * <p>
     * Human-readable description of the fleet.
     * </p>
     * 
     * @return Human-readable description of the fleet.
     */
    public String getDescription() {
        return this.description;
    }

    /**
     * <p>
     * Human-readable description of the fleet.
     * </p>
     * 
     * @param description
     *        Human-readable description of the fleet.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     */
    public CreateFleetRequest withDescription(String description) {
        setDescription(description);
        return this;
    }

    /**
     * <p>
     * Unique identifier for the build you want the new fleet to use.
     * </p>
     * 
     * @param buildId
     *        Unique identifier for the build you want the new fleet to use.
     */
    public void setBuildId(String buildId) {
        this.buildId = buildId;
    }

    /**
     * <p>
     * Unique identifier for the build you want the new fleet to use.
     * </p>
     * 
     * @return Unique identifier for the build you want the new fleet to use.
     */
    public String getBuildId() {
        return this.buildId;
    }

    /**
     * <p>
     * Unique identifier for the build you want the new fleet to use.
     * </p>
     * 
     * @param buildId
     *        Unique identifier for the build you want the new fleet to use.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     */
    public CreateFleetRequest withBuildId(String buildId) {
        setBuildId(buildId);
        return this;
    }

    /**
     * <p>
     * Path to the launch executable for the game server. a game server is built
     * into a C:\game drive. This value must be expressed as
     * "C:\game\[launchpath]". Example: If, when built, your game server files
     * are in a folder called "MyGame", your log path should be
     * "C:\game\MyGame\server.exe".
     * </p>
     * 
     * @param serverLaunchPath
     *        Path to the launch executable for the game server. a game server
     *        is built into a C:\game drive. This value must be expressed as
     *        "C:\game\[launchpath]". Example: If, when built, your game server
     *        files are in a folder called "MyGame", your log path should be
     *        "C:\game\MyGame\server.exe".
     */
    public void setServerLaunchPath(String serverLaunchPath) {
        this.serverLaunchPath = serverLaunchPath;
    }

    /**
     * <p>
     * Path to the launch executable for the game server. a game server is built
     * into a C:\game drive. This value must be expressed as
     * "C:\game\[launchpath]". Example: If, when built, your game server files
     * are in a folder called "MyGame", your log path should be
     * "C:\game\MyGame\server.exe".
     * </p>
     * 
     * @return Path to the launch executable for the game server. a game server
     *         is built into a C:\game drive. This value must be expressed as
     *         "C:\game\[launchpath]". Example: If, when built, your game server
     *         files are in a folder called "MyGame", your log path should be
     *         "C:\game\MyGame\server.exe".
     */
    public String getServerLaunchPath() {
        return this.serverLaunchPath;
    }

    /**
     * <p>
     * Path to the launch executable for the game server. a game server is built
     * into a C:\game drive. This value must be expressed as
     * "C:\game\[launchpath]". Example: If, when built, your game server files
     * are in a folder called "MyGame", your log path should be
     * "C:\game\MyGame\server.exe".
     * </p>
     * 
     * @param serverLaunchPath
     *        Path to the launch executable for the game server. a game server
     *        is built into a C:\game drive. This value must be expressed as
     *        "C:\game\[launchpath]". Example: If, when built, your game server
     *        files are in a folder called "MyGame", your log path should be
     *        "C:\game\MyGame\server.exe".
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     */
    public CreateFleetRequest withServerLaunchPath(String serverLaunchPath) {
        setServerLaunchPath(serverLaunchPath);
        return this;
    }

    /**
     * <p>
     * Parameters required to launch your game server. These parameters should
     * be expressed as a string of command-line parameters. Example:
     * "+sv_port 33435 +start_lobby".
     * </p>
     * 
     * @param serverLaunchParameters
     *        Parameters required to launch your game server. These parameters
     *        should be expressed as a string of command-line parameters.
     *        Example: "+sv_port 33435 +start_lobby".
     */
    public void setServerLaunchParameters(String serverLaunchParameters) {
        this.serverLaunchParameters = serverLaunchParameters;
    }

    /**
     * <p>
     * Parameters required to launch your game server. These parameters should
     * be expressed as a string of command-line parameters. Example:
     * "+sv_port 33435 +start_lobby".
     * </p>
     * 
     * @return Parameters required to launch your game server. These parameters
     *         should be expressed as a string of command-line parameters.
     *         Example: "+sv_port 33435 +start_lobby".
     */
    public String getServerLaunchParameters() {
        return this.serverLaunchParameters;
    }

    /**
     * <p>
     * Parameters required to launch your game server. These parameters should
     * be expressed as a string of command-line parameters. Example:
     * "+sv_port 33435 +start_lobby".
     * </p>
     * 
     * @param serverLaunchParameters
     *        Parameters required to launch your game server. These parameters
     *        should be expressed as a string of command-line parameters.
     *        Example: "+sv_port 33435 +start_lobby".
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     */
    public CreateFleetRequest withServerLaunchParameters(
            String serverLaunchParameters) {
        setServerLaunchParameters(serverLaunchParameters);
        return this;
    }

    /**
     * <p>
     * Path to game-session log files generated by your game server. Once a game
     * session terminates, GameLift captures and stores the logs on S3. Use the
     * Amazon GameLift console to access the stored logs.
     * </p>
     * 
     * @return Path to game-session log files generated by your game server.
     *         Once a game session terminates, GameLift captures and stores the
     *         logs on S3. Use the Amazon GameLift console to access the stored
     *         logs.
     */
    public java.util.List<String> getLogPaths() {
        return logPaths;
    }

    /**
     * <p>
     * Path to game-session log files generated by your game server. Once a game
     * session terminates, GameLift captures and stores the logs on S3. Use the
     * Amazon GameLift console to access the stored logs.
     * </p>
     * 
     * @param logPaths
     *        Path to game-session log files generated by your game server. Once
     *        a game session terminates, GameLift captures and stores the logs
     *        on S3. Use the Amazon GameLift console to access the stored logs.
     */
    public void setLogPaths(java.util.Collection<String> logPaths) {
        if (logPaths == null) {
            this.logPaths = null;
            return;
        }

        this.logPaths = new java.util.ArrayList<String>(logPaths);
    }

    /**
     * <p>
     * Path to game-session log files generated by your game server. Once a game
     * session terminates, GameLift captures and stores the logs on S3. Use the
     * Amazon GameLift console to access the stored logs.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if
     * any). Use {@link #setLogPaths(java.util.Collection)} or
     * {@link #withLogPaths(java.util.Collection)} if you want to override the
     * existing values.
     * </p>
     * 
     * @param logPaths
     *        Path to game-session log files generated by your game server. Once
     *        a game session terminates, GameLift captures and stores the logs
     *        on S3. Use the Amazon GameLift console to access the stored logs.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     */
    public CreateFleetRequest withLogPaths(String... logPaths) {
        if (this.logPaths == null) {
            setLogPaths(new java.util.ArrayList<String>(logPaths.length));
        }
        for (String ele : logPaths) {
            this.logPaths.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * Path to game-session log files generated by your game server. Once a game
     * session terminates, GameLift captures and stores the logs on S3. Use the
     * Amazon GameLift console to access the stored logs.
     * </p>
     * 
     * @param logPaths
     *        Path to game-session log files generated by your game server. Once
     *        a game session terminates, GameLift captures and stores the logs
     *        on S3. Use the Amazon GameLift console to access the stored logs.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     */
    public CreateFleetRequest withLogPaths(java.util.Collection<String> logPaths) {
        setLogPaths(logPaths);
        return this;
    }

    /**
     * <p>
     * Type of EC2 instances used in the fleet. EC2 instance types define the
     * CPU, memory, storage, networking capacity, etc., of the hosts used. The
     * EC2 instance types supported by GameLift are listed below. See the lta
     * href="https://aws.amazon.com/ec2/instance-types/"gtEC2
     * documentationlt/agt for detailed descriptions of each instance type.
     * </p>
     * 
     * @param eC2InstanceType
     *        Type of EC2 instances used in the fleet. EC2 instance types define
     *        the CPU, memory, storage, networking capacity, etc., of the hosts
     *        used. The EC2 instance types supported by GameLift are listed
     *        below. See the lta
     *        href="https://aws.amazon.com/ec2/instance-types/"gtEC2
     *        documentationlt/agt for detailed descriptions of each instance
     *        type.
     * @see EC2InstanceType
     */
    public void setEC2InstanceType(String eC2InstanceType) {
        this.eC2InstanceType = eC2InstanceType;
    }

    /**
     * <p>
     * Type of EC2 instances used in the fleet. EC2 instance types define the
     * CPU, memory, storage, networking capacity, etc., of the hosts used. The
     * EC2 instance types supported by GameLift are listed below. See the lta
     * href="https://aws.amazon.com/ec2/instance-types/"gtEC2
     * documentationlt/agt for detailed descriptions of each instance type.
     * </p>
     * 
     * @return Type of EC2 instances used in the fleet. EC2 instance types
     *         define the CPU, memory, storage, networking capacity, etc., of
     *         the hosts used. The EC2 instance types supported by GameLift are
     *         listed below. See the lta
     *         href="https://aws.amazon.com/ec2/instance-types/"gtEC2
     *         documentationlt/agt for detailed descriptions of each instance
     *         type.
     * @see EC2InstanceType
     */
    public String getEC2InstanceType() {
        return this.eC2InstanceType;
    }

    /**
     * <p>
     * Type of EC2 instances used in the fleet. EC2 instance types define the
     * CPU, memory, storage, networking capacity, etc., of the hosts used. The
     * EC2 instance types supported by GameLift are listed below. See the lta
     * href="https://aws.amazon.com/ec2/instance-types/"gtEC2
     * documentationlt/agt for detailed descriptions of each instance type.
     * </p>
     * 
     * @param eC2InstanceType
     *        Type of EC2 instances used in the fleet. EC2 instance types define
     *        the CPU, memory, storage, networking capacity, etc., of the hosts
     *        used. The EC2 instance types supported by GameLift are listed
     *        below. See the lta
     *        href="https://aws.amazon.com/ec2/instance-types/"gtEC2
     *        documentationlt/agt for detailed descriptions of each instance
     *        type.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     * @see EC2InstanceType
     */
    public CreateFleetRequest withEC2InstanceType(String eC2InstanceType) {
        setEC2InstanceType(eC2InstanceType);
        return this;
    }

    /**
     * <p>
     * Type of EC2 instances used in the fleet. EC2 instance types define the
     * CPU, memory, storage, networking capacity, etc., of the hosts used. The
     * EC2 instance types supported by GameLift are listed below. See the lta
     * href="https://aws.amazon.com/ec2/instance-types/"gtEC2
     * documentationlt/agt for detailed descriptions of each instance type.
     * </p>
     * 
     * @param eC2InstanceType
     *        Type of EC2 instances used in the fleet. EC2 instance types define
     *        the CPU, memory, storage, networking capacity, etc., of the hosts
     *        used. The EC2 instance types supported by GameLift are listed
     *        below. See the lta
     *        href="https://aws.amazon.com/ec2/instance-types/"gtEC2
     *        documentationlt/agt for detailed descriptions of each instance
     *        type.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     * @see EC2InstanceType
     */
    public void setEC2InstanceType(EC2InstanceType eC2InstanceType) {
        this.eC2InstanceType = eC2InstanceType.toString();
    }

    /**
     * <p>
     * Type of EC2 instances used in the fleet. EC2 instance types define the
     * CPU, memory, storage, networking capacity, etc., of the hosts used. The
     * EC2 instance types supported by GameLift are listed below. See the lta
     * href="https://aws.amazon.com/ec2/instance-types/"gtEC2
     * documentationlt/agt for detailed descriptions of each instance type.
     * </p>
     * 
     * @param eC2InstanceType
     *        Type of EC2 instances used in the fleet. EC2 instance types define
     *        the CPU, memory, storage, networking capacity, etc., of the hosts
     *        used. The EC2 instance types supported by GameLift are listed
     *        below. See the lta
     *        href="https://aws.amazon.com/ec2/instance-types/"gtEC2
     *        documentationlt/agt for detailed descriptions of each instance
     *        type.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     * @see EC2InstanceType
     */
    public CreateFleetRequest withEC2InstanceType(
            EC2InstanceType eC2InstanceType) {
        setEC2InstanceType(eC2InstanceType);
        return this;
    }

    /**
     * <p>
     * Access limits for incoming traffic. Setting these values limits game
     * server access to incoming traffic using specified IP ranges and port
     * numbers. Some ports in a range may be restricted. You can provide one or
     * more sets of permissions for the fleet.
     * </p>
     * 
     * @return Access limits for incoming traffic. Setting these values limits
     *         game server access to incoming traffic using specified IP ranges
     *         and port numbers. Some ports in a range may be restricted. You
     *         can provide one or more sets of permissions for the fleet.
     */
    public java.util.List<IpPermission> getEC2InboundPermissions() {
        return eC2InboundPermissions;
    }

    /**
     * <p>
     * Access limits for incoming traffic. Setting these values limits game
     * server access to incoming traffic using specified IP ranges and port
     * numbers. Some ports in a range may be restricted. You can provide one or
     * more sets of permissions for the fleet.
     * </p>
     * 
     * @param eC2InboundPermissions
     *        Access limits for incoming traffic. Setting these values limits
     *        game server access to incoming traffic using specified IP ranges
     *        and port numbers. Some ports in a range may be restricted. You can
     *        provide one or more sets of permissions for the fleet.
     */
    public void setEC2InboundPermissions(
            java.util.Collection<IpPermission> eC2InboundPermissions) {
        if (eC2InboundPermissions == null) {
            this.eC2InboundPermissions = null;
            return;
        }

        this.eC2InboundPermissions = new java.util.ArrayList<IpPermission>(
                eC2InboundPermissions);
    }

    /**
     * <p>
     * Access limits for incoming traffic. Setting these values limits game
     * server access to incoming traffic using specified IP ranges and port
     * numbers. Some ports in a range may be restricted. You can provide one or
     * more sets of permissions for the fleet.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if
     * any). Use {@link #setEC2InboundPermissions(java.util.Collection)} or
     * {@link #withEC2InboundPermissions(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param eC2InboundPermissions
     *        Access limits for incoming traffic. Setting these values limits
     *        game server access to incoming traffic using specified IP ranges
     *        and port numbers. Some ports in a range may be restricted. You can
     *        provide one or more sets of permissions for the fleet.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     */
    public CreateFleetRequest withEC2InboundPermissions(
            IpPermission... eC2InboundPermissions) {
        if (this.eC2InboundPermissions == null) {
            setEC2InboundPermissions(new java.util.ArrayList<IpPermission>(
                    eC2InboundPermissions.length));
        }
        for (IpPermission ele : eC2InboundPermissions) {
            this.eC2InboundPermissions.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * Access limits for incoming traffic. Setting these values limits game
     * server access to incoming traffic using specified IP ranges and port
     * numbers. Some ports in a range may be restricted. You can provide one or
     * more sets of permissions for the fleet.
     * </p>
     * 
     * @param eC2InboundPermissions
     *        Access limits for incoming traffic. Setting these values limits
     *        game server access to incoming traffic using specified IP ranges
     *        and port numbers. Some ports in a range may be restricted. You can
     *        provide one or more sets of permissions for the fleet.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     */
    public CreateFleetRequest withEC2InboundPermissions(
            java.util.Collection<IpPermission> eC2InboundPermissions) {
        setEC2InboundPermissions(eC2InboundPermissions);
        return this;
    }

    /**
     * Returns a string representation of this object; useful for testing and
     * debugging.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getName() != null)
            sb.append("Name: " + getName() + ",");
        if (getDescription() != null)
            sb.append("Description: " + getDescription() + ",");
        if (getBuildId() != null)
            sb.append("BuildId: " + getBuildId() + ",");
        if (getServerLaunchPath() != null)
            sb.append("ServerLaunchPath: " + getServerLaunchPath() + ",");
        if (getServerLaunchParameters() != null)
            sb.append("ServerLaunchParameters: " + getServerLaunchParameters()
                    + ",");
        if (getLogPaths() != null)
            sb.append("LogPaths: " + getLogPaths() + ",");
        if (getEC2InstanceType() != null)
            sb.append("EC2InstanceType: " + getEC2InstanceType() + ",");
        if (getEC2InboundPermissions() != null)
            sb.append("EC2InboundPermissions: " + getEC2InboundPermissions());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CreateFleetRequest == false)
            return false;
        CreateFleetRequest other = (CreateFleetRequest) obj;
        if (other.getName() == null ^ this.getName() == null)
            return false;
        if (other.getName() != null
                && other.getName().equals(this.getName()) == false)
            return false;
        if (other.getDescription() == null ^ this.getDescription() == null)
            return false;
        if (other.getDescription() != null
                && other.getDescription().equals(this.getDescription()) == false)
            return false;
        if (other.getBuildId() == null ^ this.getBuildId() == null)
            return false;
        if (other.getBuildId() != null
                && other.getBuildId().equals(this.getBuildId()) == false)
            return false;
        if (other.getServerLaunchPath() == null
                ^ this.getServerLaunchPath() == null)
            return false;
        if (other.getServerLaunchPath() != null
                && other.getServerLaunchPath().equals(
                        this.getServerLaunchPath()) == false)
            return false;
        if (other.getServerLaunchParameters() == null
                ^ this.getServerLaunchParameters() == null)
            return false;
        if (other.getServerLaunchParameters() != null
                && other.getServerLaunchParameters().equals(
                        this.getServerLaunchParameters()) == false)
            return false;
        if (other.getLogPaths() == null ^ this.getLogPaths() == null)
            return false;
        if (other.getLogPaths() != null
                && other.getLogPaths().equals(this.getLogPaths()) == false)
            return false;
        if (other.getEC2InstanceType() == null
                ^ this.getEC2InstanceType() == null)
            return false;
        if (other.getEC2InstanceType() != null
                && other.getEC2InstanceType().equals(this.getEC2InstanceType()) == false)
            return false;
        if (other.getEC2InboundPermissions() == null
                ^ this.getEC2InboundPermissions() == null)
            return false;
        if (other.getEC2InboundPermissions() != null
                && other.getEC2InboundPermissions().equals(
                        this.getEC2InboundPermissions()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode
                + ((getName() == null) ? 0 : getName().hashCode());
        hashCode = prime
                * hashCode
                + ((getDescription() == null) ? 0 : getDescription().hashCode());
        hashCode = prime * hashCode
                + ((getBuildId() == null) ? 0 : getBuildId().hashCode());
        hashCode = prime
                * hashCode
                + ((getServerLaunchPath() == null) ? 0 : getServerLaunchPath()
                        .hashCode());
        hashCode = prime
                * hashCode
                + ((getServerLaunchParameters() == null) ? 0
                        : getServerLaunchParameters().hashCode());
        hashCode = prime * hashCode
                + ((getLogPaths() == null) ? 0 : getLogPaths().hashCode());
        hashCode = prime
                * hashCode
                + ((getEC2InstanceType() == null) ? 0 : getEC2InstanceType()
                        .hashCode());
        hashCode = prime
                * hashCode
                + ((getEC2InboundPermissions() == null) ? 0
                        : getEC2InboundPermissions().hashCode());
        return hashCode;
    }

    @Override
    public CreateFleetRequest clone() {
        return (CreateFleetRequest) super.clone();
    }
}