/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.JsonErrorResponseHandlerV2;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.gamelift.AmazonGameLift;
import com.amazonaws.services.gamelift.model.ConflictException;
import com.amazonaws.services.gamelift.model.CreateAliasRequest;
import com.amazonaws.services.gamelift.model.CreateAliasResult;
import com.amazonaws.services.gamelift.model.CreateBuildRequest;
import com.amazonaws.services.gamelift.model.CreateBuildResult;
import com.amazonaws.services.gamelift.model.CreateFleetRequest;
import com.amazonaws.services.gamelift.model.CreateFleetResult;
import com.amazonaws.services.gamelift.model.CreateGameSessionRequest;
import com.amazonaws.services.gamelift.model.CreateGameSessionResult;
import com.amazonaws.services.gamelift.model.CreatePlayerSessionRequest;
import com.amazonaws.services.gamelift.model.CreatePlayerSessionResult;
import com.amazonaws.services.gamelift.model.CreatePlayerSessionsRequest;
import com.amazonaws.services.gamelift.model.CreatePlayerSessionsResult;
import com.amazonaws.services.gamelift.model.DeleteAliasRequest;
import com.amazonaws.services.gamelift.model.DeleteBuildRequest;
import com.amazonaws.services.gamelift.model.DeleteFleetRequest;
import com.amazonaws.services.gamelift.model.DeleteScalingPolicyRequest;
import com.amazonaws.services.gamelift.model.DescribeAliasRequest;
import com.amazonaws.services.gamelift.model.DescribeAliasResult;
import com.amazonaws.services.gamelift.model.DescribeBuildRequest;
import com.amazonaws.services.gamelift.model.DescribeBuildResult;
import com.amazonaws.services.gamelift.model.DescribeEC2InstanceLimitsRequest;
import com.amazonaws.services.gamelift.model.DescribeEC2InstanceLimitsResult;
import com.amazonaws.services.gamelift.model.DescribeFleetAttributesRequest;
import com.amazonaws.services.gamelift.model.DescribeFleetAttributesResult;
import com.amazonaws.services.gamelift.model.DescribeFleetCapacityRequest;
import com.amazonaws.services.gamelift.model.DescribeFleetCapacityResult;
import com.amazonaws.services.gamelift.model.DescribeFleetEventsRequest;
import com.amazonaws.services.gamelift.model.DescribeFleetEventsResult;
import com.amazonaws.services.gamelift.model.DescribeFleetPortSettingsRequest;
import com.amazonaws.services.gamelift.model.DescribeFleetPortSettingsResult;
import com.amazonaws.services.gamelift.model.DescribeFleetUtilizationRequest;
import com.amazonaws.services.gamelift.model.DescribeFleetUtilizationResult;
import com.amazonaws.services.gamelift.model.DescribeGameSessionDetailsRequest;
import com.amazonaws.services.gamelift.model.DescribeGameSessionDetailsResult;
import com.amazonaws.services.gamelift.model.DescribeGameSessionsRequest;
import com.amazonaws.services.gamelift.model.DescribeGameSessionsResult;
import com.amazonaws.services.gamelift.model.DescribePlayerSessionsRequest;
import com.amazonaws.services.gamelift.model.DescribePlayerSessionsResult;
import com.amazonaws.services.gamelift.model.DescribeScalingPoliciesRequest;
import com.amazonaws.services.gamelift.model.DescribeScalingPoliciesResult;
import com.amazonaws.services.gamelift.model.FleetCapacityExceededException;
import com.amazonaws.services.gamelift.model.GameSessionFullException;
import com.amazonaws.services.gamelift.model.GetGameSessionLogUrlRequest;
import com.amazonaws.services.gamelift.model.GetGameSessionLogUrlResult;
import com.amazonaws.services.gamelift.model.InternalServiceException;
import com.amazonaws.services.gamelift.model.InvalidFleetStatusException;
import com.amazonaws.services.gamelift.model.InvalidGameSessionStatusException;
import com.amazonaws.services.gamelift.model.InvalidRequestException;
import com.amazonaws.services.gamelift.model.LimitExceededException;
import com.amazonaws.services.gamelift.model.ListAliasesRequest;
import com.amazonaws.services.gamelift.model.ListAliasesResult;
import com.amazonaws.services.gamelift.model.ListBuildsRequest;
import com.amazonaws.services.gamelift.model.ListBuildsResult;
import com.amazonaws.services.gamelift.model.ListFleetsRequest;
import com.amazonaws.services.gamelift.model.ListFleetsResult;
import com.amazonaws.services.gamelift.model.NotFoundException;
import com.amazonaws.services.gamelift.model.PutScalingPolicyRequest;
import com.amazonaws.services.gamelift.model.PutScalingPolicyResult;
import com.amazonaws.services.gamelift.model.RequestUploadCredentialsRequest;
import com.amazonaws.services.gamelift.model.RequestUploadCredentialsResult;
import com.amazonaws.services.gamelift.model.ResolveAliasRequest;
import com.amazonaws.services.gamelift.model.ResolveAliasResult;
import com.amazonaws.services.gamelift.model.TerminalRoutingStrategyException;
import com.amazonaws.services.gamelift.model.UnauthorizedException;
import com.amazonaws.services.gamelift.model.UpdateAliasRequest;
import com.amazonaws.services.gamelift.model.UpdateAliasResult;
import com.amazonaws.services.gamelift.model.UpdateBuildRequest;
import com.amazonaws.services.gamelift.model.UpdateBuildResult;
import com.amazonaws.services.gamelift.model.UpdateFleetAttributesRequest;
import com.amazonaws.services.gamelift.model.UpdateFleetAttributesResult;
import com.amazonaws.services.gamelift.model.UpdateFleetCapacityRequest;
import com.amazonaws.services.gamelift.model.UpdateFleetCapacityResult;
import com.amazonaws.services.gamelift.model.UpdateFleetPortSettingsRequest;
import com.amazonaws.services.gamelift.model.UpdateFleetPortSettingsResult;
import com.amazonaws.services.gamelift.model.UpdateGameSessionRequest;
import com.amazonaws.services.gamelift.model.UpdateGameSessionResult;
import com.amazonaws.services.gamelift.model.transform.CreateAliasRequestMarshaller;
import com.amazonaws.services.gamelift.model.transform.CreateAliasResultJsonUnmarshaller;
import com.amazonaws.services.gamelift.model.transform.CreateBuildRequestMarshaller;
import com.amazonaws.services.gamelift.model.transform.CreateBuildResultJsonUnmarshaller;
import com.amazonaws.services.gamelift.model.transform.CreateFleetRequestMarshaller;
import com.amazonaws.services.gamelift.model.transform.CreateFleetResultJsonUnmarshaller;
import com.amazonaws.services.gamelift.model.transform.CreateGameSessionRequestMarshaller;
import com.amazonaws.services.gamelift.model.transform.CreateGameSessionResultJsonUnmarshaller;
import com.amazonaws.services.gamelift.model.transform.CreatePlayerSessionRequestMarshaller;
import com.amazonaws.services.gamelift.model.transform.CreatePlayerSessionResultJsonUnmarshaller;
import com.amazonaws.services.gamelift.model.transform.CreatePlayerSessionsRequestMarshaller;
import com.amazonaws.services.gamelift.model.transform.CreatePlayerSessionsResultJsonUnmarshaller;
import com.amazonaws.services.gamelift.model.transform.DeleteAliasRequestMarshaller;
import com.amazonaws.services.gamelift.model.transform.DeleteBuildRequestMarshaller;
import com.amazonaws.services.gamelift.model.transform.DeleteFleetRequestMarshaller;
import com.amazonaws.services.gamelift.model.transform.DeleteScalingPolicyRequestMarshaller;
import com.amazonaws.services.gamelift.model.transform.DescribeAliasRequestMarshaller;
import com.amazonaws.services.gamelift.model.transform.DescribeAliasResultJsonUnmarshaller;
import com.amazonaws.services.gamelift.model.transform.DescribeBuildRequestMarshaller;
import com.amazonaws.services.gamelift.model.transform.DescribeBuildResultJsonUnmarshaller;
import com.amazonaws.services.gamelift.model.transform.DescribeEC2InstanceLimitsRequestMarshaller;
import com.amazonaws.services.gamelift.model.transform.DescribeEC2InstanceLimitsResultJsonUnmarshaller;
import com.amazonaws.services.gamelift.model.transform.DescribeFleetAttributesRequestMarshaller;
import com.amazonaws.services.gamelift.model.transform.DescribeFleetAttributesResultJsonUnmarshaller;
import com.amazonaws.services.gamelift.model.transform.DescribeFleetCapacityRequestMarshaller;
import com.amazonaws.services.gamelift.model.transform.DescribeFleetCapacityResultJsonUnmarshaller;
import com.amazonaws.services.gamelift.model.transform.DescribeFleetEventsRequestMarshaller;
import com.amazonaws.services.gamelift.model.transform.DescribeFleetEventsResultJsonUnmarshaller;
import com.amazonaws.services.gamelift.model.transform.DescribeFleetPortSettingsRequestMarshaller;
import com.amazonaws.services.gamelift.model.transform.DescribeFleetPortSettingsResultJsonUnmarshaller;
import com.amazonaws.services.gamelift.model.transform.DescribeFleetUtilizationRequestMarshaller;
import com.amazonaws.services.gamelift.model.transform.DescribeFleetUtilizationResultJsonUnmarshaller;
import com.amazonaws.services.gamelift.model.transform.DescribeGameSessionDetailsRequestMarshaller;
import com.amazonaws.services.gamelift.model.transform.DescribeGameSessionDetailsResultJsonUnmarshaller;
import com.amazonaws.services.gamelift.model.transform.DescribeGameSessionsRequestMarshaller;
import com.amazonaws.services.gamelift.model.transform.DescribeGameSessionsResultJsonUnmarshaller;
import com.amazonaws.services.gamelift.model.transform.DescribePlayerSessionsRequestMarshaller;
import com.amazonaws.services.gamelift.model.transform.DescribePlayerSessionsResultJsonUnmarshaller;
import com.amazonaws.services.gamelift.model.transform.DescribeScalingPoliciesRequestMarshaller;
import com.amazonaws.services.gamelift.model.transform.DescribeScalingPoliciesResultJsonUnmarshaller;
import com.amazonaws.services.gamelift.model.transform.GetGameSessionLogUrlRequestMarshaller;
import com.amazonaws.services.gamelift.model.transform.GetGameSessionLogUrlResultJsonUnmarshaller;
import com.amazonaws.services.gamelift.model.transform.ListAliasesRequestMarshaller;
import com.amazonaws.services.gamelift.model.transform.ListAliasesResultJsonUnmarshaller;
import com.amazonaws.services.gamelift.model.transform.ListBuildsRequestMarshaller;
import com.amazonaws.services.gamelift.model.transform.ListBuildsResultJsonUnmarshaller;
import com.amazonaws.services.gamelift.model.transform.ListFleetsRequestMarshaller;
import com.amazonaws.services.gamelift.model.transform.ListFleetsResultJsonUnmarshaller;
import com.amazonaws.services.gamelift.model.transform.PutScalingPolicyRequestMarshaller;
import com.amazonaws.services.gamelift.model.transform.PutScalingPolicyResultJsonUnmarshaller;
import com.amazonaws.services.gamelift.model.transform.RequestUploadCredentialsRequestMarshaller;
import com.amazonaws.services.gamelift.model.transform.RequestUploadCredentialsResultJsonUnmarshaller;
import com.amazonaws.services.gamelift.model.transform.ResolveAliasRequestMarshaller;
import com.amazonaws.services.gamelift.model.transform.ResolveAliasResultJsonUnmarshaller;
import com.amazonaws.services.gamelift.model.transform.UpdateAliasRequestMarshaller;
import com.amazonaws.services.gamelift.model.transform.UpdateAliasResultJsonUnmarshaller;
import com.amazonaws.services.gamelift.model.transform.UpdateBuildRequestMarshaller;
import com.amazonaws.services.gamelift.model.transform.UpdateBuildResultJsonUnmarshaller;
import com.amazonaws.services.gamelift.model.transform.UpdateFleetAttributesRequestMarshaller;
import com.amazonaws.services.gamelift.model.transform.UpdateFleetAttributesResultJsonUnmarshaller;
import com.amazonaws.services.gamelift.model.transform.UpdateFleetCapacityRequestMarshaller;
import com.amazonaws.services.gamelift.model.transform.UpdateFleetCapacityResultJsonUnmarshaller;
import com.amazonaws.services.gamelift.model.transform.UpdateFleetPortSettingsRequestMarshaller;
import com.amazonaws.services.gamelift.model.transform.UpdateFleetPortSettingsResultJsonUnmarshaller;
import com.amazonaws.services.gamelift.model.transform.UpdateGameSessionRequestMarshaller;
import com.amazonaws.services.gamelift.model.transform.UpdateGameSessionResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshallerV2;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonGameLiftClient
extends AmazonWebServiceClient
implements AmazonGameLift {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonGameLift.class);
    private static final String DEFAULT_SIGNING_NAME = "gamelift";
    private static final String DEFAULT_ENDPOINT_PREFIX = "gamelift";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    protected List<JsonErrorUnmarshallerV2> jsonErrorUnmarshallers = new ArrayList<JsonErrorUnmarshallerV2>();

    public AmazonGameLiftClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), configFactory.getConfig());
    }

    public AmazonGameLiftClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonGameLiftClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    public AmazonGameLiftClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonGameLiftClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    public AmazonGameLiftClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AmazonGameLiftClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(UnauthorizedException.class, "UnauthorizedException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(LimitExceededException.class, "LimitExceededException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidGameSessionStatusException.class, "InvalidGameSessionStatusException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(ConflictException.class, "ConflictException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(NotFoundException.class, "NotFoundException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InternalServiceException.class, "InternalServiceException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(FleetCapacityExceededException.class, "FleetCapacityExceededException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(TerminalRoutingStrategyException.class, "TerminalRoutingStrategyException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(GameSessionFullException.class, "GameSessionFullException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidFleetStatusException.class, "InvalidFleetStatusException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidRequestException.class, "InvalidRequestException"));
        this.jsonErrorUnmarshallers.add(JsonErrorUnmarshallerV2.DEFAULT_UNMARSHALLER);
        this.setServiceNameIntern("gamelift");
        this.setEndpointPrefix("gamelift");
        this.setEndpoint("https://gamelift.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/gamelift/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/gamelift/request.handler2s"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAliasResult createAlias(CreateAliasRequest createAliasRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createAliasRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateAliasRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateAliasRequestMarshaller().marshall((CreateAliasRequest)super.beforeMarshalling((AmazonWebServiceRequest)createAliasRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new CreateAliasResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            CreateAliasResult createAliasResult = (CreateAliasResult)response.getAwsResponse();
            return createAliasResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateBuildResult createBuild(CreateBuildRequest createBuildRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createBuildRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateBuildRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateBuildRequestMarshaller().marshall((CreateBuildRequest)super.beforeMarshalling((AmazonWebServiceRequest)createBuildRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new CreateBuildResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            CreateBuildResult createBuildResult = (CreateBuildResult)response.getAwsResponse();
            return createBuildResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateFleetResult createFleet(CreateFleetRequest createFleetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createFleetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateFleetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateFleetRequestMarshaller().marshall((CreateFleetRequest)super.beforeMarshalling((AmazonWebServiceRequest)createFleetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new CreateFleetResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            CreateFleetResult createFleetResult = (CreateFleetResult)response.getAwsResponse();
            return createFleetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateGameSessionResult createGameSession(CreateGameSessionRequest createGameSessionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createGameSessionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateGameSessionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateGameSessionRequestMarshaller().marshall((CreateGameSessionRequest)super.beforeMarshalling((AmazonWebServiceRequest)createGameSessionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new CreateGameSessionResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            CreateGameSessionResult createGameSessionResult = (CreateGameSessionResult)response.getAwsResponse();
            return createGameSessionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePlayerSessionResult createPlayerSession(CreatePlayerSessionRequest createPlayerSessionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createPlayerSessionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreatePlayerSessionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreatePlayerSessionRequestMarshaller().marshall((CreatePlayerSessionRequest)super.beforeMarshalling((AmazonWebServiceRequest)createPlayerSessionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new CreatePlayerSessionResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            CreatePlayerSessionResult createPlayerSessionResult = (CreatePlayerSessionResult)response.getAwsResponse();
            return createPlayerSessionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePlayerSessionsResult createPlayerSessions(CreatePlayerSessionsRequest createPlayerSessionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createPlayerSessionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreatePlayerSessionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreatePlayerSessionsRequestMarshaller().marshall((CreatePlayerSessionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)createPlayerSessionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new CreatePlayerSessionsResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            CreatePlayerSessionsResult createPlayerSessionsResult = (CreatePlayerSessionsResult)response.getAwsResponse();
            return createPlayerSessionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAlias(DeleteAliasRequest deleteAliasRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteAliasRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteAliasRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteAliasRequestMarshaller().marshall((DeleteAliasRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteAliasRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler(null);
            responseHandler.setIsPayloadJson(true);
            this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteBuild(DeleteBuildRequest deleteBuildRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteBuildRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteBuildRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteBuildRequestMarshaller().marshall((DeleteBuildRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteBuildRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler(null);
            responseHandler.setIsPayloadJson(true);
            this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteFleet(DeleteFleetRequest deleteFleetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteFleetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteFleetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteFleetRequestMarshaller().marshall((DeleteFleetRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteFleetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler(null);
            responseHandler.setIsPayloadJson(true);
            this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteScalingPolicy(DeleteScalingPolicyRequest deleteScalingPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteScalingPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteScalingPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteScalingPolicyRequestMarshaller().marshall((DeleteScalingPolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteScalingPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler(null);
            responseHandler.setIsPayloadJson(true);
            this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAliasResult describeAlias(DescribeAliasRequest describeAliasRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeAliasRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeAliasRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeAliasRequestMarshaller().marshall((DescribeAliasRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeAliasRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new DescribeAliasResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeAliasResult describeAliasResult = (DescribeAliasResult)response.getAwsResponse();
            return describeAliasResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeBuildResult describeBuild(DescribeBuildRequest describeBuildRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeBuildRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeBuildRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeBuildRequestMarshaller().marshall((DescribeBuildRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeBuildRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new DescribeBuildResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeBuildResult describeBuildResult = (DescribeBuildResult)response.getAwsResponse();
            return describeBuildResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeEC2InstanceLimitsResult describeEC2InstanceLimits(DescribeEC2InstanceLimitsRequest describeEC2InstanceLimitsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeEC2InstanceLimitsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeEC2InstanceLimitsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeEC2InstanceLimitsRequestMarshaller().marshall((DescribeEC2InstanceLimitsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeEC2InstanceLimitsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new DescribeEC2InstanceLimitsResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeEC2InstanceLimitsResult describeEC2InstanceLimitsResult = (DescribeEC2InstanceLimitsResult)response.getAwsResponse();
            return describeEC2InstanceLimitsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeFleetAttributesResult describeFleetAttributes(DescribeFleetAttributesRequest describeFleetAttributesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeFleetAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeFleetAttributesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeFleetAttributesRequestMarshaller().marshall((DescribeFleetAttributesRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeFleetAttributesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new DescribeFleetAttributesResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeFleetAttributesResult describeFleetAttributesResult = (DescribeFleetAttributesResult)response.getAwsResponse();
            return describeFleetAttributesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeFleetCapacityResult describeFleetCapacity(DescribeFleetCapacityRequest describeFleetCapacityRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeFleetCapacityRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeFleetCapacityRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeFleetCapacityRequestMarshaller().marshall((DescribeFleetCapacityRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeFleetCapacityRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new DescribeFleetCapacityResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeFleetCapacityResult describeFleetCapacityResult = (DescribeFleetCapacityResult)response.getAwsResponse();
            return describeFleetCapacityResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeFleetEventsResult describeFleetEvents(DescribeFleetEventsRequest describeFleetEventsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeFleetEventsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeFleetEventsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeFleetEventsRequestMarshaller().marshall((DescribeFleetEventsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeFleetEventsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new DescribeFleetEventsResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeFleetEventsResult describeFleetEventsResult = (DescribeFleetEventsResult)response.getAwsResponse();
            return describeFleetEventsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeFleetPortSettingsResult describeFleetPortSettings(DescribeFleetPortSettingsRequest describeFleetPortSettingsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeFleetPortSettingsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeFleetPortSettingsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeFleetPortSettingsRequestMarshaller().marshall((DescribeFleetPortSettingsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeFleetPortSettingsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new DescribeFleetPortSettingsResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeFleetPortSettingsResult describeFleetPortSettingsResult = (DescribeFleetPortSettingsResult)response.getAwsResponse();
            return describeFleetPortSettingsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeFleetUtilizationResult describeFleetUtilization(DescribeFleetUtilizationRequest describeFleetUtilizationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeFleetUtilizationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeFleetUtilizationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeFleetUtilizationRequestMarshaller().marshall((DescribeFleetUtilizationRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeFleetUtilizationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new DescribeFleetUtilizationResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeFleetUtilizationResult describeFleetUtilizationResult = (DescribeFleetUtilizationResult)response.getAwsResponse();
            return describeFleetUtilizationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeGameSessionDetailsResult describeGameSessionDetails(DescribeGameSessionDetailsRequest describeGameSessionDetailsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeGameSessionDetailsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeGameSessionDetailsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeGameSessionDetailsRequestMarshaller().marshall((DescribeGameSessionDetailsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeGameSessionDetailsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new DescribeGameSessionDetailsResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeGameSessionDetailsResult describeGameSessionDetailsResult = (DescribeGameSessionDetailsResult)response.getAwsResponse();
            return describeGameSessionDetailsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeGameSessionsResult describeGameSessions(DescribeGameSessionsRequest describeGameSessionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeGameSessionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeGameSessionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeGameSessionsRequestMarshaller().marshall((DescribeGameSessionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeGameSessionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new DescribeGameSessionsResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeGameSessionsResult describeGameSessionsResult = (DescribeGameSessionsResult)response.getAwsResponse();
            return describeGameSessionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribePlayerSessionsResult describePlayerSessions(DescribePlayerSessionsRequest describePlayerSessionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describePlayerSessionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribePlayerSessionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribePlayerSessionsRequestMarshaller().marshall((DescribePlayerSessionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describePlayerSessionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new DescribePlayerSessionsResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribePlayerSessionsResult describePlayerSessionsResult = (DescribePlayerSessionsResult)response.getAwsResponse();
            return describePlayerSessionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeScalingPoliciesResult describeScalingPolicies(DescribeScalingPoliciesRequest describeScalingPoliciesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeScalingPoliciesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeScalingPoliciesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeScalingPoliciesRequestMarshaller().marshall((DescribeScalingPoliciesRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeScalingPoliciesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new DescribeScalingPoliciesResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeScalingPoliciesResult describeScalingPoliciesResult = (DescribeScalingPoliciesResult)response.getAwsResponse();
            return describeScalingPoliciesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetGameSessionLogUrlResult getGameSessionLogUrl(GetGameSessionLogUrlRequest getGameSessionLogUrlRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getGameSessionLogUrlRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetGameSessionLogUrlRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetGameSessionLogUrlRequestMarshaller().marshall((GetGameSessionLogUrlRequest)super.beforeMarshalling((AmazonWebServiceRequest)getGameSessionLogUrlRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new GetGameSessionLogUrlResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            GetGameSessionLogUrlResult getGameSessionLogUrlResult = (GetGameSessionLogUrlResult)response.getAwsResponse();
            return getGameSessionLogUrlResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAliasesResult listAliases(ListAliasesRequest listAliasesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAliasesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAliasesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAliasesRequestMarshaller().marshall((ListAliasesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listAliasesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new ListAliasesResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListAliasesResult listAliasesResult = (ListAliasesResult)response.getAwsResponse();
            return listAliasesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListBuildsResult listBuilds(ListBuildsRequest listBuildsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listBuildsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListBuildsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListBuildsRequestMarshaller().marshall((ListBuildsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listBuildsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new ListBuildsResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListBuildsResult listBuildsResult = (ListBuildsResult)response.getAwsResponse();
            return listBuildsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListFleetsResult listFleets(ListFleetsRequest listFleetsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listFleetsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListFleetsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListFleetsRequestMarshaller().marshall((ListFleetsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listFleetsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new ListFleetsResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListFleetsResult listFleetsResult = (ListFleetsResult)response.getAwsResponse();
            return listFleetsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutScalingPolicyResult putScalingPolicy(PutScalingPolicyRequest putScalingPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putScalingPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutScalingPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutScalingPolicyRequestMarshaller().marshall((PutScalingPolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)putScalingPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new PutScalingPolicyResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            PutScalingPolicyResult putScalingPolicyResult = (PutScalingPolicyResult)response.getAwsResponse();
            return putScalingPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RequestUploadCredentialsResult requestUploadCredentials(RequestUploadCredentialsRequest requestUploadCredentialsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(requestUploadCredentialsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RequestUploadCredentialsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RequestUploadCredentialsRequestMarshaller().marshall((RequestUploadCredentialsRequest)super.beforeMarshalling((AmazonWebServiceRequest)requestUploadCredentialsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new RequestUploadCredentialsResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            RequestUploadCredentialsResult requestUploadCredentialsResult = (RequestUploadCredentialsResult)response.getAwsResponse();
            return requestUploadCredentialsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResolveAliasResult resolveAlias(ResolveAliasRequest resolveAliasRequest) {
        ExecutionContext executionContext = this.createExecutionContext(resolveAliasRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ResolveAliasRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ResolveAliasRequestMarshaller().marshall((ResolveAliasRequest)super.beforeMarshalling((AmazonWebServiceRequest)resolveAliasRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new ResolveAliasResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ResolveAliasResult resolveAliasResult = (ResolveAliasResult)response.getAwsResponse();
            return resolveAliasResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateAliasResult updateAlias(UpdateAliasRequest updateAliasRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateAliasRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateAliasRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateAliasRequestMarshaller().marshall((UpdateAliasRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateAliasRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new UpdateAliasResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            UpdateAliasResult updateAliasResult = (UpdateAliasResult)response.getAwsResponse();
            return updateAliasResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateBuildResult updateBuild(UpdateBuildRequest updateBuildRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateBuildRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateBuildRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateBuildRequestMarshaller().marshall((UpdateBuildRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateBuildRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new UpdateBuildResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            UpdateBuildResult updateBuildResult = (UpdateBuildResult)response.getAwsResponse();
            return updateBuildResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateFleetAttributesResult updateFleetAttributes(UpdateFleetAttributesRequest updateFleetAttributesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateFleetAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateFleetAttributesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateFleetAttributesRequestMarshaller().marshall((UpdateFleetAttributesRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateFleetAttributesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new UpdateFleetAttributesResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            UpdateFleetAttributesResult updateFleetAttributesResult = (UpdateFleetAttributesResult)response.getAwsResponse();
            return updateFleetAttributesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateFleetCapacityResult updateFleetCapacity(UpdateFleetCapacityRequest updateFleetCapacityRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateFleetCapacityRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateFleetCapacityRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateFleetCapacityRequestMarshaller().marshall((UpdateFleetCapacityRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateFleetCapacityRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new UpdateFleetCapacityResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            UpdateFleetCapacityResult updateFleetCapacityResult = (UpdateFleetCapacityResult)response.getAwsResponse();
            return updateFleetCapacityResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateFleetPortSettingsResult updateFleetPortSettings(UpdateFleetPortSettingsRequest updateFleetPortSettingsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateFleetPortSettingsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateFleetPortSettingsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateFleetPortSettingsRequestMarshaller().marshall((UpdateFleetPortSettingsRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateFleetPortSettingsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new UpdateFleetPortSettingsResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            UpdateFleetPortSettingsResult updateFleetPortSettingsResult = (UpdateFleetPortSettingsResult)response.getAwsResponse();
            return updateFleetPortSettingsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateGameSessionResult updateGameSession(UpdateGameSessionRequest updateGameSessionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateGameSessionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateGameSessionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateGameSessionRequestMarshaller().marshall((UpdateGameSessionRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateGameSessionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new UpdateGameSessionResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            UpdateGameSessionResult updateGameSessionResult = (UpdateGameSessionResult)response.getAwsResponse();
            return updateGameSessionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        AWSCredentials credentials;
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.CredentialsRequestTime);
        try {
            credentials = this.awsCredentialsProvider.getCredentials();
        }
        finally {
            awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.CredentialsRequestTime);
        }
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setCredentials(credentials);
        JsonErrorResponseHandlerV2 errorResponseHandler = new JsonErrorResponseHandlerV2(this.jsonErrorUnmarshallers);
        return this.client.execute(request, responseHandler, (HttpResponseHandler)errorResponseHandler, executionContext);
    }
}

