/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.gamelift.model.CreateGameSessionRequest;
import com.amazonaws.services.gamelift.model.GameProperty;
import com.amazonaws.services.gamelift.model.transform.GamePropertyJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class CreateGameSessionRequestMarshaller
implements Marshaller<Request<CreateGameSessionRequest>, CreateGameSessionRequest> {
    public Request<CreateGameSessionRequest> marshall(CreateGameSessionRequest createGameSessionRequest) {
        if (createGameSessionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createGameSessionRequest, "AmazonGameLift");
        request.addHeader("X-Amz-Target", "GameLift.CreateGameSession");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<GameProperty> gamePropertiesList;
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            if (createGameSessionRequest.getFleetId() != null) {
                jsonGenerator.writeFieldName("FleetId").writeValue(createGameSessionRequest.getFleetId());
            }
            if (createGameSessionRequest.getAliasId() != null) {
                jsonGenerator.writeFieldName("AliasId").writeValue(createGameSessionRequest.getAliasId());
            }
            if (createGameSessionRequest.getMaximumPlayerSessionCount() != null) {
                jsonGenerator.writeFieldName("MaximumPlayerSessionCount").writeValue((long)createGameSessionRequest.getMaximumPlayerSessionCount().intValue());
            }
            if (createGameSessionRequest.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(createGameSessionRequest.getName());
            }
            if ((gamePropertiesList = createGameSessionRequest.getGameProperties()) != null) {
                jsonGenerator.writeFieldName("GameProperties");
                jsonGenerator.writeStartArray();
                for (GameProperty gamePropertiesListValue : gamePropertiesList) {
                    if (gamePropertiesListValue == null) continue;
                    GamePropertyJsonMarshaller.getInstance().marshall(gamePropertiesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

