/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.gamelift.model.UpdateBuildRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class UpdateBuildRequestMarshaller
implements Marshaller<Request<UpdateBuildRequest>, UpdateBuildRequest> {
    public Request<UpdateBuildRequest> marshall(UpdateBuildRequest updateBuildRequest) {
        if (updateBuildRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateBuildRequest, "AmazonGameLift");
        request.addHeader("X-Amz-Target", "GameLift.UpdateBuild");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            if (updateBuildRequest.getBuildId() != null) {
                jsonGenerator.writeFieldName("BuildId").writeValue(updateBuildRequest.getBuildId());
            }
            if (updateBuildRequest.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(updateBuildRequest.getName());
            }
            if (updateBuildRequest.getVersion() != null) {
                jsonGenerator.writeFieldName("Version").writeValue(updateBuildRequest.getVersion());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

