/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.gamelift.model.CreatePlayerSessionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class CreatePlayerSessionRequestMarshaller
implements Marshaller<Request<CreatePlayerSessionRequest>, CreatePlayerSessionRequest> {
    public Request<CreatePlayerSessionRequest> marshall(CreatePlayerSessionRequest createPlayerSessionRequest) {
        if (createPlayerSessionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createPlayerSessionRequest, "AmazonGameLift");
        request.addHeader("X-Amz-Target", "GameLift.CreatePlayerSession");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            if (createPlayerSessionRequest.getGameSessionId() != null) {
                jsonGenerator.writeFieldName("GameSessionId").writeValue(createPlayerSessionRequest.getGameSessionId());
            }
            if (createPlayerSessionRequest.getPlayerId() != null) {
                jsonGenerator.writeFieldName("PlayerId").writeValue(createPlayerSessionRequest.getPlayerId());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

